/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.fluid;

import earth.terrarium.pastel.blocks.decay.BlackMateriaBlock;
import earth.terrarium.pastel.blocks.fluid.MidnightSolutionFluidBlock;
import earth.terrarium.pastel.blocks.fluid.PastelFluid;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.particle.effect.ColoredSparkleRisingParticleEffect;
import earth.terrarium.pastel.recipe.fluid_converting.FluidConvertingRecipe;
import earth.terrarium.pastel.registries.PastelBiomes;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelFluidTags;
import earth.terrarium.pastel.registries.PastelFluids;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class MidnightSolutionFluid
extends PastelFluid {
    private static final int EXPERIENCE_DISENCHANT_RETURN_DIV = 3;

    public Fluid getSource() {
        return (Fluid)PastelFluids.MIDNIGHT_SOLUTION.get();
    }

    public Fluid getFlowing() {
        return (Fluid)PastelFluids.FLOWING_MIDNIGHT_SOLUTION.get();
    }

    public Item getBucket() {
        return (Item)PastelItems.MIDNIGHT_SOLUTION_BUCKET.get();
    }

    public FluidType getFluidType() {
        return (FluidType)PastelFluids.MIDNIGHT_SOLUTION_TYPE.get();
    }

    protected BlockState createLegacyBlock(FluidState fluidState) {
        return (BlockState)((Block)PastelBlocks.MIDNIGHT_SOLUTION.get()).defaultBlockState().setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(MidnightSolutionFluid.getLegacyLevel((FluidState)fluidState)));
    }

    @Override
    public boolean isSame(Fluid fluid) {
        return fluid == PastelFluids.MIDNIGHT_SOLUTION.get() || fluid == PastelFluids.FLOWING_MIDNIGHT_SOLUTION.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(Level world, BlockPos pos, FluidState state, RandomSource random) {
        BlockPos topPos = pos.above();
        BlockState topState = world.getBlockState(topPos);
        if (topState.isAir() && !topState.isSolidRender((BlockGetter)world, topPos) && random.nextInt(2000) == 0) {
            world.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), PastelSounds.MIDNIGHT_SOLUTION_AMBIENT, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
        }
    }

    @Override
    protected int getSlopeFindDistance(LevelReader worldView) {
        return 5;
    }

    public void tick(Level world, BlockPos pos, FluidState state) {
        boolean converted;
        super.tick(world, pos, state);
        if ((double)state.getOwnHeight() < 1.0) {
            for (Direction direction : Direction.values()) {
                if (MidnightSolutionFluidBlock.tryConvertNeighbor(world, pos.relative(direction))) break;
            }
        }
        if (converted = BlackMateriaBlock.spreadBlackMateria(world, pos, world.random, MidnightSolutionFluidBlock.SPREAD_BLOCKSTATE)) {
            world.scheduleTick(pos, state.getType(), 400 + world.random.nextInt(800));
        }
    }

    @Override
    public int getTickDelay(LevelReader worldView) {
        return 12;
    }

    public ParticleOptions getDripParticle() {
        return PastelParticleTypes.DRIPPING_MIDNIGHT_SOLUTION;
    }

    @Override
    public ParticleOptions getSplashParticle() {
        return PastelParticleTypes.MIDNIGHT_SOLUTION_SPLASH;
    }

    @Override
    public void onEntityCollision(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.onEntityCollision(state, level, pos, entity);
        if (!level.isClientSide) {
            ItemEntity itemEntity;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (!livingEntity.isDeadOrDying() && level.getGameTime() % 20L == 0L) {
                    float damageMult = 1.0f;
                    if (level.getBiome(pos).is(PastelBiomes.BLACK_LANGAST)) {
                        damageMult = 9.0f;
                    }
                    if (livingEntity.isEyeInFluid(PastelFluidTags.MIDNIGHT_SOLUTION)) {
                        livingEntity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 50, 0));
                        livingEntity.hurt(PastelDamageTypes.midnightSolution(level), 2.0f * damageMult);
                    } else {
                        livingEntity.hurt(PastelDamageTypes.midnightSolution(level), damageMult);
                    }
                    if (livingEntity.isDeadOrDying()) {
                        livingEntity.spawnAtLocation(((Item)PastelItems.MIDNIGHT_CHIP.get()).getDefaultInstance());
                    }
                }
            } else if (entity instanceof ItemEntity && !(itemEntity = (ItemEntity)entity).hasPickUpDelay() && level.random.nextInt(120) == 0) {
                MidnightSolutionFluid.disenchantItemAndSpawnXP(level, itemEntity);
            }
        }
    }

    @Override
    public RecipeType<? extends FluidConvertingRecipe> getDippingRecipeType() {
        return PastelRecipeTypes.MIDNIGHT_SOLUTION_CONVERTING;
    }

    private static void disenchantItemAndSpawnXP(Level world, ItemEntity itemEntity) {
        ItemStack itemStack = itemEntity.getItem();
        ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)itemStack);
        if (!enchantments.isEmpty()) {
            int randomEnchantmentIndex = world.random.nextInt(enchantments.size());
            Object2IntMap.Entry entry = (Object2IntMap.Entry)enchantments.entrySet().stream().toList().get(randomEnchantmentIndex);
            Tuple<ItemStack, Integer> result = Ench.removeEnchantments(itemStack, (Holder)entry.getKey());
            if ((Integer)result.getB() > 0) {
                MidnightSolutionFluid.spawnXP(world, itemEntity, Ench.getEnchantmentCost((Holder<Enchantment>)((Holder)entry.getKey()), entry.getIntValue(), itemStack.getEnchantmentValue()));
                itemEntity.setItem((ItemStack)result.getA());
                itemEntity.setDefaultPickUpDelay();
            }
        } else if (itemStack.is((Item)PastelItems.ENCHANTMENT_CANVAS.get()) && itemStack.has(PastelDataComponentTypes.CANVAS_ENCHANTMENTS)) {
            ItemEnchantments canvas = (ItemEnchantments)itemStack.get(PastelDataComponentTypes.CANVAS_ENCHANTMENTS);
            Item boundItem = (Item)BuiltInRegistries.ITEM.get((ResourceLocation)itemStack.get(PastelDataComponentTypes.BOUND_ITEM));
            if (!canvas.isEmpty()) {
                int randomEnchantmentIndex = world.random.nextInt(canvas.size());
                Object2IntMap.Entry entry = (Object2IntMap.Entry)canvas.entrySet().stream().toList().get(randomEnchantmentIndex);
                ItemEnchantments.Mutable builder = new ItemEnchantments.Mutable(canvas);
                builder.set((Holder)entry.getKey(), 0);
                MidnightSolutionFluid.spawnXP(world, itemEntity, Ench.getEnchantmentCost((Holder<Enchantment>)((Holder)entry.getKey()), entry.getIntValue(), 1));
                ItemEnchantments targetEnchants = builder.toImmutable();
                if (targetEnchants.isEmpty()) {
                    itemStack.remove(PastelDataComponentTypes.CANVAS_ENCHANTMENTS);
                } else {
                    itemStack.set(PastelDataComponentTypes.CANVAS_ENCHANTMENTS, (Object)targetEnchants);
                }
                itemEntity.setDefaultPickUpDelay();
            }
        }
    }

    private static void spawnXP(Level world, ItemEntity itemEntity, int exp) {
        if ((exp /= 3) > 0) {
            ExperienceOrb experienceOrbEntity = new ExperienceOrb(world, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), exp);
            world.addFreshEntity((Entity)experienceOrbEntity);
        }
        world.playSound(null, itemEntity.blockPosition(), SoundEvents.GRINDSTONE_USE, SoundSource.NEUTRAL, 1.0f, 0.9f + world.getRandom().nextFloat() * 0.2f);
        PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity((ServerLevel)world, itemEntity.position(), ColoredSparkleRisingParticleEffect.GRAY, 10, Vec3.ZERO, new Vec3(0.2, 0.4, 0.2));
    }

    public static class Still
    extends MidnightSolutionFluid {
        public int getAmount(FluidState fluidState) {
            return 8;
        }

        public boolean isSource(FluidState fluidState) {
            return true;
        }
    }

    public static class Flowing
    extends MidnightSolutionFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState fluidState) {
            return (Integer)fluidState.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState fluidState) {
            return false;
        }
    }
}

