/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.fluid;

import earth.terrarium.pastel.blocks.fluid.PastelFluid;
import earth.terrarium.pastel.blocks.fluid.PastelFluidBlock;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelFluidTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DragonrotFluidBlock
extends PastelFluidBlock {
    public DragonrotFluidBlock(PastelFluid fluid, BlockState ultrawarmReplacementBlockState, BlockBehaviour.Properties settings) {
        super(fluid, ultrawarmReplacementBlockState, settings);
    }

    @Override
    public SimpleParticleType getSplashParticle() {
        return PastelParticleTypes.DRAGONROT;
    }

    @Override
    public Tuple<SimpleParticleType, SimpleParticleType> getFishingParticles() {
        return new Tuple((Object)PastelParticleTypes.DRAGONROT, (Object)PastelParticleTypes.DRAGONROT_FISHING);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(state, world, pos, random);
        if (!world.getBlockState(pos.above()).isRedstoneConductor((BlockGetter)world, pos.above()) && random.nextFloat() < 0.03f) {
            world.addParticle((ParticleOptions)PastelParticleTypes.DRAGONROT, (double)pos.getX() + random.nextDouble(), (double)(pos.getY() + 1), (double)pos.getZ() + random.nextDouble(), 0.0, random.nextDouble() * 0.1, 0.0);
        }
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @Override
    @Nullable
    public BlockState handleFluidCollision(Level world, @NotNull FluidState state, @NotNull FluidState otherState) {
        if (otherState.is(FluidTags.WATER)) {
            return ((Block)PastelBlocks.SLUSH.get()).defaultBlockState();
        }
        if (otherState.is(FluidTags.LAVA)) {
            return Blocks.BLACKSTONE.defaultBlockState();
        }
        if (otherState.is(PastelFluidTags.HUMUS)) {
            return Blocks.COARSE_DIRT.defaultBlockState();
        }
        if (otherState.is(PastelFluidTags.LIQUID_CRYSTAL)) {
            return ((Block)PastelBlocks.FLAYED_EARTH.get()).defaultBlockState();
        }
        if (otherState.is(PastelFluidTags.MIDNIGHT_SOLUTION)) {
            return ((Block)PastelBlocks.HORNSLAKE.get()).defaultBlockState();
        }
        return null;
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return PathType.DAMAGE_OTHER;
    }

    @Nullable
    public PathType getAdjacentBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, PathType originalType) {
        return PathType.DAMAGE_OTHER;
    }
}

