/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.fluid;

import earth.terrarium.pastel.blocks.fluid.PastelFluid;
import earth.terrarium.pastel.injectors.MobEffectInstanceInjector;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.recipe.fluid_converting.FluidConvertingRecipe;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelEntityTypeTags;
import earth.terrarium.pastel.registries.PastelFluidTags;
import earth.terrarium.pastel.registries.PastelFluids;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelMobEffects;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class DragonrotFluid
extends PastelFluid {
    public Fluid getSource() {
        return (Fluid)PastelFluids.DRAGONROT.get();
    }

    public Fluid getFlowing() {
        return (Fluid)PastelFluids.FLOWING_DRAGONROT.get();
    }

    public Item getBucket() {
        return (Item)PastelItems.DRAGONROT_BUCKET.get();
    }

    public FluidType getFluidType() {
        return (FluidType)PastelFluids.DRAGONROT_TYPE.get();
    }

    protected BlockState createLegacyBlock(FluidState fluidState) {
        return (BlockState)((Block)PastelBlocks.DRAGONROT.get()).defaultBlockState().setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(DragonrotFluid.getLegacyLevel((FluidState)fluidState)));
    }

    @Override
    public boolean isSame(Fluid fluid) {
        return fluid == PastelFluids.DRAGONROT.get() || fluid == PastelFluids.FLOWING_DRAGONROT.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(Level world, BlockPos pos, FluidState state, RandomSource random) {
        BlockPos topPos = pos.above();
        BlockState topState = world.getBlockState(topPos);
        if (topState.isAir() && random.nextInt(3) == 0) {
            float soundRandom = random.nextFloat();
            if (soundRandom < 3.0E-4f) {
                world.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.HONEY_DRINK, SoundSource.AMBIENT, random.nextFloat() * 0.65f + 0.25f, random.nextFloat() * 0.2f, false);
            } else if (soundRandom < 6.0E-4f) {
                world.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.HONEY_BLOCK_SLIDE, SoundSource.AMBIENT, random.nextFloat() * 0.4f + 0.25f, random.nextFloat() * 0.5f + 0.1f, false);
            } else if (soundRandom < 8.0E-4f) {
                world.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.FROG_AMBIENT, SoundSource.AMBIENT, random.nextFloat() + 0.25f, random.nextFloat() * 0.3f + 0.01f, false);
            } else if (soundRandom < 0.001f) {
                world.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.SCULK_BLOCK_PLACE, SoundSource.AMBIENT, random.nextFloat() + 0.25f, random.nextFloat() * 0.4f + 0.2f, false);
            } else if (soundRandom < 0.00148f) {
                world.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.PARROT_DEATH, SoundSource.AMBIENT, random.nextFloat() * 0.334f + 0.1f, 1.0f, false);
            } else if (soundRandom < 0.00152f) {
                world.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.CAT_DEATH, SoundSource.AMBIENT, random.nextFloat() * 0.334f + 0.1f, 1.0f, false);
            } else if (soundRandom < 0.00156f) {
                world.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.WOLF_DEATH, SoundSource.AMBIENT, random.nextFloat() * 0.3f + 0.1f, 1.0f, false);
            } else if (soundRandom < 0.001564f) {
                world.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.SCULK_SHRIEKER_SHRIEK, SoundSource.AMBIENT, 2.0f, 0.1f, false);
            }
        }
    }

    @Override
    protected int getDropOff(LevelReader worldView) {
        return 3;
    }

    @Override
    public int getTickDelay(LevelReader worldView) {
        return 40;
    }

    public ParticleOptions getDripParticle() {
        return PastelParticleTypes.DRIPPING_DRAGONROT;
    }

    @Override
    public ParticleOptions getSplashParticle() {
        return PastelParticleTypes.DRAGONROT_SPLASH;
    }

    @Override
    public void onEntityCollision(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.onEntityCollision(state, level, pos, entity);
        if (level instanceof ServerLevel) {
            LivingEntity livingEntity;
            ServerLevel serverWorld = (ServerLevel)level;
            if (entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).isDeadOrDying() && level.getGameTime() % 20L == 0L && !(livingEntity instanceof Enemy)) {
                int cut;
                boolean dragon = entity.getType().is(PastelEntityTypeTags.DRACONIC);
                int damage = dragon ? 30 : 6;
                int ticks = dragon ? 20 : 5;
                int n = cut = dragon ? 100 : 40;
                if (livingEntity.isEyeInFluid(PastelFluidTags.DRAGONROT)) {
                    livingEntity.hurt(PastelDamageTypes.dragonrot(level), (float)damage);
                } else {
                    livingEntity.hurt(PastelDamageTypes.dragonrot(level), (float)damage / 2.0f);
                }
                if (!livingEntity.isDeadOrDying()) {
                    MobEffectInstance existingEffect = livingEntity.getEffect(PastelMobEffects.LIFE_DRAIN);
                    if (existingEffect == null) {
                        livingEntity.addEffect(new MobEffectInstance(PastelMobEffects.LIFE_DRAIN, 600, 0));
                    } else if (existingEffect.getDuration() < 500) {
                        ((MobEffectInstanceInjector)existingEffect).setDuration(300);
                        serverWorld.getChunkSource().broadcastAndSend((Entity)livingEntity, (Packet)new ClientboundUpdateMobEffectPacket(livingEntity.getId(), existingEffect, true));
                    }
                    existingEffect = livingEntity.getEffect(PastelMobEffects.DEADLY_POISON);
                    if (existingEffect == null || existingEffect.getDuration() < 80) {
                        livingEntity.addEffect(new MobEffectInstance(PastelMobEffects.DEADLY_POISON, 160, 0));
                    }
                    if ((existingEffect = livingEntity.getEffect(PastelMobEffects.IMMUNITY)) != null) {
                        if (existingEffect.getDuration() <= cut) {
                            livingEntity.removeEffect(PastelMobEffects.IMMUNITY);
                        } else {
                            ((MobEffectInstanceInjector)existingEffect).setDuration(existingEffect.getDuration() - cut);
                            serverWorld.getChunkSource().broadcastAndSend((Entity)livingEntity, (Packet)new ClientboundUpdateMobEffectPacket(livingEntity.getId(), existingEffect, true));
                        }
                    }
                    if (!dragon) {
                        return;
                    }
                    existingEffect = livingEntity.getEffect(PastelMobEffects.DENSITY);
                    if (existingEffect == null || existingEffect.getDuration() < 120) {
                        livingEntity.addEffect(new MobEffectInstance(PastelMobEffects.DENSITY, 2000, 1));
                    }
                }
            }
        }
    }

    @Override
    public RecipeType<? extends FluidConvertingRecipe> getDippingRecipeType() {
        return PastelRecipeTypes.DRAGONROT_CONVERTING;
    }

    public static class Still
    extends DragonrotFluid {
        public int getAmount(FluidState fluidState) {
            return 8;
        }

        public boolean isSource(FluidState fluidState) {
            return true;
        }
    }

    public static class Flowing
    extends DragonrotFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState fluidState) {
            return (Integer)fluidState.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState fluidState) {
            return false;
        }
    }
}

