/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.farming;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PastelFarmlandBlock
extends FarmBlock {
    protected final BlockState bareState;

    public PastelFarmlandBlock(BlockBehaviour.Properties settings, BlockState bareState) {
        super(settings);
        this.bareState = bareState;
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            this.setBare(null, state, (Level)world, pos);
        }
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int i = (Integer)state.getValue((Property)MOISTURE);
        if (!this.isNearWater((LevelReader)world, pos) && !world.isRainingAt(pos.above())) {
            if (i > 0) {
                world.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!PastelFarmlandBlock.shouldMaintainFarmland((BlockGetter)world, pos)) {
                this.setBare(null, state, (Level)world, pos);
            }
        } else if (i < 7) {
            world.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!world.isClientSide && world.random.nextFloat() < fallDistance - 1.0f && entity instanceof LivingEntity && (entity instanceof Player || world.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) && entity.getBbWidth() * entity.getBbWidth() * entity.getBbHeight() > 0.512f) {
            this.setBare(entity, state, world, pos);
        }
        entity.causeFallDamage(fallDistance, 1.0f, world.damageSources().fall());
    }

    public void setBare(@Nullable Entity entity, BlockState state, Level world, BlockPos pos) {
        BlockState blockState = PastelFarmlandBlock.pushEntitiesUp((BlockState)state, (BlockState)this.bareState, (LevelAccessor)world, (BlockPos)pos);
        world.setBlockAndUpdate(pos, blockState);
        world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)blockState));
    }

    public static boolean shouldMaintainFarmland(@NotNull BlockGetter world, @NotNull BlockPos pos) {
        Block block = world.getBlockState(pos.above()).getBlock();
        return block instanceof CropBlock || block instanceof StemBlock || block instanceof AttachedStemBlock;
    }

    protected boolean isNearWater(LevelReader world, BlockPos pos) {
        for (BlockPos testPos : BlockPos.betweenClosed((BlockPos)pos.offset(-4, 0, -4), (BlockPos)pos.offset(4, 1, 4))) {
            if (!world.getFluidState(testPos).is(FluidTags.WATER)) continue;
            return true;
        }
        return false;
    }
}

