/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.energy;

import earth.terrarium.pastel.api.block.PlayerOwned;
import earth.terrarium.pastel.api.block.PlayerOwnedWithName;
import earth.terrarium.pastel.data_loaders.CrystalApothecarySimulationsDataLoader;
import earth.terrarium.pastel.events.game.PastelGameEvents;
import earth.terrarium.pastel.events.listeners.BlockPosEventQueue;
import earth.terrarium.pastel.events.listeners.EventQueue;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.interaction.InventoryHelper;
import earth.terrarium.pastel.inventories.GenericPastelContainerScreenHandler;
import earth.terrarium.pastel.inventories.ScreenBackgroundVariant;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelBlockTags;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class CrystalApothecaryBlockEntity
extends RandomizableContainerBlockEntity
implements PlayerOwnedWithName,
EventQueue.Callback<BlockPosEventQueue.EventEntry> {
    private static final int RANGE = 12;
    private static final ItemStack HARVEST_ITEMSTACK = ItemStack.EMPTY;
    private final BlockPosEventQueue blockPosEventTransferListener;
    protected long compensationWorldTime;
    private NonNullList<ItemStack> inventory;
    private boolean listenerPaused;
    private UUID ownerUUID;
    private String ownerName;

    public CrystalApothecaryBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)PastelBlockEntities.CRYSTAL_APOTHECARY.get(), blockPos, blockState);
        this.blockPosEventTransferListener = new BlockPosEventQueue((PositionSource)new BlockPositionSource(this.worldPosition), 12, this);
        this.inventory = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
        this.listenerPaused = false;
        this.compensationWorldTime = -1L;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, CrystalApothecaryBlockEntity blockEntity) {
        if (!world.isClientSide) {
            blockEntity.blockPosEventTransferListener.tick(world);
            if (world.getGameTime() % 1000L == 0L) {
                blockEntity.listenerPaused = false;
            }
            if (blockEntity.compensationWorldTime > 0L) {
                long compensationTicks = world.getGameTime() - blockEntity.compensationWorldTime;
                if (compensationTicks > 1200L) {
                    CrystalApothecaryBlockEntity.compensateGemstoneClusterDropsForUnloadedTicks(world, pos, blockEntity, compensationTicks);
                }
                blockEntity.compensationWorldTime = -1L;
            }
        }
    }

    private static void compensateGemstoneClusterDropsForUnloadedTicks(Level world, BlockPos blockPos, CrystalApothecaryBlockEntity blockEntity, long ticksToCompensate) {
        HashMap<Block, Integer> matches = new HashMap<Block, Integer>();
        Set<Block> compensationBlocks = CrystalApothecarySimulationsDataLoader.COMPENSATIONS.keySet();
        for (BlockPos pos : BlockPos.withinManhattan((BlockPos)blockPos, (int)12, (int)12, (int)12)) {
            BlockState state;
            Block block;
            if (!blockPos.closerThan((Vec3i)pos, 12.0) || !compensationBlocks.contains(block = (state = world.getBlockState(pos)).getBlock())) continue;
            int validBlocks = CrystalApothecaryBlockEntity.countValidGemstoneClusterBlocksAroundBlockPos(world, pos, CrystalApothecarySimulationsDataLoader.COMPENSATIONS.get(block).validNeighbors());
            if (matches.containsKey(block)) {
                matches.put(block, (Integer)matches.get(block) + validBlocks);
                continue;
            }
            matches.put(block, validBlocks);
        }
        double gameRuleTickModifier = (double)((GameRules.IntegerValue)world.getGameRules().getRule(GameRules.RULE_RANDOMTICKING)).get() / 3.0;
        for (Map.Entry match : matches.entrySet()) {
            CrystalApothecarySimulationsDataLoader.SimulatedBlockGrowthEntry drop = CrystalApothecarySimulationsDataLoader.COMPENSATIONS.get(match.getKey());
            int compensatedItemCount = (int)((double)(drop.compensatedStack().getCount() * (Integer)match.getValue()) * gameRuleTickModifier * (double)ticksToCompensate) / drop.ticksForCompensationLootPerValidNeighbor();
            if ((compensatedItemCount = (int)((double)compensatedItemCount * (0.8 + (double)world.random.nextFloat() * 0.4))) <= 0) continue;
            ItemStack compensatedStack = drop.compensatedStack().copy();
            compensatedStack.setCount(compensatedItemCount);
            ItemStack remainingStack = InventoryHelper.smartAddToInventory(compensatedStack, (IItemHandlerModifiable)new InvWrapper((Container)blockEntity), null);
            if (remainingStack.isEmpty()) continue;
            break;
        }
    }

    public static int countValidGemstoneClusterBlocksAroundBlockPos(Level world, BlockPos blockPos, Collection<Block> allowedBlocks) {
        int count = 0;
        for (Direction direction : Direction.values()) {
            BlockState offsetState = world.getBlockState(blockPos.relative(direction));
            if (!offsetState.isAir() && offsetState.getBlock() != Blocks.WATER && !allowedBlocks.contains(offsetState.getBlock())) continue;
            ++count;
        }
        return count;
    }

    protected Component getDefaultName() {
        if (this.hasOwner()) {
            return Component.translatable((String)"block.pastel.crystal_apothecary.owner", (Object[])new Object[]{this.ownerName});
        }
        return Component.translatable((String)"block.pastel.crystal_apothecary");
    }

    public BlockPosEventQueue getEventListener() {
        return this.blockPosEventTransferListener;
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(nbt)) {
            ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)registryLookup);
        }
        this.ownerUUID = PlayerOwned.readOwnerUUID(nbt);
        if (nbt.contains("ListenerPaused")) {
            this.listenerPaused = nbt.getBoolean("ListenerPaused");
        }
        this.ownerName = PlayerOwned.readOwnerName(nbt);
        if (nbt.contains("LastWorldTime")) {
            this.compensationWorldTime = nbt.getLong("LastWorldTime");
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        if (!this.trySaveLootTable(nbt)) {
            ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)registryLookup);
        }
        nbt.putBoolean("ListenerPaused", this.listenerPaused);
        if (this.getLevel() != null) {
            nbt.putLong("LastWorldTime", this.getLevel().getGameTime());
        }
        PlayerOwned.writeOwnerUUID(nbt, this.ownerUUID);
        PlayerOwned.writeOwnerName(nbt, this.ownerName);
    }

    public int getContainerSize() {
        return 27;
    }

    public void setItem(int slot, ItemStack stack) {
        if (stack.isEmpty()) {
            this.listenerPaused = false;
            this.harvestExistingClusters();
        }
        super.setItem(slot, stack);
    }

    protected NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    protected void setItems(NonNullList<ItemStack> list) {
        this.inventory = list;
    }

    protected AbstractContainerMenu createMenu(int syncId, Inventory playerInventory) {
        return GenericPastelContainerScreenHandler.createGeneric9x3(syncId, playerInventory, (Container)this, ScreenBackgroundVariant.MIDGAME);
    }

    @Override
    public boolean canAcceptEvent(Level world, GameEventListener listener, GameEvent.ListenerInfo message, Vec3 sourcePos) {
        return message.gameEvent() == PastelGameEvents.BLOCK_CHANGED && !this.listenerPaused && message.context().affectedState().is(PastelBlockTags.CRYSTAL_APOTHECARY_HARVESTABLE);
    }

    @Override
    public void triggerEvent(Level world, GameEventListener listener, BlockPosEventQueue.EventEntry entry) {
        BlockPos eventPos;
        BlockState eventState;
        if (listener instanceof BlockPosEventQueue && this.getLevel() != null && (eventState = world.getBlockState(eventPos = entry.eventSourceBlockPos)).is(PastelBlockTags.CRYSTAL_APOTHECARY_HARVESTABLE)) {
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)world).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)eventPos)).withParameter(LootContextParams.TOOL, (Object)HARVEST_ITEMSTACK).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)this.getOwnerIfOnline()).withOptionalParameter(LootContextParams.BLOCK_ENTITY, eventState.hasBlockEntity() ? this.getLevel().getBlockEntity(eventPos) : null);
            List drops = eventState.getDrops(builder);
            boolean anyDropsUsed = drops.isEmpty();
            for (ItemStack drop : drops) {
                ItemStack remainingStack;
                Level level = this.level;
                if (level instanceof ServerLevel) {
                    ServerLevel sl = (ServerLevel)level;
                    Support.areaCriterion(sl, 20, this.getBlockPos(), Optional.empty(), p -> PastelCriteria.CRYSTAL_APOTHECARY_COLLECTING.trigger((ServerPlayer)p, drop));
                }
                if (!(remainingStack = InventoryHelper.smartAddToInventory(drop, (IItemHandlerModifiable)new InvWrapper((Container)this), null)).isEmpty() && drop.getCount() == remainingStack.getCount()) continue;
                anyDropsUsed = true;
            }
            if (anyDropsUsed) {
                world.levelEvent(2001, eventPos, Block.getId((BlockState)eventState));
                if (eventState.getBlock() instanceof SimpleWaterloggedBlock && ((Boolean)eventState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
                    world.setBlockAndUpdate(eventPos, Blocks.WATER.defaultBlockState());
                } else {
                    world.setBlockAndUpdate(eventPos, Blocks.AIR.defaultBlockState());
                }
            } else {
                this.listenerPaused = true;
            }
        }
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public void setOwner(Player playerEntity) {
        this.ownerUUID = playerEntity.getUUID();
        this.ownerName = playerEntity.getName().getString();
        this.setChanged();
    }

    protected void harvestExistingClusters() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            for (BlockPos currPos : BlockPos.withinManhattan((BlockPos)this.worldPosition, (int)12, (int)12, (int)12)) {
                if (!currPos.closerThan((Vec3i)this.worldPosition, 12.0) || !this.level.getBlockState(currPos).is(PastelBlockTags.CRYSTAL_APOTHECARY_HARVESTABLE)) continue;
                this.blockPosEventTransferListener.acceptEvent((Level)serverWorld, new GameEvent.ListenerInfo(PastelGameEvents.BLOCK_CHANGED, Vec3.atCenterOf((Vec3i)currPos), GameEvent.Context.of((BlockState)this.level.getBlockState(currPos)), (GameEventListener)this.blockPosEventTransferListener, Vec3.atCenterOf((Vec3i)this.worldPosition)), Vec3.atCenterOf((Vec3i)this.worldPosition));
            }
        }
    }
}

