/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.energy;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.block.PlayerOwned;
import earth.terrarium.pastel.api.energy.InkStorage;
import earth.terrarium.pastel.api.energy.InkStorageBlockEntity;
import earth.terrarium.pastel.api.energy.InkStorageItem;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.api.energy.storage.TotalCappedInkStorage;
import earth.terrarium.pastel.capabilities.SidedCapabilityProvider;
import earth.terrarium.pastel.capabilities.item.FriendlyStackHandler;
import earth.terrarium.pastel.capabilities.item.StackHandlerView;
import earth.terrarium.pastel.components.InkStorageComponent;
import earth.terrarium.pastel.helpers.data.CodecHelper;
import earth.terrarium.pastel.helpers.level.ContainerWrapper;
import earth.terrarium.pastel.inventories.ColorPickerScreenHandler;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import earth.terrarium.pastel.particle.effect.ColoredFluidRisingParticleEffect;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.recipe.InkConvertingRecipe;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import earth.terrarium.pastel.registries.PastelRegistries;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class ColorPickerBlockEntity
extends RandomizableContainerBlockEntity
implements PlayerOwned,
ContainerWrapper,
InkStorageBlockEntity<TotalCappedInkStorage>,
SidedCapabilityProvider {
    public static final int INVENTORY_SIZE = 2;
    public static final int INPUT_SLOT_ID = 0;
    public static final int OUTPUT_SLOT_ID = 1;
    public static final long TICKS_PER_CONVERSION = 6L;
    public static final long STORAGE_AMOUNT = 0x1900000L;
    public FriendlyStackHandler inventory = new FriendlyStackHandler(2);
    protected TotalCappedInkStorage inkStorage;
    protected boolean paused;
    protected boolean inkDirty;
    @Nullable
    protected InkConvertingRecipe cachedRecipe;
    protected Optional<Holder<InkColor>> selectedColor = Optional.empty();
    private UUID ownerUUID;

    public ColorPickerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)PastelBlockEntities.COLOR_PICKER.get(), blockPos, blockState);
        this.inventory.addListener(i -> {
            this.setChanged();
            if (!this.level.isClientSide()) {
                this.updateInClientWorld();
                this.paused = false;
            }
        });
        this.inkStorage = new TotalCappedInkStorage(0x1900000L, Map.of());
    }

    public static void tick(Level world, BlockPos pos, BlockState state, ColorPickerBlockEntity picker) {
        if (!world.isClientSide) {
            picker.inkDirty = false;
            if (!picker.paused) {
                boolean convertedPigment = false;
                boolean shouldPause = true;
                if (world.getGameTime() % (long)picker.getConversionTicks() == 0L) {
                    convertedPigment = picker.tryConvertPigmentToEnergy((ServerLevel)world);
                } else {
                    shouldPause = false;
                }
                boolean filledContainer = picker.tryFillInkContainer();
                if (convertedPigment || filledContainer) {
                    picker.updateInClientWorld();
                    picker.setInkDirty();
                    picker.setChanged();
                } else if (shouldPause) {
                    picker.paused = true;
                }
            }
        }
    }

    private int getConversionTicks() {
        assert (this.level != null);
        ItemStack stack = this.inventory.getStackInSlot(0);
        return Math.round(Mth.clampedLerp((float)6.0f, (float)1.0f, (float)((float)stack.getCount() / (float)stack.getMaxStackSize())));
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.inventory.load(nbt.getCompound("Inventory"), registryLookup);
        CodecHelper.fromNbt(InkStorageComponent.CODEC, nbt.get("InkStorage")).ifPresent(storage -> {
            this.inkStorage = new TotalCappedInkStorage(storage.maxEnergyTotal(), storage.storedEnergy());
        });
        this.ownerUUID = PlayerOwned.readOwnerUUID(nbt);
        this.selectedColor = nbt.contains("SelectedColor", 8) ? Optional.of(PastelRegistries.INK_COLOR.wrapAsHolder((Object)InkColor.ofIdString(nbt.getString("SelectedColor")).get())) : Optional.empty();
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        CompoundTag inv = new CompoundTag();
        this.inventory.save(inv, registryLookup);
        nbt.put("Inventory", (Tag)inv);
        CodecHelper.writeNbt(nbt, "InkStorage", InkStorageComponent.CODEC, new InkStorageComponent(this.inkStorage));
        PlayerOwned.writeOwnerUUID(nbt, this.ownerUUID);
        this.selectedColor.ifPresent(color -> nbt.putString("SelectedColor", color.getRegisteredName()));
    }

    @Override
    public FriendlyStackHandler getHandlerForScreens() {
        return this.inventory;
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.pastel.color_picker");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.inventory.getInternalList();
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.inventory.setInternalList(items);
    }

    protected AbstractContainerMenu createMenu(int syncId, Inventory playerInventory) {
        return new ColorPickerScreenHandler(syncId, playerInventory, new ColorPickerScreenHandler.ScreenOpeningData(this.worldPosition, this.selectedColor));
    }

    public void writeClientSideData(AbstractContainerMenu menu, RegistryFriendlyByteBuf buffer) {
        ColorPickerScreenHandler.ScreenOpeningData.STREAM_CODEC.encode((Object)buffer, (Object)new ColorPickerScreenHandler.ScreenOpeningData(this.worldPosition, this.selectedColor));
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwner(Player playerEntity) {
        this.ownerUUID = playerEntity.getUUID();
        this.setChanged();
    }

    @Override
    public TotalCappedInkStorage getEnergyStorage() {
        return this.inkStorage;
    }

    @Override
    public void setInkDirty() {
        this.inkDirty = true;
    }

    @Override
    public boolean getInkDirty() {
        return this.inkDirty;
    }

    @Override
    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemStack = super.removeItem(slot, amount);
        this.paused = false;
        this.updateInClientWorld();
        return itemStack;
    }

    @Override
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack itemStack = super.removeItemNoUpdate(slot);
        this.paused = false;
        this.updateInClientWorld();
        return itemStack;
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        super.setItem(slot, stack);
        this.paused = false;
        this.updateInClientWorld();
    }

    @Override
    public int getContainerSize() {
        return 2;
    }

    protected boolean tryConvertPigmentToEnergy(ServerLevel world) {
        InkConvertingRecipe recipe = this.getInkConvertingRecipe((Level)world);
        if (recipe != null) {
            InkColor inkColor = recipe.getInkColor();
            long amount = recipe.getInkAmount();
            if (amount <= this.inkStorage.getRoom(inkColor)) {
                this.inventory.getStackInSlot(0).shrink(1);
                this.inkStorage.addEnergy(inkColor, amount);
                if (PastelCommon.CONFIG.BlockSoundVolume > 0.0f) {
                    world.playSound(null, this.worldPosition, PastelSounds.COLOR_PICKER_PROCESSING, SoundSource.BLOCKS, PastelCommon.CONFIG.BlockSoundVolume / 3.0f, 1.0f);
                }
                PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity(world, new Vec3((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.7, (double)this.worldPosition.getZ() + 0.5), ColoredFluidRisingParticleEffect.of(inkColor.getColorInt()), 5, new Vec3(0.22, 0.0, 0.22), new Vec3(0.0, 0.1, 0.0));
                return true;
            }
        }
        return false;
    }

    @Nullable
    protected InkConvertingRecipe getInkConvertingRecipe(Level world) {
        ItemStack inputStack = this.inventory.getStackInSlot(0);
        if (inputStack.isEmpty()) {
            this.cachedRecipe = null;
            return null;
        }
        if (this.cachedRecipe != null && ((Ingredient)this.cachedRecipe.getIngredients().get(0)).test(inputStack)) {
            return this.cachedRecipe;
        }
        Optional recipe = world.getRecipeManager().getRecipeFor(PastelRecipeTypes.INK_CONVERTING, (RecipeInput)new SingleRecipeInput(this.inventory.getStackInSlot(0)), world);
        if (recipe.isPresent()) {
            this.cachedRecipe = (InkConvertingRecipe)((RecipeHolder)recipe.get()).value();
            return this.cachedRecipe;
        }
        this.cachedRecipe = null;
        return null;
    }

    protected boolean tryFillInkContainer() {
        long transferredAmount = 0L;
        ItemStack stack = this.inventory.getStackInSlot(1);
        Item item = stack.getItem();
        if (item instanceof InkStorageItem) {
            InkStorageItem inkStorageItem = (InkStorageItem)item;
            Object itemStorage = inkStorageItem.getEnergyStorage(stack);
            ServerPlayer owner = null;
            Player player = this.getOwnerIfOnline();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity;
                owner = serverPlayerEntity = (ServerPlayer)player;
            }
            if (this.selectedColor.isEmpty()) {
                for (InkColor color : InkColors.all()) {
                    transferredAmount += this.tryTransferInk(owner, stack, (InkStorage)itemStorage, color);
                }
            } else {
                transferredAmount = this.tryTransferInk(owner, stack, (InkStorage)itemStorage, (InkColor)this.selectedColor.get().value());
            }
            if (transferredAmount > 0L) {
                inkStorageItem.setEnergyStorage(stack, (InkStorage)itemStorage);
            }
        }
        return transferredAmount > 0L;
    }

    private long tryTransferInk(ServerPlayer owner, ItemStack stack, InkStorage itemStorage, InkColor color) {
        long amount = InkStorage.transferInk(this.inkStorage, itemStorage, color);
        if (amount > 0L && owner != null) {
            PastelCriteria.INK_CONTAINER_INTERACTION.trigger(owner, stack, itemStorage, color, amount);
        }
        return amount;
    }

    public void setSelectedColor(Optional<Holder<InkColor>> inkColor) {
        this.selectedColor = inkColor;
        this.paused = false;
        this.setChanged();
    }

    public Optional<Holder<InkColor>> getSelectedColor() {
        return this.selectedColor;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        CompoundTag nbtCompound = new CompoundTag();
        this.saveAdditional(nbtCompound, registryLookup);
        return nbtCompound;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void updateInClientWorld() {
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.level.getBlockState(this.worldPosition), this.level.getBlockState(this.worldPosition), 4);
        }
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (slot == 0) {
            return InkConvertingRecipe.isInput(stack.getItem());
        }
        if (slot == 1) {
            return stack.getItem() instanceof InkStorageItem;
        }
        return true;
    }

    @Override
    public IItemHandler exposeItemHandlers(Direction dir) {
        return new StackHandlerView(this.inventory, 0, 1).disableExtraction();
    }
}

