/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.ender;

import earth.terrarium.pastel.api.block.PlayerOwnedWithName;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class EnderHopperBlockEntity
extends BlockEntity
implements PlayerOwnedWithName {
    private final VoxelShape INSIDE_SHAPE = Block.box((double)2.0, (double)11.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private final VoxelShape ABOVE_SHAPE = Block.box((double)0.0, (double)16.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
    private final VoxelShape INPUT_AREA_SHAPE = Shapes.or((VoxelShape)this.INSIDE_SHAPE, (VoxelShape)this.ABOVE_SHAPE);
    private UUID ownerUUID;
    private String ownerName;
    private int transferCooldown;

    public EnderHopperBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)PastelBlockEntities.ENDER_HOPPER.get(), blockPos, blockState);
    }

    public static void onEntityCollided(BlockPos pos, Entity entity, EnderHopperBlockEntity enderHopperBlockEntity) {
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            if (Shapes.joinIsNotEmpty((VoxelShape)Shapes.create((AABB)entity.getBoundingBox().move((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ()))), (VoxelShape)enderHopperBlockEntity.getInputAreaShape(), (BooleanOp)BooleanOp.AND)) {
                EnderHopperBlockEntity.insertIntoEnderChest(enderHopperBlockEntity, itemEntity);
            }
        }
    }

    public static void serverTick(Level world, BlockPos pos, BlockState state, EnderHopperBlockEntity enderHopperBlockEntity) {
        --enderHopperBlockEntity.transferCooldown;
        if (!enderHopperBlockEntity.needsCooldown()) {
            enderHopperBlockEntity.setCooldown(0);
            IItemHandler sourceInventory = (IItemHandler)world.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)Direction.DOWN);
            if (sourceInventory instanceof IItemHandlerModifiable) {
                IItemHandlerModifiable modifiable = (IItemHandlerModifiable)sourceInventory;
                EnderHopperBlockEntity.insertIntoEnderChest(enderHopperBlockEntity, modifiable);
            } else {
                List<ItemEntity> entities = EnderHopperBlockEntity.getInputItemEntities(world, enderHopperBlockEntity);
                for (ItemEntity entity : entities) {
                    EnderHopperBlockEntity.insertIntoEnderChest(enderHopperBlockEntity, entity);
                }
            }
            enderHopperBlockEntity.setCooldown(8);
        }
    }

    public static List<ItemEntity> getInputItemEntities(Level world, EnderHopperBlockEntity enderHopperBlockEntity) {
        return enderHopperBlockEntity.getInputAreaShape().toAabbs().stream().flatMap(box -> world.getEntitiesOfClass(ItemEntity.class, box.move(enderHopperBlockEntity.getHopperX() - 0.5, enderHopperBlockEntity.getHopperY() - 0.5, enderHopperBlockEntity.getHopperZ() - 0.5), EntitySelector.ENTITY_STILL_ALIVE).stream()).collect(Collectors.toList());
    }

    private static void insertIntoEnderChest(EnderHopperBlockEntity enderHopperBlockEntity, IItemHandlerModifiable sourceInventory) {
        Player playerEntity;
        UUID ownerUUID = enderHopperBlockEntity.getOwnerUUID();
        if (ownerUUID != null && (playerEntity = enderHopperBlockEntity.getOwnerIfOnline()) != null) {
            for (int i = 0; i < sourceInventory.getSlots(); ++i) {
                ItemStack sourceItemStack = sourceInventory.getStackInSlot(i).copy();
                if (sourceItemStack.isEmpty() || sourceInventory.extractItem(i, 99, true).isEmpty()) continue;
                ItemStack remainderStack = EnderHopperBlockEntity.addToEnderInventory(sourceItemStack, playerEntity, false);
                sourceInventory.setStackInSlot(i, remainderStack);
                if (!remainderStack.isEmpty()) {
                    enderHopperBlockEntity.setCooldown(40);
                }
                return;
            }
        }
    }

    private static void insertIntoEnderChest(EnderHopperBlockEntity enderHopperBlockEntity, ItemEntity itemEntity) {
        ItemStack sourceItemStack;
        Player playerEntity;
        UUID ownerUUID = enderHopperBlockEntity.getOwnerUUID();
        if (ownerUUID != null && (playerEntity = enderHopperBlockEntity.getOwnerIfOnline()) != null && !(sourceItemStack = itemEntity.getItem()).isEmpty()) {
            ItemStack remainderStack = EnderHopperBlockEntity.addToEnderInventory(sourceItemStack, playerEntity, false);
            if (remainderStack.isEmpty()) {
                itemEntity.discard();
            } else {
                itemEntity.setItem(remainderStack);
            }
        }
    }

    public static ItemStack addToEnderInventory(ItemStack additionStack, Player playerEntity, boolean test) {
        PlayerEnderChestContainer enderChestInventory = playerEntity.getEnderChestInventory();
        for (int i = 0; i < enderChestInventory.getContainerSize(); ++i) {
            int canAcceptCount;
            int maxStackCount;
            ItemStack currentStack = enderChestInventory.getItem(i);
            boolean doneStuff = false;
            if (currentStack.isEmpty()) {
                maxStackCount = currentStack.getMaxStackSize();
                int maxAcceptCount = Math.min(additionStack.getCount(), maxStackCount);
                if (!test) {
                    ItemStack newStack = additionStack.copy();
                    newStack.setCount(maxAcceptCount);
                    enderChestInventory.setItem(i, newStack);
                }
                additionStack.setCount(additionStack.getCount() - maxAcceptCount);
                doneStuff = true;
            } else if (ItemStack.isSameItemSameComponents((ItemStack)currentStack, (ItemStack)additionStack) && (canAcceptCount = (maxStackCount = currentStack.getMaxStackSize()) - currentStack.getCount()) > 0) {
                if (!test) {
                    enderChestInventory.getItem(i).grow(Math.min(additionStack.getCount(), canAcceptCount));
                }
                if (canAcceptCount >= additionStack.getCount()) {
                    additionStack.setCount(0);
                } else {
                    additionStack.setCount(additionStack.getCount() - canAcceptCount);
                }
                doneStuff = true;
            }
            if (!doneStuff || additionStack.getCount() != 0) continue;
            return ItemStack.EMPTY;
        }
        return additionStack;
    }

    protected Component getContainerName() {
        if (this.hasOwner()) {
            return Component.translatable((String)"block.pastel.ender_hopper.owner", (Object[])new Object[]{this.ownerName});
        }
        return Component.translatable((String)"block.pastel.ender_hopper");
    }

    public double getHopperX() {
        return (double)this.worldPosition.getX() + 0.5;
    }

    public double getHopperY() {
        return (double)this.worldPosition.getY() + 0.5;
    }

    public double getHopperZ() {
        return (double)this.worldPosition.getZ() + 0.5;
    }

    private VoxelShape getInputAreaShape() {
        return this.INPUT_AREA_SHAPE;
    }

    public ItemStack getStack(int slot) {
        Player playerEntity = this.level.getPlayerByUUID(this.ownerUUID);
        PlayerEnderChestContainer enderInventory = playerEntity.getEnderChestInventory();
        return enderInventory.getItem(slot);
    }

    private void setCooldown(int cooldown) {
        this.transferCooldown = cooldown;
    }

    private boolean needsCooldown() {
        return this.transferCooldown > 0;
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public void setOwner(Player playerEntity) {
        this.ownerUUID = playerEntity.getUUID();
        this.ownerName = playerEntity.getName().getString();
        this.setChanged();
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registryLookup) {
        super.loadAdditional(tag, registryLookup);
        this.ownerUUID = tag.contains("OwnerUUID") ? tag.getUUID("OwnerUUID") : null;
        this.ownerName = tag.contains("OwnerName") ? tag.getString("OwnerName") : null;
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registryLookup) {
        super.saveAdditional(tag, registryLookup);
        if (this.ownerUUID != null) {
            tag.putUUID("OwnerUUID", this.ownerUUID);
        }
        if (this.ownerName != null) {
            tag.putString("OwnerName", this.ownerName);
        }
    }
}

