/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.enchanter;

import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.InWorldInteractionBlock;
import earth.terrarium.pastel.blocks.enchanter.EnchanterBlockEntity;
import earth.terrarium.pastel.capabilities.ExperienceHandler;
import earth.terrarium.pastel.capabilities.PastelCapabilities;
import earth.terrarium.pastel.compat.modonomicon.ModonomiconHelper;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelMultiblocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class EnchanterBlock
extends InWorldInteractionBlock {
    public static final MapCodec<EnchanterBlock> CODEC = EnchanterBlock.simpleCodec(EnchanterBlock::new);
    public static final ResourceLocation UNLOCK_IDENTIFIER = PastelCommon.locate("midgame/build_enchanting_structure");

    public EnchanterBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends EnchanterBlock> codec() {
        return CODEC;
    }

    public static void clearCurrentlyRenderedMultiBlock(Level world) {
        if (world.isClientSide) {
            ModonomiconHelper.clearRenderedMultiblock(PastelMultiblocks.get(PastelMultiblocks.ENCHANTER));
        }
    }

    public static boolean verifyStructure(Level level, BlockPos blockPos) {
        Multiblock multiblock = PastelMultiblocks.get(PastelMultiblocks.ENCHANTER);
        boolean valid = multiblock.validate(level, blockPos.below(3), Rotation.NONE);
        if (valid) {
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                Support.mbCriterion(sl, blockPos, multiblock);
            }
        } else if (level.isClientSide) {
            ModonomiconHelper.renderMultiblock(PastelMultiblocks.get(PastelMultiblocks.ENCHANTER), PastelMultiblocks.ENCHANTER_TEXT, blockPos.below(4), Rotation.NONE);
        }
        return valid;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new EnchanterBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return EnchanterBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)PastelBlockEntities.ENCHANTER.get()), (BlockEntityTicker)(world.isClientSide ? EnchanterBlockEntity::clientTick : EnchanterBlockEntity::serverTick));
    }

    public void destroy(LevelAccessor world, BlockPos pos, BlockState state) {
        if (world.isClientSide()) {
            EnchanterBlock.clearCurrentlyRenderedMultiBlock((Level)world);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack handStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (level.isClientSide) {
            EnchanterBlock.verifyStructure(level, pos);
            return ItemInteractionResult.SUCCESS;
        }
        if (EnchanterBlock.verifyStructure(level, pos) && (blockEntity = level.getBlockEntity(pos)) instanceof EnchanterBlockEntity) {
            EnchanterBlockEntity enchanterBlockEntity = (EnchanterBlockEntity)blockEntity;
            if (player.isShiftKeyDown() || handStack.isEmpty()) {
                for (int i = 0; i < 2; ++i) {
                    if (!this.retrieveStack(level, pos, player, hand, handStack, enchanterBlockEntity, i)) continue;
                    enchanterBlockEntity.setItemFacingDirection(player.getDirection());
                    enchanterBlockEntity.setOwner(player);
                    enchanterBlockEntity.inventoryChanged();
                    break;
                }
                return ItemInteractionResult.CONSUME;
            }
            int targetSlot = this.getTargetSlot(handStack, (HolderLookup.Provider)level.registryAccess());
            if (this.exchangeStack(level, pos, player, hand, handStack, enchanterBlockEntity, targetSlot)) {
                enchanterBlockEntity.setItemFacingDirection(player.getDirection());
                enchanterBlockEntity.setOwner(player);
                enchanterBlockEntity.inventoryChanged();
            }
        }
        return ItemInteractionResult.CONSUME;
    }

    private int getTargetSlot(ItemStack hand, HolderLookup.Provider lookup) {
        if (hand.isEmpty()) {
            return 0;
        }
        ExperienceHandler storage = (ExperienceHandler)hand.getCapability(PastelCapabilities.Misc.XP, (Object)lookup);
        if (storage != null) {
            return 1;
        }
        return 0;
    }
}

