/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.deeper_down.flora;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.registries.PastelBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class WeepingGalaFrondsBlock
extends BushBlock {
    public static final MapCodec<WeepingGalaFrondsBlock> CODEC = WeepingGalaFrondsBlock.simpleCodec(WeepingGalaFrondsBlock::new);

    public WeepingGalaFrondsBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends WeepingGalaFrondsBlock> codec() {
        return CODEC;
    }

    public float getMaxHorizontalOffset() {
        return 0.1f;
    }

    public boolean mayPlaceOn(BlockState roof, BlockGetter world, BlockPos pos) {
        return roof.is((Block)PastelBlocks.WEEPING_GALA_LEAVES.get()) || roof.is((Block)PastelBlocks.WEEPING_GALA_FRONDS.get());
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos roof = pos.above();
        BlockState roofState = world.getBlockState(roof);
        if (roofState.is((Block)this)) {
            return true;
        }
        return this.mayPlaceOn(roofState, (BlockGetter)world, roof);
    }
}

