/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.deeper_down.flora;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.deeper_down.flora.TriStateVineBlock;
import earth.terrarium.pastel.registries.PastelBlockTags;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelLootTables;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class NightdewBlock
extends TriStateVineBlock {
    public static final MapCodec<NightdewBlock> CODEC = NightdewBlock.simpleCodec(NightdewBlock::new);
    public static final float BASE_BURGEON_CHANCE = 2000.0f;
    public static final float MAX_BURGEON_CHANCE = 250.0f;

    public NightdewBlock(BlockBehaviour.Properties settings) {
        super(settings, 6, 1.0f, 0.3f, 0.85f);
    }

    public MapCodec<? extends NightdewBlock> codec() {
        return CODEC;
    }

    @Override
    public boolean mayPlaceOn(BlockState roof, BlockGetter world, BlockPos pos) {
        return super.mayPlaceOn(roof, world, pos) && roof.is(PastelBlockTags.NIGHTDEW_SOILS);
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return ((Item)PastelItems.NIGHTDEW_SPROUT.get()).getDefaultInstance();
    }

    public void spawnAfterBreak(BlockState state, ServerLevel world, BlockPos pos, ItemStack tool, boolean dropExperience) {
        RandomSource random = world.getRandom();
        float sleepingEntities = Math.min((float)world.getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate(20.0), LivingEntity::isSleeping).size() / 20.0f, 1.0f);
        float dropChance = Mth.clampedLerp((float)2000.0f, (float)250.0f, (float)sleepingEntities);
        if (random.nextFloat() < 1.0f / dropChance) {
            for (ItemStack rareStack : NightdewBlock.getRareStacks(state, world, pos, tool, PastelLootTables.NIGHTDEW_VINE_RARE_DROP)) {
                NightdewBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)rareStack);
            }
        }
    }

    @Override
    boolean hasGrowthActions() {
        return false;
    }

    public static List<ItemStack> getRareStacks(BlockState state, ServerLevel world, BlockPos pos, ItemStack stack, ResourceKey<LootTable> lootTableKey) {
        LootParams.Builder builder = new LootParams.Builder(world).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)stack);
        LootTable lootTable = world.getServer().reloadableRegistries().getLootTable(lootTableKey);
        return lootTable.getRandomItems(builder.create(LootContextParamSets.BLOCK));
    }
}

