/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.deeper_down.flora;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.deeper_down.flora.TriStateVineBlock;
import earth.terrarium.pastel.helpers.level.BlockReference;
import earth.terrarium.pastel.registries.PastelBlockTags;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class AbyssalVineBlock
extends TriStateVineBlock {
    public static final MapCodec<AbyssalVineBlock> CODEC = AbyssalVineBlock.simpleCodec(AbyssalVineBlock::new);
    public static final BooleanProperty BERRIES = BlockStateProperties.BERRIES;

    public AbyssalVineBlock(BlockBehaviour.Properties settings) {
        super(settings, 5, 0.3f, 0.4f, 0.667f);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BERRIES, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends AbyssalVineBlock> codec() {
        return CODEC;
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)BERRIES) == false;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        BlockReference reference = BlockReference.of(state, pos);
        InteractionResult superSucc = super.useWithoutItem(state, world, pos, player, hit);
        if (superSucc.indicateItemUse()) {
            return superSucc;
        }
        if (!((Boolean)reference.getProperty(BERRIES)).booleanValue()) {
            return InteractionResult.FAIL;
        }
        reference.setProperty(BERRIES, false);
        reference.update((LevelAccessor)world);
        world.playSound(null, pos, SoundEvents.CAVE_VINES_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, Mth.randomBetween((RandomSource)world.random, (float)0.8f, (float)1.2f));
        player.getInventory().placeItemBackInInventory(((Item)PastelItems.FISSURE_PLUM.get()).getDefaultInstance());
        world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)reference.getState()));
        return InteractionResult.SUCCESS;
    }

    @Override
    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        BlockReference reference = BlockReference.of(state, pos);
        float growthChance = 0.8f;
        int offset = 0;
        while (true) {
            BlockReference ref;
            if ((ref = BlockReference.of((LevelAccessor)world, pos.offset(0, offset, 0))).isOf((Block)PastelBlocks.SHALE_CLAY.get())) {
                return;
            }
            if (ref.isIn(PastelBlockTags.GROWTH_ACCELERATORS)) {
                growthChance = 0.5f;
            }
            if (!ref.isOf((Block)this)) break;
            ++offset;
        }
        if (random.nextFloat() < growthChance) {
            return;
        }
        if (!((Boolean)reference.getProperty(BERRIES)).booleanValue()) {
            this.tryGrowBerries(reference, (Level)world);
        }
        reference.update((LevelAccessor)world);
    }

    @Override
    public boolean isRandomlyTicking(BlockState state) {
        return super.isRandomlyTicking(state) || (Boolean)state.getValue((Property)BERRIES) == false;
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return ((Item)PastelItems.FISSURE_PLUM.get()).getDefaultInstance();
    }

    @Override
    boolean hasGrowthActions() {
        return true;
    }

    public void tryGrowBerries(BlockReference reference, Level world) {
        int berryCount = 0;
        for (int i = 0; i < 3; ++i) {
            BlockReference uRef = BlockReference.of((LevelAccessor)world, reference.pos.offset(0, i, 0));
            BlockReference dRef = BlockReference.of((LevelAccessor)world, reference.pos.offset(0, -i, 0));
            berryCount += this.checkForBerries(uRef);
            if ((i != 1 || reference.pos.getY() % 5 != 0 || (berryCount += this.checkForBerries(dRef)) != 2) && (reference.pos.getY() % 7 != 0 || berryCount != 1)) continue;
            return;
        }
        if (berryCount >= 3) {
            return;
        }
        reference.setProperty(BERRIES, true);
    }

    private int checkForBerries(BlockReference ref) {
        if (ref.isOf((Block)this) && ((Boolean)ref.getProperty(BERRIES)).booleanValue()) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BERRIES});
    }
}

