/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.deeper_down;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.deeper_down.HummingstoneBlockEntity;
import earth.terrarium.pastel.events.game.PastelGameEvents;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.registries.PastelAdvancements;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class HummingstoneBlock
extends BaseEntityBlock {
    public static final MapCodec<HummingstoneBlock> CODEC = HummingstoneBlock.simpleCodec(HummingstoneBlock::new);
    public static final float CHANCE_TO_ECHO_HUM_EVENT = 0.08f;
    public static final BooleanProperty HUMMING = BooleanProperty.create((String)"humming");

    public HummingstoneBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HUMMING, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends HummingstoneBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        float r;
        super.animateTick(state, world, pos, random);
        if (!((Boolean)state.getValue((Property)HUMMING)).booleanValue()) {
            return;
        }
        Direction direction = Direction.getRandom((RandomSource)random);
        if (direction != Direction.DOWN) {
            BlockPos blockPos = pos.relative(direction);
            BlockState blockState = world.getBlockState(blockPos);
            if (!state.canOcclude() || !blockState.isFaceSturdy((BlockGetter)world, blockPos, direction.getOpposite())) {
                double d = direction.getStepX() == 0 ? random.nextDouble() : 0.5 + (double)direction.getStepX() * 0.6;
                double e = direction.getStepY() == 0 ? random.nextDouble() : 0.5 + (double)direction.getStepY() * 0.6;
                double f = direction.getStepZ() == 0 ? random.nextDouble() : 0.5 + (double)direction.getStepZ() * 0.6;
                world.addParticle((ParticleOptions)ParticleTypes.NOTE, (double)pos.getX() + d, (double)pos.getY() + e, (double)pos.getZ() + f, 0.0, 0.05, 0.0);
            }
        }
        if ((r = random.nextFloat()) < 0.3f) {
            float pitch = 0.4f + 0.4f * (float)pos.getX() % 8.0f + 0.4f * (float)pos.getY() % 8.0f + 0.4f * (float)pos.getZ() % 8.0f;
            world.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, PastelSounds.HUMMINGSTONE_HUM, SoundSource.BLOCKS, 0.4f + random.nextFloat() * 0.1f, pitch, false);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HUMMING});
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!((Boolean)state.getValue((Property)HUMMING)).booleanValue()) {
            if (!world.isClientSide) {
                HummingstoneBlock.startHumming(world, pos, state, (Entity)player, false);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)HUMMING);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.randomTick(state, world, pos, random);
        if (!world.isClientSide && ((Boolean)state.getValue((Property)HUMMING)).booleanValue()) {
            HummingstoneBlock.stopHumming((Level)world, pos, state);
        }
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        super.entityInside(state, world, pos, entity);
        if (!world.isClientSide && !((Boolean)state.getValue((Property)HUMMING)).booleanValue()) {
            HummingstoneBlock.startHumming(world, pos, state, entity, false);
        }
    }

    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.fallOn(world, state, pos, entity, fallDistance);
        if (!world.isClientSide && !((Boolean)state.getValue((Property)HUMMING)).booleanValue()) {
            HummingstoneBlock.startHumming(world, pos, state, entity, false);
        }
    }

    public void onProjectileHit(Level world, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (!world.isClientSide && !((Boolean)state.getValue((Property)HUMMING)).booleanValue()) {
            HummingstoneBlock.startHumming(world, hit.getBlockPos(), state, projectile.getOwner(), false);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return world.isClientSide ? null : HummingstoneBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)PastelBlockEntities.HUMMINGSTONE.get()), HummingstoneBlockEntity::serverTick);
    }

    public boolean isSignalSource(BlockState state) {
        return (Boolean)state.getValue((Property)HUMMING);
    }

    public int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return (Boolean)state.getValue((Property)HUMMING) != false ? 15 : 0;
    }

    public static void startHumming(Level world, BlockPos pos, BlockState state, @Nullable Entity entity, boolean causedByOtherHum) {
        if (!(state.getBlock() instanceof HummingstoneBlock)) {
            return;
        }
        world.playSound(null, pos, PastelSounds.HUMMINGSTONE_HUM, SoundSource.BLOCKS, 0.75f, 1.0f);
        if (!((Boolean)state.getValue((Property)HUMMING)).booleanValue()) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HUMMING, (Comparable)Boolean.valueOf(true)));
        }
        if (!causedByOtherHum || world.random.nextFloat() < 0.08f) {
            world.gameEvent(entity, PastelGameEvents.HUMMINGSTONE_HUMMING, pos);
        }
    }

    public static void stopHumming(Level world, BlockPos pos, BlockState state) {
        world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HUMMING, (Comparable)Boolean.valueOf(false)));
        world.playSound(null, pos, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.BLOCKS, 0.5f, 0.5f + world.random.nextFloat() * 1.2f);
    }

    public static void onHymn(Level level, BlockPos pos, @Nullable Entity entity) {
        if (!(level.getBlockState(pos).getBlock() instanceof HummingstoneBlock)) {
            return;
        }
        level.gameEvent(entity, PastelGameEvents.HUMMINGSTONE_HYMN, pos);
        level.playSound(null, pos, SoundEvents.AMETHYST_BLOCK_BREAK, SoundSource.BLOCKS, 1.25f, 0.5f + level.random.nextFloat() * 1.2f);
        level.destroyBlock(pos, false);
        HummingstoneBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)((Item)PastelItems.RESONANCE_SHARD.get()).getDefaultInstance());
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            Support.areaCriterion(sl, 20, pos, PastelAdvancements.Midgame.ENTER_DIMENSION, p -> PastelCriteria.CREATE_HUMMINGSTONE_HYMN.trigger((ServerPlayer)p, sl, pos));
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new HummingstoneBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> GameEventListener getListener(ServerLevel world, T blockEntity) {
        if (blockEntity instanceof HummingstoneBlockEntity) {
            HummingstoneBlockEntity hummingstoneBlockEntity = (HummingstoneBlockEntity)blockEntity;
            return hummingstoneBlockEntity.listener;
        }
        return null;
    }
}

