/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.decoration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.api.item.GemstoneColor;
import earth.terrarium.pastel.registries.PastelRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class GemstoneGlassBlock
extends TransparentBlock {
    public final MapCodec<GemstoneGlassBlock> codec;
    @Nullable
    final GemstoneColor gemstoneColor;

    public GemstoneGlassBlock(BlockBehaviour.Properties settings, @Nullable GemstoneColor gemstoneColor) {
        super(settings);
        this.gemstoneColor = gemstoneColor;
        this.codec = RecordCodecBuilder.mapCodec(i -> i.group((App)GemstoneGlassBlock.propertiesCodec(), (App)PastelRegistries.GEMSTONE_COLOR.byNameCodec().fieldOf("color").forGetter(b -> b.gemstoneColor)).apply((Applicative)i, GemstoneGlassBlock::new));
    }

    public MapCodec<? extends GemstoneGlassBlock> codec() {
        return this.codec;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean skipRendering(BlockState state, BlockState stateFrom, Direction direction) {
        if (stateFrom.is((Block)this)) {
            return true;
        }
        Block block = state.getBlock();
        if (block instanceof GemstoneGlassBlock) {
            GemstoneGlassBlock sourceGemstoneGlassBlock = (GemstoneGlassBlock)block;
            block = stateFrom.getBlock();
            if (block instanceof GemstoneGlassBlock) {
                GemstoneGlassBlock targetGemstoneGlassBlock = (GemstoneGlassBlock)block;
                return sourceGemstoneGlassBlock.gemstoneColor == targetGemstoneGlassBlock.gemstoneColor;
            }
        }
        return super.skipRendering(state, stateFrom, direction);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }
}

