/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.decoration;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GemstoneChimeBlock
extends Block {
    protected static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0), (VoxelShape)Block.box((double)7.0, (double)13.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0));
    protected final SoundEvent soundEvent;
    protected final ParticleOptions particleEffect;

    public GemstoneChimeBlock(BlockBehaviour.Properties settings, SoundEvent soundEvent, ParticleOptions particleEffect) {
        super(settings);
        this.soundEvent = soundEvent;
        this.particleEffect = particleEffect;
    }

    public MapCodec<? extends GemstoneChimeBlock> codec() {
        return null;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(state, world, pos, random);
        world.addParticle(this.particleEffect, (double)pos.getX() + 0.25 + random.nextDouble() * 0.5, (double)pos.getY() + 0.15 + random.nextDouble() * 0.5, (double)pos.getZ() + 0.25 + random.nextDouble() * 0.5, 0.0, -0.02 - random.nextDouble() * 0.025, 0.0);
        if ((double)random.nextFloat() < 0.2) {
            world.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), this.soundEvent, SoundSource.BLOCKS, 0.7f + random.nextFloat() * 0.4f, 0.75f + random.nextFloat() * 0.5f, true);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = Direction.UP;
        return Block.canSupportCenter((LevelReader)world, (BlockPos)pos.relative(direction), (Direction)direction.getOpposite());
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return direction == Direction.UP && !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public ParticleOptions getParticleEffect() {
        return this.particleEffect;
    }
}

