/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.decoration;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.decoration.DiagonalBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FlexLanternBlock
extends DiagonalBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<FlexLanternBlock> CODEC = FlexLanternBlock.simpleCodec(FlexLanternBlock::new);
    public static final BooleanProperty HANGING = BlockStateProperties.HANGING;
    public static final BooleanProperty TALL = BooleanProperty.create((String)"tall");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final VoxelShape SHAPE_STANDING_SMALL = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0);
    public static final VoxelShape SHAPE_STANDING_TALL = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final VoxelShape SHAPE_HANGING_SMALL = Block.box((double)4.0, (double)7.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final VoxelShape SHAPE_HANGING_TALL = Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public FlexLanternBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HANGING, (Comparable)Boolean.valueOf(false))).setValue((Property)TALL, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends FlexLanternBlock> codec() {
        return CODEC;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Player player = ctx.getPlayer();
        BlockState state = super.getStateForPlacement(ctx);
        if (state != null) {
            if (player != null && player.isShiftKeyDown()) {
                state = (BlockState)state.setValue((Property)TALL, (Comparable)Boolean.valueOf(false));
            }
            if (ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER) {
                state = (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            }
            state = (BlockState)state.setValue((Property)HANGING, (Comparable)Boolean.valueOf(ctx.getClickedFace() == Direction.DOWN));
        }
        return state;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Boolean tall = (Boolean)state.getValue((Property)TALL);
        if (((Boolean)state.getValue((Property)HANGING)).booleanValue()) {
            return tall != false ? SHAPE_HANGING_TALL : SHAPE_HANGING_SMALL;
        }
        return tall != false ? SHAPE_STANDING_TALL : SHAPE_STANDING_SMALL;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Boolean)state.getValue((Property)HANGING) != false ? Direction.UP : Direction.DOWN;
        return Block.canSupportCenter((LevelReader)world, (BlockPos)pos.relative(direction), (Direction)direction.getOpposite());
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HANGING, TALL, WATERLOGGED});
    }
}

