/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.decoration;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.registries.PastelBlocks;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EtherealPlatformBlock
extends TransparentBlock {
    public static final MapCodec<EtherealPlatformBlock> CODEC = EtherealPlatformBlock.simpleCodec(EtherealPlatformBlock::new);
    public static final int MAX_AGE = 5;
    public static final BooleanProperty EXTEND = BooleanProperty.create((String)"extend");
    public static final IntegerProperty AGE = BlockStateProperties.AGE_5;
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public EtherealPlatformBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends EtherealPlatformBlock> codec() {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean skipRendering(BlockState state, BlockState stateFrom, Direction direction) {
        return (Integer)state.getValue((Property)AGE) == 0 || direction != Direction.UP;
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        if ((Integer)state.getValue((Property)AGE) != 5) {
            world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(5)), 3);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos offsetPos = pos.relative(direction);
                BlockState directionState = world.getBlockState(offsetPos);
                if (!(directionState.getBlock() instanceof EtherealPlatformBlock)) continue;
                world.setBlock(offsetPos, (BlockState)((BlockState)directionState.setValue((Property)AGE, (Comparable)Integer.valueOf(4))).setValue((Property)EXTEND, (Comparable)Boolean.valueOf(true)), 2);
                world.scheduleTick(offsetPos, (Block)this, 2);
            }
        }
        super.stepOn(world, pos, state, entity);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int age = (Integer)state.getValue((Property)AGE);
        boolean extend = (Boolean)state.getValue((Property)EXTEND);
        if (extend && age > 1) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos offsetPos = pos.relative(direction);
                BlockState directionState = world.getBlockState(offsetPos);
                if (!(directionState.getBlock() instanceof EtherealPlatformBlock) || age <= (Integer)directionState.getValue((Property)AGE)) continue;
                world.setBlock(offsetPos, (BlockState)((BlockState)directionState.setValue((Property)AGE, (Comparable)Integer.valueOf(age - 1))).setValue((Property)EXTEND, (Comparable)Boolean.valueOf(true)), 2);
                world.scheduleTick(offsetPos, (Block)this, 2);
            }
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)EXTEND, (Comparable)Boolean.valueOf(false)));
        } else if (!extend && this.increaseAge(state, (Level)world, pos)) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.values()) {
                mutable.setWithOffset((Vec3i)pos, direction);
                BlockState blockState = world.getBlockState((BlockPos)mutable);
                if (!blockState.is((Block)this) || this.increaseAge(blockState, (Level)world, (BlockPos)mutable)) continue;
                world.scheduleTick((BlockPos)mutable, (Block)this, 4);
            }
        }
        if (age > 0) {
            world.scheduleTick(pos, (Block)this, 10);
        }
    }

    private boolean increaseAge(BlockState state, Level world, BlockPos pos) {
        int i = (Integer)state.getValue((Property)AGE);
        if (i > 0) {
            world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i - 1))).setValue((Property)EXTEND, (Comparable)Boolean.valueOf(false)), 2);
            return false;
        }
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Deprecated
    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityShapeContext;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (entityShapeContext = (EntityCollisionContext)context).getEntity()) instanceof LivingEntity) {
            return state.getShape(world, pos);
        }
        return Shapes.empty();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, EXTEND});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        int age = (Integer)state.getValue((Property)AGE);
        if (world.isClientSide && Minecraft.getInstance().player.getMainHandItem().is(((Block)PastelBlocks.ETHEREAL_PLATFORM.get()).asItem())) {
            age = Math.max(age, 3);
        }
        if (age > 0) {
            for (int i = 0; i < age; ++i) {
                double d = (float)pos.getX() + random.nextFloat();
                double e = (double)pos.getY() + 1.01;
                double f = (float)pos.getZ() + random.nextFloat();
                world.addParticle((ParticleOptions)PastelParticleTypes.LIQUID_CRYSTAL_SPARKLE, d, e, f, 0.0, 0.03, 0.0);
            }
        }
    }
}

