/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.decoration;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.entity.entity.SeatEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CushionBlock
extends Block {
    public static final MapCodec<CushionBlock> CODEC = CushionBlock.simpleCodec(CushionBlock::new);
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    public static final double SITTING_OFFSET = 0.3125;

    public CushionBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public MapCodec<? extends CushionBlock> codec() {
        return CODEC;
    }

    public void updateEntityAfterFallOn(BlockGetter world, Entity entity) {
        if (entity.isSuppressingBounce()) {
            super.updateEntityAfterFallOn(world, entity);
        } else {
            this.bounce(entity);
        }
    }

    private void bounce(Entity entity) {
        Vec3 vec3d = entity.getDeltaMovement();
        if (vec3d.y < 0.0) {
            entity.setDeltaMovement(vec3d.x, -vec3d.y, vec3d.z);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        SeatEntity seat = this.getOrCreateSeatEntity(world, pos, state);
        if (seat.getFirstPassenger() == null) {
            player.startRiding((Entity)seat, true);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        super.playerWillDestroy(world, pos, state, player);
        SeatEntity seat = this.getOrCreateSeatEntity(world, pos, state);
        seat.remove(Entity.RemovalReason.DISCARDED);
        return state;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        super.onRemove(state, world, pos, newState, moved);
        if (!moved && !state.is(newState.getBlock())) {
            SeatEntity seat = this.getOrCreateSeatEntity(world, pos, newState);
            seat.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public SeatEntity getOrCreateSeatEntity(Level world, BlockPos pos, BlockState state) {
        SeatEntity seat;
        List seats = world.getEntitiesOfClass(SeatEntity.class, new AABB(pos), seatEntity -> true);
        if (seats.isEmpty()) {
            seat = new SeatEntity(world, 0.3125);
            Vec3 seatPos = Vec3.atLowerCornerOf((Vec3i)pos).add(0.5, 0.3125, 0.5);
            seat.setPos(seatPos);
            seat.setCushion(state);
            world.addFreshEntity((Entity)seat);
        } else {
            seat = (SeatEntity)((Object)seats.getFirst());
        }
        return seat;
    }
}

