/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.decoration;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class CardinalFacingBlock
extends Block {
    public static final MapCodec<CardinalFacingBlock> CODEC = CardinalFacingBlock.simpleCodec(CardinalFacingBlock::new);
    public static final BooleanProperty CARDINAL_FACING = BooleanProperty.create((String)"cardinal_facing");

    public CardinalFacingBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CARDINAL_FACING, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends CardinalFacingBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction facing = ctx.getHorizontalDirection();
        boolean facingVertical = facing.equals((Object)Direction.EAST) || facing.equals((Object)Direction.WEST);
        return (BlockState)this.defaultBlockState().setValue((Property)CARDINAL_FACING, (Comparable)Boolean.valueOf(facingVertical));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CARDINAL_FACING});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        boolean cardinal = (Boolean)state.getValue((Property)CARDINAL_FACING);
        return (BlockState)state.setValue((Property)CARDINAL_FACING, (Comparable)Boolean.valueOf(rotation.ordinal() % 2 == 1 != cardinal));
    }
}

