/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.conditional;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.FluidLogging;
import earth.terrarium.pastel.blocks.fluid.PastelFluid;
import earth.terrarium.pastel.registries.PastelBlockTags;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelFluids;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuitoxicReedsBlock
extends Block
implements FluidLogging.PastelFluidLoggable {
    public static final MapCodec<QuitoxicReedsBlock> CODEC = QuitoxicReedsBlock.simpleCodec(QuitoxicReedsBlock::new);
    public static final EnumProperty<FluidLogging.State> LOGGED = FluidLogging.ANY_INCLUDING_NONE;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_7;
    public static final BooleanProperty ALWAYS_DROP = BooleanProperty.create((String)"always_drop");
    public static final int MAX_GROWTH_HEIGHT_WATER = 5;
    public static final int MAX_GROWTH_HEIGHT_CRYSTAL = 7;
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public QuitoxicReedsBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(LOGGED, (Comparable)((Object)FluidLogging.State.NOT_LOGGED))).setValue((Property)ALWAYS_DROP, (Comparable)Boolean.valueOf(false))).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public MapCodec<? extends QuitoxicReedsBlock> codec() {
        return CODEC;
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.getLevel().getFluidState(ctx.getClickedPos());
        if (fluidState.is(FluidTags.WATER) && fluidState.getAmount() == 8) {
            return (BlockState)super.getStateForPlacement(ctx).setValue(LOGGED, (Comparable)((Object)FluidLogging.State.WATER));
        }
        if (fluidState.getType() == PastelFluids.LIQUID_CRYSTAL.get()) {
            return (BlockState)super.getStateForPlacement(ctx).setValue(LOGGED, (Comparable)((Object)FluidLogging.State.LIQUID_CRYSTAL));
        }
        return (BlockState)super.getStateForPlacement(ctx).setValue(LOGGED, (Comparable)((Object)FluidLogging.State.NOT_LOGGED));
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos offsetPos;
        for (int i = 1; i < 7 && world.getBlockState(offsetPos = pos.offset(0, i, 0)).is((Block)this); ++i) {
            world.setBlockAndUpdate(offsetPos, (BlockState)world.getBlockState(offsetPos).setValue((Property)ALWAYS_DROP, (Comparable)Boolean.valueOf(true)));
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        FluidLogging.State fluidLog = (FluidLogging.State)((Object)state.getValue(LOGGED));
        if (fluidLog == FluidLogging.State.WATER) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        } else if (fluidLog == FluidLogging.State.LIQUID_CRYSTAL) {
            world.scheduleTick(pos, (Fluid)PastelFluids.LIQUID_CRYSTAL.get(), ((PastelFluid)((Object)PastelFluids.LIQUID_CRYSTAL.get())).getTickDelay((LevelReader)world));
        }
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.scheduleTick(pos, (Block)this, 1);
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public FluidState getFluidState(BlockState state) {
        return ((FluidLogging.State)((Object)state.getValue(LOGGED))).getFluidState();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, LOGGED, ALWAYS_DROP});
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        super.entityInside(state, world, pos, entity);
        ((FluidLogging.State)((Object)state.getValue(LOGGED))).onEntityCollision(state, world, pos, entity);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        boolean bottomLiquidCrystalLogged;
        if (world.getBlockState(pos.above()).is((Block)this) || !this.canGrow((LevelReader)world, pos.above())) {
            return;
        }
        int height = 1;
        while (world.getBlockState(pos.below(height)).is((Block)this)) {
            ++height;
        }
        boolean bl = bottomLiquidCrystalLogged = world.getBlockState(pos.below(height - 1)).getValue(LOGGED) == FluidLogging.State.LIQUID_CRYSTAL;
        if (height < 5 || bottomLiquidCrystalLogged && height < 7) {
            int age = (Integer)state.getValue((Property)AGE);
            if (age == 7) {
                Optional<BlockPos> posToConsumeBlock = this.searchPlantablePos((Level)world, pos.below(height), PastelBlockTags.QUITOXIC_REEDS_PLANTABLE, random);
                if (posToConsumeBlock.isEmpty() || world.getBlockState(posToConsumeBlock.get().above()).getBlock() instanceof QuitoxicReedsBlock) {
                    return;
                }
                if (!bottomLiquidCrystalLogged || random.nextInt(4) == 0) {
                    world.setBlock(posToConsumeBlock.get(), Blocks.DIRT.defaultBlockState(), 3);
                    world.playSound(null, posToConsumeBlock.get(), SoundEvents.GRAVEL_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                world.setBlockAndUpdate(pos.above(), this.getStateForPos((Level)world, pos.above()));
                world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0)), 4);
            } else if (bottomLiquidCrystalLogged) {
                world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(Math.min(7, age + 2))), 4);
            } else {
                world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 4);
            }
        }
    }

    private Optional<BlockPos> searchPlantablePos(Level world, @NotNull BlockPos searchPos, TagKey<Block> searchBlockState, RandomSource random) {
        List directions = Util.shuffledCopy((Object[])Direction.values(), (RandomSource)random);
        int i = 0;
        int range = 8;
        BlockPos currentPos = new BlockPos(searchPos.getX(), searchPos.getY(), searchPos.getZ());
        while (i < 6) {
            if (range < 8 && world.getBlockState(currentPos.relative((Direction)directions.get(i))).is(searchBlockState)) {
                ++range;
                currentPos = currentPos.relative((Direction)directions.get(i));
                continue;
            }
            ++i;
            range = 0;
        }
        if (currentPos.equals((Object)searchPos)) {
            return Optional.empty();
        }
        return Optional.of(currentPos);
    }

    public BlockState getStateForPos(Level world, BlockPos blockPos) {
        FluidState fluidState = world.getFluidState(blockPos);
        if (fluidState.is(FluidTags.WATER) && fluidState.getAmount() == 8) {
            return (BlockState)this.defaultBlockState().setValue(LOGGED, (Comparable)((Object)FluidLogging.State.WATER));
        }
        if (fluidState.getType().equals(PastelFluids.LIQUID_CRYSTAL.get())) {
            return (BlockState)this.defaultBlockState().setValue(LOGGED, (Comparable)((Object)FluidLogging.State.LIQUID_CRYSTAL));
        }
        return this.defaultBlockState();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 vec3d = state.getOffset(world, pos);
        return SHAPE.move(vec3d.x, vec3d.y, vec3d.z);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return this.isValidBlock(world, pos);
    }

    private boolean isValidBlock(LevelReader world, BlockPos pos) {
        BlockState downState = world.getBlockState(pos.below());
        if (downState.is((Block)this)) {
            return true;
        }
        if (!downState.is(PastelBlockTags.QUITOXIC_REEDS_PLANTABLE)) {
            return false;
        }
        BlockState upState = world.getBlockState(pos.above());
        BlockState upState2 = world.getBlockState(pos.above(2));
        if (!(upState.is((Block)this) || upState.isAir() || upState2.isAir())) {
            return false;
        }
        BlockState state = world.getBlockState(pos);
        if (state.is((Block)this)) {
            return true;
        }
        FluidState fluidState = world.getFluidState(pos);
        return fluidState.getAmount() == 8 && (fluidState.is(FluidTags.WATER) || state.is((Block)PastelBlocks.LIQUID_CRYSTAL.get()));
    }

    private boolean canGrow(LevelReader world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        if (state.isAir()) {
            return true;
        }
        FluidState fluidState = world.getFluidState(pos);
        return fluidState.getAmount() == 8 && (fluidState.is(FluidTags.WATER) || state.is((Block)PastelBlocks.LIQUID_CRYSTAL.get()));
    }

    public float getMaxHorizontalOffset() {
        return 0.15f;
    }
}

