/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.conditional;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.registries.PastelItems;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class BloodOrchidBlock
extends FlowerBlock
implements BonemealableBlock {
    public static final MapCodec<BloodOrchidBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EFFECTS_FIELD.forGetter(FlowerBlock::getSuspiciousEffects), (App)BloodOrchidBlock.propertiesCodec()).apply((Applicative)instance, BloodOrchidBlock::new));
    public static final IntegerProperty AGE = BlockStateProperties.AGE_5;

    public BloodOrchidBlock(Holder<MobEffect> stewEffect, float effectLengthInSeconds, BlockBehaviour.Properties settings) {
        this(BloodOrchidBlock.makeEffectList(stewEffect, (float)effectLengthInSeconds), settings);
    }

    public BloodOrchidBlock(SuspiciousStewEffects stewEffects, BlockBehaviour.Properties settings) {
        super(stewEffects, settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public MapCodec<? extends BloodOrchidBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    private void growOnce(BlockState state, ServerLevel world, BlockPos pos) {
        BlockState newState = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)AGE) + 1));
        world.setBlockAndUpdate(pos, newState);
        world.playSound(null, pos, state.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if ((Integer)state.getValue((Property)AGE) < 5 && (double)random.nextFloat() <= 0.25) {
            this.growOnce(state, world, pos);
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        int age = (Integer)state.getValue((Property)AGE);
        if (age > 0) {
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age - 1)));
            player.getInventory().placeItemBackInInventory(((Item)PastelItems.BLOOD_ORCHID_PETAL.get()).getDefaultInstance());
            level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 0.9f + level.random.nextFloat() * 0.2f);
            Support.areaCriterion((ServerLevel)level, 8, pos, Optional.empty(), p -> PastelCriteria.BLOOD_ORCHID_PLUCKING.trigger((ServerPlayer)p));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 5;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        this.growOnce(state, world, pos);
    }
}

