/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.cinderhearth;

import earth.terrarium.pastel.api.block.MultiblockCrafter;
import earth.terrarium.pastel.api.block.PlayerOwned;
import earth.terrarium.pastel.api.energy.InkStorage;
import earth.terrarium.pastel.api.energy.InkStorageBlockEntity;
import earth.terrarium.pastel.api.energy.InkStorageItem;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.api.energy.storage.IndividualCappedInkStorage;
import earth.terrarium.pastel.api.recipe.GatedRecipe;
import earth.terrarium.pastel.blocks.BaseInventoryBlockEntity;
import earth.terrarium.pastel.blocks.CraftingDelegate;
import earth.terrarium.pastel.blocks.cinderhearth.CinderhearthBlock;
import earth.terrarium.pastel.blocks.upgrade.Upgradeable;
import earth.terrarium.pastel.capabilities.ExperienceHandler;
import earth.terrarium.pastel.capabilities.PastelCapabilities;
import earth.terrarium.pastel.capabilities.SidedCapabilityProvider;
import earth.terrarium.pastel.capabilities.item.FriendlyStackHandler;
import earth.terrarium.pastel.capabilities.item.StackHandlerView;
import earth.terrarium.pastel.components.InkStorageComponent;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.data.CodecHelper;
import earth.terrarium.pastel.helpers.interaction.InventoryHelper;
import earth.terrarium.pastel.inventories.CinderhearthScreenHandler;
import earth.terrarium.pastel.networking.s2c_payloads.PlayParticleWithRandomOffsetAndVelocityPayload;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.recipe.cinderhearth.CinderhearthRecipe;
import earth.terrarium.pastel.registries.PastelAdvancements;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelItemTags;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CinderhearthBlockEntity
extends BaseInventoryBlockEntity
implements MultiblockCrafter,
SidedCapabilityProvider,
InkStorageBlockEntity<IndividualCappedInkStorage>,
StackedContentsCompatible {
    public static final int INVENTORY_SIZE = 11;
    public static final int INPUT_SLOT_ID = 0;
    public static final int INK_PROVIDER_SLOT_ID = 1;
    public static final int EXPERIENCE_STORAGE_ITEM_SLOT_ID = 2;
    public static final int FIRST_OUTPUT_SLOT_ID = 3;
    public static final int LAST_OUTPUT_SLOT_ID = 10;
    public static final int[] OUTPUT_SLOT_IDS = new int[]{3, 4, 5, 6, 7, 8, 9, 10};
    protected FriendlyStackHandler inventory;
    protected boolean inventoryChanged;
    public static final List<InkColor> USED_INK_COLORS = List.of(InkColors.ORANGE, InkColors.MAGENTA, InkColors.LIGHT_BLUE, InkColors.PURPLE, InkColors.BLACK);
    public static final long INK_STORAGE_SIZE = 51200L;
    public static final long INK_COST_PER_TICK = 8L;
    protected IndividualCappedInkStorage inkStorage;
    private UUID ownerUUID;
    private Upgradeable.UpgradeHolder upgrades;
    private RecipeHolder<?> currentRecipe;
    private boolean usesEfficiency;
    protected boolean canTransferInk;
    protected boolean inkDirty;
    protected CinderHearthStructureType structure = CinderHearthStructureType.NONE;
    protected final CraftingDelegate propertyDelegate = new CraftingDelegate();

    public int[] getSlotsForFace(Direction side) {
        if (side != Direction.DOWN) {
            return new int[]{0};
        }
        return OUTPUT_SLOT_IDS;
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStack, @Nullable Direction direction) {
        if (index == 0) {
            return direction != Direction.DOWN;
        }
        return false;
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        if (index != 0) {
            return direction == Direction.DOWN;
        }
        return false;
    }

    public CinderhearthBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PastelBlockEntities.CINDERHEARTH.get(), pos, state);
        this.inventory = new FriendlyStackHandler(11);
        this.inkStorage = new IndividualCappedInkStorage(51200L, USED_INK_COLORS);
        this.inventory.addListener(i -> this.inventoryChanged());
    }

    @Override
    protected FriendlyStackHandler getHandler() {
        return this.inventory;
    }

    @Override
    public void resetUpgrades() {
        this.upgrades = null;
        this.setChanged();
    }

    @Override
    public void calculateUpgrades() {
        if (this.level == null) {
            return;
        }
        this.upgrades = Upgradeable.calculateUpgradeMods2(this.level, this.worldPosition, Support.rotationFromDirection((Direction)this.level.getBlockState(this.worldPosition).getValue((Property)CinderhearthBlock.FACING)), 2, 1, 1, this.ownerUUID);
        this.updateInClientWorld();
        this.setChanged();
    }

    public void updateInClientWorld() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            serverWorld.getChunkSource().blockChanged(this.worldPosition);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        CompoundTag nbtCompound = new CompoundTag();
        this.saveAdditional(nbtCompound, registryLookup);
        return nbtCompound;
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwner(Player playerEntity) {
        this.ownerUUID = playerEntity.getUUID();
        this.setChanged();
    }

    @Override
    protected Component getDefaultName() {
        return Component.translatable((String)"block.pastel.cinderhearth");
    }

    @Override
    protected AbstractContainerMenu createMenu(int syncId, Inventory playerInventory) {
        return new CinderhearthScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    public void writeClientSideData(AbstractContainerMenu menu, RegistryFriendlyByteBuf buffer) {
        BlockPos.STREAM_CODEC.encode((Object)buffer, (Object)this.worldPosition);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.inventory.deserializeNBT(registryLookup, nbt.getCompound("inventory"));
        CodecHelper.fromNbt(InkStorageComponent.CODEC, nbt.get("InkStorage")).ifPresent(storage -> {
            this.inkStorage = new IndividualCappedInkStorage(storage.maxPerColor(), storage.storedEnergy());
        });
        this.propertyDelegate.craftingTime = nbt.getShort("CraftingTime");
        this.propertyDelegate.craftingTimeTotal = nbt.getShort("CraftingTimeTotal");
        this.usesEfficiency = nbt.getBoolean("UsesEfficiency");
        this.canTransferInk = nbt.getBoolean("Paused");
        this.inventoryChanged = nbt.getBoolean("InventoryChanged");
        this.structure = nbt.contains("Structure", 99) ? CinderHearthStructureType.values()[nbt.getInt("Structure")] : CinderHearthStructureType.NONE;
        this.ownerUUID = PlayerOwned.readOwnerUUID(nbt);
        this.currentRecipe = MultiblockCrafter.getRecipeEntryFromNbt(this.level, nbt);
        this.upgrades = nbt.contains("Upgrades", 9) ? Upgradeable.UpgradeHolder.fromNbt(nbt.getList("Upgrades", 10)) : new Upgradeable.UpgradeHolder();
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.put("inventory", (Tag)this.inventory.serializeNBT(registryLookup));
        CodecHelper.writeNbt(nbt, "InkStorage", InkStorageComponent.CODEC, new InkStorageComponent(this.inkStorage));
        nbt.putShort("CraftingTime", (short)this.propertyDelegate.craftingTime);
        nbt.putShort("CraftingTimeTotal", (short)this.propertyDelegate.craftingTimeTotal);
        nbt.putBoolean("UsesEfficiency", this.usesEfficiency);
        nbt.putBoolean("Paused", this.canTransferInk);
        nbt.putBoolean("InventoryChanged", this.inventoryChanged);
        nbt.putInt("Structure", this.structure.ordinal());
        if (this.upgrades != null) {
            nbt.put("Upgrades", (Tag)this.upgrades.toNbt());
        }
        PlayerOwned.writeOwnerUUID(nbt, this.ownerUUID);
        if (this.currentRecipe != null) {
            nbt.putString("CurrentRecipe", this.currentRecipe.id().toString());
        }
    }

    public static void serverTick(Level world, BlockPos blockPos, BlockState blockState, CinderhearthBlockEntity cinder) {
        if (cinder.upgrades == null) {
            cinder.calculateUpgrades();
        }
        cinder.inkDirty = false;
        if (cinder.canTransferInk) {
            boolean didSomething = false;
            ItemStack stack = cinder.inventory.getStackInSlot(1);
            Item item = stack.getItem();
            if (item instanceof InkStorageItem) {
                InkStorageItem inkStorageItem = (InkStorageItem)item;
                Object itemStorage = inkStorageItem.getEnergyStorage(stack);
                boolean bl = didSomething = InkStorage.transferInk(itemStorage, cinder.inkStorage) != 0L;
                if (didSomething) {
                    inkStorageItem.setEnergyStorage(stack, (InkStorage)itemStorage);
                }
            }
            if (didSomething) {
                cinder.setChanged();
                cinder.setInkDirty();
            } else {
                cinder.canTransferInk = false;
            }
        }
        if (cinder.inventoryChanged) {
            CinderhearthBlockEntity.calculateRecipe(world, cinder);
            cinder.inventoryChanged = false;
            cinder.updateInClientWorld();
        }
        if (cinder.currentRecipe != null) {
            if (!CinderhearthBlockEntity.canContinue(world, blockPos, cinder)) {
                cinder.currentRecipe = null;
                cinder.propertyDelegate.craftingTime = 0;
                cinder.propertyDelegate.craftingTimeTotal = 0;
                cinder.setChanged();
                return;
            }
            if (cinder.propertyDelegate.craftingTime == 0) {
                int baseTime;
                RecipeHolder<?> recipe = cinder.currentRecipe;
                cinder.usesEfficiency = cinder.drainInkForUpgradesRequired(cinder, Upgradeable.UpgradeType.EFFICIENCY, InkColors.BLACK, false);
                Recipe recipe2 = recipe.value();
                if (recipe2 instanceof AbstractCookingRecipe) {
                    AbstractCookingRecipe abstractCookingRecipe = (AbstractCookingRecipe)recipe2;
                    v1 = abstractCookingRecipe.getCookingTime();
                } else {
                    recipe2 = recipe.value();
                    if (recipe2 instanceof CinderhearthRecipe) {
                        CinderhearthRecipe cinderhearthRecipe = (CinderhearthRecipe)recipe2;
                        v1 = cinderhearthRecipe.getCraftingTime();
                    } else {
                        v1 = baseTime = -1;
                    }
                }
                if (baseTime >= 0) {
                    float speedModifier = cinder.drainInkForUpgrades(cinder, Upgradeable.UpgradeType.SPEED, InkColors.MAGENTA, cinder.usesEfficiency);
                    cinder.propertyDelegate.craftingTimeTotal = (int)Math.ceil((float)baseTime / speedModifier);
                }
            }
            ++cinder.propertyDelegate.craftingTime;
            if (cinder.propertyDelegate.craftingTime == cinder.propertyDelegate.craftingTimeTotal) {
                Recipe<?> recipe = cinder.getCurrentRecipe();
                if (recipe instanceof CinderhearthRecipe) {
                    CinderhearthRecipe cinderhearthRecipe = (CinderhearthRecipe)recipe;
                    CinderhearthBlockEntity.craftCinderhearthRecipe(world, cinder, cinderhearthRecipe);
                } else {
                    recipe = cinder.getCurrentRecipe();
                    if (recipe instanceof BlastingRecipe) {
                        BlastingRecipe blastingRecipe = (BlastingRecipe)recipe;
                        CinderhearthBlockEntity.craftBlastingRecipe(world, cinder, blastingRecipe);
                    }
                }
            }
            cinder.setChanged();
        }
    }

    private static boolean canContinue(Level world, BlockPos blockPos, CinderhearthBlockEntity cinder) {
        if (!CinderhearthBlockEntity.canAcceptRecipeOutput(world, cinder.currentRecipe, cinder.inventory)) {
            return false;
        }
        if (cinder.propertyDelegate.craftingTime % 20 == 0) {
            if (!CinderhearthBlockEntity.checkRecipeRequirements(world, blockPos, cinder)) {
                return false;
            }
            return cinder.drainInkForUpgradesRequired(cinder, InkColors.ORANGE, 8L, cinder.usesEfficiency);
        }
        return true;
    }

    protected static boolean canAcceptRecipeOutput(Level world, RecipeHolder<?> recipe, FriendlyStackHandler inventory) {
        if (recipe != null) {
            ItemStack outputStack = recipe.value().getResultItem((HolderLookup.Provider)world.registryAccess());
            if (outputStack.isEmpty()) {
                return true;
            }
            int outputSpaceFound = 0;
            for (int slot : OUTPUT_SLOT_IDS) {
                ItemStack slotStack = inventory.getStackInSlot(slot);
                if (slotStack.isEmpty()) {
                    return true;
                }
                if (!ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)outputStack) || (outputSpaceFound += outputStack.getMaxStackSize() - slotStack.getCount()) < outputStack.getCount()) continue;
                return true;
            }
        }
        return false;
    }

    private static void calculateRecipe(@NotNull Level world, @NotNull CinderhearthBlockEntity cinderhearthBlockEntity) {
        BlastingRecipe recipe;
        CinderhearthRecipe recipe2;
        SingleRecipeInput input = new SingleRecipeInput(cinderhearthBlockEntity.inventory.getStackInSlot(0));
        Recipe<?> recipe3 = cinderhearthBlockEntity.getCurrentRecipe();
        if (recipe3 instanceof CinderhearthRecipe ? (recipe2 = (CinderhearthRecipe)recipe3).matches(input, world) : (recipe3 = cinderhearthBlockEntity.getCurrentRecipe()) instanceof BlastingRecipe && (recipe = (BlastingRecipe)recipe3).matches(input, world)) {
            return;
        }
        cinderhearthBlockEntity.currentRecipe = null;
        cinderhearthBlockEntity.propertyDelegate.craftingTime = 0;
        cinderhearthBlockEntity.propertyDelegate.craftingTimeTotal = -1;
        ItemStack inputStack = cinderhearthBlockEntity.inventory.getStackInSlot(0);
        if (!inputStack.isEmpty()) {
            world.getRecipeManager().getRecipeFor(PastelRecipeTypes.CINDERHEARTH, (RecipeInput)input, world).ifPresentOrElse(r -> {
                cinderhearthBlockEntity.currentRecipe = r;
            }, () -> world.getRecipeManager().getRecipeFor(RecipeType.BLASTING, (RecipeInput)input, world).ifPresent(r -> {
                cinderhearthBlockEntity.currentRecipe = r;
            }));
        }
    }

    private static boolean checkRecipeRequirements(Level world, BlockPos blockPos, @NotNull CinderhearthBlockEntity cinderhearthBlockEntity) {
        Player lastInteractedPlayer = PlayerOwned.getPlayerEntityIfOnline(cinderhearthBlockEntity.ownerUUID);
        if (lastInteractedPlayer == null) {
            return false;
        }
        cinderhearthBlockEntity.structure = CinderhearthBlock.verifyStructure(world, blockPos);
        if (cinderhearthBlockEntity.structure == CinderHearthStructureType.NONE) {
            world.playSound(null, cinderhearthBlockEntity.getBlockPos(), PastelSounds.CRAFTING_ABORTED, SoundSource.BLOCKS, 0.9f + world.random.nextFloat() * 0.2f, 0.9f + world.random.nextFloat() * 0.2f);
            return false;
        }
        Recipe<?> recipe = cinderhearthBlockEntity.getCurrentRecipe();
        if (recipe instanceof GatedRecipe) {
            GatedRecipe gatedRecipe = (GatedRecipe)recipe;
            return gatedRecipe.canPlayerCraft(lastInteractedPlayer);
        }
        return true;
    }

    public static void craftBlastingRecipe(Level world, @NotNull CinderhearthBlockEntity cinderhearth, @NotNull BlastingRecipe blastingRecipe) {
        ItemStack inputStack = cinderhearth.inventory.getStackInSlot(0);
        float yieldMod = inputStack.is(PastelItemTags.NO_CINDERHEARTH_DOUBLING) ? 1.0f : cinderhearth.drainInkForUpgrades(cinderhearth, Upgradeable.UpgradeType.YIELD, InkColors.LIGHT_BLUE, cinderhearth.usesEfficiency);
        ItemStack output = blastingRecipe.getResultItem((HolderLookup.Provider)world.registryAccess()).copy();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        if (yieldMod > 1.0f) {
            int count;
            for (int outputCount = Support.chanceRound((float)output.getCount() * yieldMod, world.random); outputCount > 0; outputCount -= count) {
                count = Math.min(outputCount, output.getMaxStackSize());
                ItemStack outputStack = output.copy();
                outputStack.setCount(count);
                outputs.add(outputStack);
            }
        } else {
            outputs.add(output.copy());
        }
        CinderhearthBlockEntity.craftRecipe(cinderhearth, inputStack, outputs, blastingRecipe.getExperience());
    }

    public static void craftCinderhearthRecipe(Level world, @NotNull CinderhearthBlockEntity cinderhearth, @NotNull CinderhearthRecipe cinderhearthRecipe) {
        ItemStack inputStack = cinderhearth.inventory.getStackInSlot(0);
        float yieldMod = inputStack.is(PastelItemTags.NO_CINDERHEARTH_DOUBLING) ? 1.0f : cinderhearth.drainInkForUpgrades(cinderhearth, Upgradeable.UpgradeType.YIELD, InkColors.LIGHT_BLUE, cinderhearth.usesEfficiency);
        List<ItemStack> outputs = cinderhearthRecipe.getRolledOutputs(world.random, yieldMod);
        CinderhearthBlockEntity.craftRecipe(cinderhearth, inputStack, outputs, cinderhearthRecipe.getExperience());
    }

    private static void craftRecipe(@NotNull CinderhearthBlockEntity cinderhearth, ItemStack inputStack, List<ItemStack> outputs, float experience) {
        Level level = cinderhearth.level;
        if (level == null) {
            return;
        }
        FriendlyStackHandler backupInventory = new FriendlyStackHandler(11);
        for (int i = 0; i < cinderhearth.inventory.getSlots(); ++i) {
            backupInventory.setStackInSlot(i, cinderhearth.inventory.getStackInSlot(i));
        }
        boolean couldAdd = InventoryHelper.addToInventory((IItemHandlerModifiable)cinderhearth.inventory, outputs, 3, 11);
        if (couldAdd) {
            boolean remainderAdded;
            int n;
            ItemStack remainder = inputStack.getCraftingRemainingItem();
            ItemStack inputStackCopy = inputStack.copy();
            Recipe<?> recipe = cinderhearth.getCurrentRecipe();
            if (recipe instanceof CinderhearthRecipe) {
                CinderhearthRecipe cinderhearthRecipe = (CinderhearthRecipe)recipe;
                n = cinderhearthRecipe.getIngredientStacks().getFirst().getCount();
            } else {
                n = 1;
            }
            int amountToDecrementInput = n;
            inputStack.shrink(amountToDecrementInput);
            if (!remainder.isEmpty() && !(remainderAdded = InventoryHelper.addToInventory((IItemHandlerModifiable)cinderhearth.inventory, remainder, 3, 11)) && inputStack.isEmpty()) {
                cinderhearth.inventory.setStackInSlot(0, remainder);
            }
            CinderhearthBlockEntity.playCraftingFinishedEffects(cinderhearth);
            cinderhearth.propertyDelegate.craftingTime = 0;
            cinderhearth.inventoryChanged();
            float experienceMod = cinderhearth.drainInkForUpgrades(cinderhearth, Upgradeable.UpgradeType.EXPERIENCE, InkColors.PURPLE, cinderhearth.usesEfficiency);
            int finalExperience = Support.chanceRound(experience * experienceMod, level.random);
            ExperienceHandler storage = (ExperienceHandler)cinderhearth.inventory.getStackInSlot(2).getCapability(PastelCapabilities.Misc.XP, (Object)level.registryAccess());
            if (storage != null) {
                storage.insert(finalExperience, false);
            }
            cinderhearth.grantPlayerCinderhearthSmeltingAdvancement(inputStackCopy, outputs, finalExperience);
        } else {
            cinderhearth.inventory = backupInventory;
            cinderhearth.propertyDelegate.craftingTimeTotal = -1;
            cinderhearth.currentRecipe = null;
            cinderhearth.inventoryChanged = false;
        }
    }

    public void grantPlayerCinderhearthSmeltingAdvancement(ItemStack input, List<ItemStack> outputs, int experience) {
        Support.areaCriterion((ServerLevel)this.level, 8, this.getBlockPos(), PastelAdvancements.Unlocks.Blocks.CINDERHEARTH, p -> PastelCriteria.CINDERHEARTH_SMELTING.trigger((ServerPlayer)p, input, outputs, experience, this.upgrades));
    }

    public static void playCraftingFinishedEffects(@NotNull CinderhearthBlockEntity cinderhearthBlockEntity) {
        Direction.Axis axis = null;
        Direction direction = Direction.UP;
        Level level = cinderhearthBlockEntity.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        for (Map.Entry entry : cinderhearthBlockEntity.upgrades.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            if (axis == null) {
                BlockState state = world.getBlockState(cinderhearthBlockEntity.worldPosition);
                direction = (Direction)state.getValue((Property)CinderhearthBlock.FACING);
                axis = direction.getAxis();
            }
            double d = (double)cinderhearthBlockEntity.worldPosition.getX() + 0.5;
            double f = (double)cinderhearthBlockEntity.worldPosition.getZ() + 0.5;
            double g2 = -0.1875;
            double h2 = 0.25;
            double i2 = axis == Direction.Axis.X ? (double)direction.getStepX() * g2 : h2;
            double k2 = axis == Direction.Axis.Z ? (double)direction.getStepZ() * g2 : h2;
            PlayParticleWithRandomOffsetAndVelocityPayload.playParticleWithRandomOffsetAndVelocity(world, new Vec3(d + i2, (double)cinderhearthBlockEntity.worldPosition.getY() + 1.1, f + k2), (ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, 3, new Vec3(0.05, 0.0, 0.05), new Vec3(0.0, 0.3, 0.0));
        }
    }

    public void inventoryChanged() {
        this.inventoryChanged = true;
        this.canTransferInk = true;
        this.setChanged();
    }

    @Override
    public Upgradeable.UpgradeHolder getUpgradeHolder() {
        return this.upgrades;
    }

    @Override
    public IndividualCappedInkStorage getEnergyStorage() {
        return this.inkStorage;
    }

    @Override
    public void setInkDirty() {
        this.inkDirty = true;
    }

    @Override
    public boolean getInkDirty() {
        return this.inkDirty;
    }

    public RecipeHolder<?> getCurrentRecipeEntry() {
        return this.currentRecipe;
    }

    public Recipe<?> getCurrentRecipe() {
        return this.currentRecipe == null ? null : this.currentRecipe.value();
    }

    public void fillStackedContents(StackedContents finder) {
        this.inventory.getInternalList().forEach(arg_0 -> ((StackedContents)finder).accountStack(arg_0));
    }

    @Override
    public IItemHandler exposeItemHandlers(Direction dir) {
        if (dir == Direction.DOWN) {
            return new StackHandlerView(this.inventory, 3, OUTPUT_SLOT_IDS.length).disableInsertion();
        }
        return new StackHandlerView(this.inventory, 0).disableExtraction();
    }

    public static enum CinderHearthStructureType {
        NONE,
        WITH_LAVA,
        WITHOUT_LAVA;

    }
}

