/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.cinderhearth;

import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.cinderhearth.CinderhearthBlockEntity;
import earth.terrarium.pastel.compat.modonomicon.ModonomiconHelper;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.particle.effect.ColoredCraftingParticleEffect;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelMultiblocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CinderhearthBlock
extends BaseEntityBlock {
    public static final MapCodec<CinderhearthBlock> CODEC = CinderhearthBlock.simpleCodec(CinderhearthBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public CinderhearthBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.EAST));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CinderhearthBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return world.isClientSide ? null : CinderhearthBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)PastelBlockEntities.CINDERHEARTH.get()), CinderhearthBlockEntity::serverTick);
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            CinderhearthBlock.verifyStructure(world, pos);
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof CinderhearthBlockEntity) {
            CinderhearthBlockEntity cinderhearthBlockEntity = (CinderhearthBlockEntity)blockEntity;
            cinderhearthBlockEntity.setOwner(player);
            if (CinderhearthBlock.verifyStructure(world, pos) != CinderhearthBlockEntity.CinderHearthStructureType.NONE) {
                player.openMenu((MenuProvider)cinderhearthBlockEntity);
            }
        }
        return InteractionResult.CONSUME;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof CinderhearthBlockEntity) {
            CinderhearthBlockEntity cinderhearthBlockEntity = (CinderhearthBlockEntity)blockEntity;
            if (placer instanceof Player) {
                Player player = (Player)placer;
                cinderhearthBlockEntity.setOwner(player);
            }
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof CinderhearthBlockEntity) {
                CinderhearthBlockEntity cinderhearthBlockEntity = (CinderhearthBlockEntity)blockEntity;
                if (world instanceof ServerLevel) {
                    Containers.dropContents((Level)world, (BlockPos)pos, (Container)cinderhearthBlockEntity);
                }
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, moved);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)world.getBlockEntity(pos));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof CinderhearthBlockEntity) {
            CinderhearthBlockEntity cinderhearthBlockEntity = (CinderhearthBlockEntity)blockEntity;
            Direction direction = (Direction)state.getValue((Property)FACING);
            Direction.Axis axis = direction.getAxis();
            double d = (double)pos.getX() + 0.5;
            double e = (double)pos.getY() + 0.4;
            double f = (double)pos.getZ() + 0.5;
            RecipeHolder<?> recipe = cinderhearthBlockEntity.getCurrentRecipeEntry();
            if (recipe != null) {
                if (random.nextDouble() < 0.1) {
                    world.playLocalSound(d, e, f, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 0.8f, false);
                }
                double g = 0.35;
                double h = random.nextDouble() * 0.4 - 0.2;
                double i = axis == Direction.Axis.X ? (double)direction.getStepX() * g : h;
                double j = random.nextDouble() * 4.0 / 16.0;
                double k = axis == Direction.Axis.Z ? (double)direction.getStepZ() * g : h;
                world.addParticle((ParticleOptions)ParticleTypes.FLAME, d + i, e + j, f + k, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, d + i, e + j, f + k, 0.0, 0.0, 0.0);
                if (random.nextBoolean()) {
                    double g2 = -0.1875;
                    double h2 = 0.25;
                    double i2 = axis == Direction.Axis.X ? (double)direction.getStepX() * g2 : h2;
                    double k2 = axis == Direction.Axis.Z ? (double)direction.getStepZ() * g2 : h2;
                    world.addParticle((ParticleOptions)ParticleTypes.CLOUD, d + i2, (double)pos.getY() + 1.1, f + k2, 0.0, 0.06, 0.0);
                }
            }
            if (cinderhearthBlockEntity.structure == CinderhearthBlockEntity.CinderHearthStructureType.WITH_LAVA) {
                for (int v = 0; v < 2; ++v) {
                    double g3 = 1.5 - random.nextDouble() * 2.0;
                    double h3 = 1.5 - random.nextDouble() * 3.0;
                    double i3 = axis == Direction.Axis.X ? (double)direction.getStepX() * g3 : h3;
                    double k3 = axis == Direction.Axis.Z ? (double)direction.getStepZ() * g3 : h3;
                    world.addParticle((ParticleOptions)ColoredCraftingParticleEffect.ORANGE, d + i3, (double)pos.getY() - 1.2, f + k3, 0.0, 0.1, 0.0);
                }
            }
        }
    }

    public static CinderhearthBlockEntity.CinderHearthStructureType verifyStructure(Level level, @NotNull BlockPos blockPos) {
        boolean structureValid;
        Rotation rotation = Support.rotationFromDirection(((Direction)level.getBlockState(blockPos).getValue((Property)FACING)).getOpposite());
        Multiblock multiblock = PastelMultiblocks.get(PastelMultiblocks.CINDERHEARTH);
        CinderhearthBlockEntity.CinderHearthStructureType completedStructure = CinderhearthBlockEntity.CinderHearthStructureType.NONE;
        if (multiblock.validate(level, blockPos.below(3), rotation)) {
            completedStructure = CinderhearthBlockEntity.CinderHearthStructureType.WITH_LAVA;
        } else {
            multiblock = PastelMultiblocks.get(PastelMultiblocks.CINDERHEARTH_WITHOUT_LAVA);
            if (multiblock.validate(level, blockPos.below(3), rotation)) {
                completedStructure = CinderhearthBlockEntity.CinderHearthStructureType.WITHOUT_LAVA;
            }
        }
        boolean bl = structureValid = completedStructure != CinderhearthBlockEntity.CinderHearthStructureType.NONE;
        if (level.isClientSide) {
            if (!structureValid) {
                ModonomiconHelper.renderMultiblock(PastelMultiblocks.get(PastelMultiblocks.CINDERHEARTH), PastelMultiblocks.CINDERHEARTH_TEXT, blockPos.below(4), rotation);
            }
        } else if (structureValid && level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            Support.mbCriterion(sl, blockPos, multiblock);
        }
        return completedStructure;
    }

    public void destroy(LevelAccessor world, BlockPos pos, BlockState state) {
        if (world.isClientSide()) {
            ModonomiconHelper.clearRenderedMultiblock(PastelMultiblocks.get(PastelMultiblocks.CINDERHEARTH));
        }
    }
}

