/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.chests;

import earth.terrarium.pastel.capabilities.SidedCapabilityProvider;
import earth.terrarium.pastel.capabilities.item.FriendlyStackHandler;
import earth.terrarium.pastel.inventories.BlackHoleChestScreenHandler;
import earth.terrarium.pastel.inventories.CompactingChestScreenHandler;
import earth.terrarium.pastel.inventories.FabricationChestScreenHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.SeededContainerLoot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT, _interface=LidBlockEntity.class)
public abstract class PastelChestBlockEntity
extends RandomizableContainerBlockEntity
implements LidBlockEntity,
SidedCapabilityProvider {
    public final ContainerOpenersCounter stateManager;
    protected final ChestLidController lidAnimator;
    protected FriendlyStackHandler inventory = new FriendlyStackHandler(this.getContainerSize());

    protected PastelChestBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
        this.lidAnimator = new ChestLidController();
        this.stateManager = new ContainerOpenersCounter(){

            protected void onOpen(Level world, BlockPos pos, BlockState state) {
                PastelChestBlockEntity.playSound(world, pos, PastelChestBlockEntity.this.getOpenSound());
                PastelChestBlockEntity.this.onOpenSpectrum();
            }

            protected void onClose(Level world, BlockPos pos, BlockState state) {
                PastelChestBlockEntity.playSound(world, pos, PastelChestBlockEntity.this.getCloseSound());
                PastelChestBlockEntity.this.onCloseSpectrum();
            }

            protected void openerCountChanged(Level world, BlockPos pos, BlockState state, int oldViewerCount, int newViewerCount) {
                PastelChestBlockEntity.this.onInvOpenOrClose(world, pos, state, oldViewerCount, newViewerCount);
            }

            protected boolean isOwnContainer(Player player) {
                AbstractContainerMenu screenHandler = player.containerMenu;
                Container inventory = null;
                if (screenHandler instanceof ChestMenu) {
                    inventory = ((ChestMenu)screenHandler).getContainer();
                } else if (screenHandler instanceof FabricationChestScreenHandler) {
                    FabricationChestScreenHandler fabricationChestScreenHandler = (FabricationChestScreenHandler)screenHandler;
                    inventory = fabricationChestScreenHandler.getInventory();
                } else if (screenHandler instanceof BlackHoleChestScreenHandler) {
                    BlackHoleChestScreenHandler blackHoleChestScreenHandler = (BlackHoleChestScreenHandler)screenHandler;
                    inventory = blackHoleChestScreenHandler.getInventory();
                } else if (screenHandler instanceof CompactingChestScreenHandler) {
                    CompactingChestScreenHandler compactingChestScreenHandler = (CompactingChestScreenHandler)screenHandler;
                    inventory = compactingChestScreenHandler.getInventory();
                }
                return inventory == PastelChestBlockEntity.this;
            }
        };
    }

    private static void playSound(Level world, BlockPos pos, SoundEvent soundEvent) {
        world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, soundEvent, SoundSource.BLOCKS, 0.5f, world.random.nextFloat() * 0.1f + 0.9f);
    }

    public static void clientTick(Level world, BlockPos pos, BlockState state, PastelChestBlockEntity blockEntity) {
        blockEntity.lidAnimator.tickLid();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getOpenNess(float tickDelta) {
        return this.lidAnimator.getOpenness(tickDelta);
    }

    public void onOpenSpectrum() {
    }

    public void onCloseSpectrum() {
    }

    public boolean triggerEvent(int type, int data) {
        if (type == 1) {
            this.lidAnimator.shouldBeOpen(data > 0);
            return true;
        }
        return super.triggerEvent(type, data);
    }

    protected void onInvOpenOrClose(Level world, BlockPos pos, BlockState state, int oldViewerCount, int newViewerCount) {
        Block block = state.getBlock();
        world.blockEvent(pos, block, 1, newViewerCount);
    }

    public void startOpen(Player player) {
        if (!player.isSpectator()) {
            this.stateManager.incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player player) {
        if (!player.isSpectator()) {
            this.stateManager.decrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void setItem(int slot, ItemStack stack) {
        super.setItem(slot, stack);
    }

    protected NonNullList<ItemStack> getItems() {
        return this.inventory.getInternalList();
    }

    public ItemStack getItem(int index) {
        return this.inventory.getStackInSlot(index);
    }

    protected void setItems(NonNullList<ItemStack> list) {
        this.inventory.setInternalList(list);
    }

    public void onScheduledTick() {
        this.stateManager.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registryLookup) {
        super.loadAdditional(tag, registryLookup);
        this.tryLoadLootTable(tag);
        this.inventory.deserializeNBT(registryLookup, tag.getCompound("inventory"));
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registryLookup) {
        super.saveAdditional(tag, registryLookup);
        this.trySaveLootTable(tag);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registryLookup));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder componentMapBuilder) {
        super.collectImplicitComponents(componentMapBuilder);
        componentMapBuilder.set(DataComponents.CONTAINER_LOOT, (Object)new SeededContainerLoot(this.lootTable, this.lootTableSeed));
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public SoundEvent getOpenSound() {
        return SoundEvents.CHEST_OPEN;
    }

    public SoundEvent getCloseSound() {
        return SoundEvents.CHEST_CLOSE;
    }

    @Override
    public IItemHandler exposeItemHandlers(Direction dir) {
        return this.inventory;
    }
}

