/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.chests;

import earth.terrarium.pastel.api.block.PlayerOwnedWithName;
import earth.terrarium.pastel.blocks.chests.PastelChestBlockEntity;
import earth.terrarium.pastel.capabilities.SidedCapabilityProvider;
import earth.terrarium.pastel.inventories.GenericPastelContainerScreenHandler;
import earth.terrarium.pastel.inventories.ScreenBackgroundVariant;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.scores.PlayerTeam;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class HeartboundChestBlockEntity
extends PastelChestBlockEntity
implements WorldlyContainer,
PlayerOwnedWithName,
SidedCapabilityProvider {
    private UUID ownerUUID;
    private String ownerName;
    private long lastNonOwnerOpenedTick = -1L;

    public HeartboundChestBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)PastelBlockEntities.HEARTBOUND_CHEST.get(), blockPos, blockState);
    }

    public static int getPlayersLookingInChestCount(BlockGetter world, BlockPos pos) {
        BlockEntity blockEntity;
        BlockState blockState = world.getBlockState(pos);
        if (blockState.hasBlockEntity() && (blockEntity = world.getBlockEntity(pos)) instanceof HeartboundChestBlockEntity) {
            HeartboundChestBlockEntity heartboundChestBlockEntity = (HeartboundChestBlockEntity)blockEntity;
            return heartboundChestBlockEntity.stateManager.getOpenerCount();
        }
        return 0;
    }

    @Override
    protected void onInvOpenOrClose(Level world, BlockPos pos, BlockState state, int oldViewerCount, int newViewerCount) {
        super.onInvOpenOrClose(world, pos, state, oldViewerCount, newViewerCount);
        if (oldViewerCount != newViewerCount) {
            this.updateRedstone(pos, state);
        }
    }

    public void updateRedstone(BlockPos pos, BlockState state) {
        if (this.level == null) {
            return;
        }
        this.level.updateNeighborsAt(pos, state.getBlock());
        this.level.updateNeighborsAt(pos.below(), state.getBlock());
        if (this.wasRecentlyTriedToOpenByNonOwner()) {
            this.level.scheduleTick(pos, state.getBlock(), 10);
        }
    }

    protected Component getDefaultName() {
        if (this.hasOwner()) {
            return Component.translatable((String)"block.pastel.heartbound_chest.owner", (Object[])new Object[]{this.ownerName});
        }
        return Component.translatable((String)"block.pastel.heartbound_chest");
    }

    protected AbstractContainerMenu createMenu(int syncId, Inventory playerInventory) {
        return GenericPastelContainerScreenHandler.createGeneric9x6(syncId, playerInventory, (Container)this, ScreenBackgroundVariant.EARLYGAME);
    }

    public int getContainerSize() {
        return 54;
    }

    @Override
    public void onScheduledTick() {
        super.onScheduledTick();
        if (this.level != null) {
            this.updateRedstone(this.getBlockPos(), this.level.getBlockState(this.worldPosition));
        }
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registryLookup) {
        super.loadAdditional(tag, registryLookup);
        this.ownerUUID = tag.contains("OwnerUUID") ? tag.getUUID("OwnerUUID") : null;
        this.ownerName = tag.contains("OwnerName") ? tag.getString("OwnerName") : "???";
        this.lastNonOwnerOpenedTick = tag.contains("LastNonOwnerOpenedTick") ? tag.getLong("LastNonOwnerOpenedTick") : -1L;
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registryLookup) {
        super.saveAdditional(tag, registryLookup);
        if (this.ownerUUID != null) {
            tag.putUUID("OwnerUUID", this.ownerUUID);
        }
        if (this.ownerName != null) {
            tag.putString("OwnerName", this.ownerName);
        }
        tag.putLong("LastNonOwnerOpenedTick", this.lastNonOwnerOpenedTick);
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public void setOwner(Player playerEntity) {
        this.ownerUUID = playerEntity.getUUID();
        this.ownerName = playerEntity.getName().getString();
        this.setChanged();
    }

    public boolean canOpen(Player player) {
        boolean isOwner = this.getOwnerUUID().equals(player.getUUID());
        PlayerTeam team = player.getTeam();
        if (!isOwner && team != null) {
            isOwner = team.getPlayers().contains(this.ownerName);
        }
        if (!isOwner && this.getLevel() != null) {
            this.lastNonOwnerOpenedTick = this.getLevel().getGameTime();
            this.updateRedstone(this.worldPosition, this.getLevel().getBlockState(this.worldPosition));
            player.displayClientMessage((Component)Component.translatable((String)"block.pastel.heartbound_chest.owner", (Object[])new Object[]{this.ownerName}), true);
        }
        return isOwner;
    }

    public boolean wasRecentlyTriedToOpenByNonOwner() {
        if (this.getLevel() != null) {
            return this.lastNonOwnerOpenedTick > 0L && this.lastNonOwnerOpenedTick + 20L > this.getLevel().getGameTime();
        }
        return false;
    }

    public int[] getSlotsForFace(Direction side) {
        return new int[0];
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction dir) {
        return false;
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
        return false;
    }

    public boolean canBreak(UUID uuid) {
        if (this.ownerUUID == null) {
            return true;
        }
        return this.ownerUUID.equals(uuid);
    }

    @Override
    public IItemHandler exposeItemHandlers(Direction dir) {
        return null;
    }
}

