/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks.amalgam;

import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.blocks.PlacedItemBlock;
import earth.terrarium.pastel.blocks.PlacedItemBlockEntity;
import earth.terrarium.pastel.blocks.amalgam.IncandescentAmalgamItem;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelEnchantmentTags;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class IncandescentAmalgamBlock
extends PlacedItemBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<IncandescentAmalgamBlock> CODEC = IncandescentAmalgamBlock.simpleCodec(IncandescentAmalgamBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0);

    public IncandescentAmalgamBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    public FluidState getFluidState(@NotNull BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(@NotNull BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        FluidState fluidState = ctx.getLevel().getFluidState(ctx.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(state, world, pos, random);
        if (!((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            int r = random.nextInt(50);
            if (r < 10) {
                double posX = (double)pos.getX() + 0.25 + random.nextDouble() * 0.5;
                double posY = (double)pos.getY() + random.nextDouble() * 0.5;
                double posZ = (double)pos.getZ() + 0.25 + random.nextDouble() * 0.5;
                world.addParticle((ParticleOptions)ParticleTypes.LAVA, posX, posY, posZ, 0.0, 0.0, 0.0);
                if (r == 0) {
                    world.playLocalSound(posX, posY, posZ, SoundEvents.LAVA_POP, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
                }
            }
            if (random.nextInt(100) == 0) {
                world.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
            }
        }
    }

    public boolean dropFromExplosion(Explosion explosion) {
        return false;
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        super.stepOn(world, pos, state, entity);
        if (!((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            IncandescentAmalgamBlock.explode(world, pos);
        }
    }

    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.fallOn(world, state, pos, entity, fallDistance);
        if (!((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            IncandescentAmalgamBlock.explode(world, pos);
        }
    }

    public void onProjectileHit(Level world, BlockState state, BlockHitResult hit, Projectile projectile) {
        super.onProjectileHit(world, state, hit, projectile);
        if (!((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            IncandescentAmalgamBlock.explode(world, hit.getBlockPos());
        }
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        super.neighborChanged(state, world, pos, block, fromPos, notify);
        if (!((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && world.random.nextInt(10) == 0) {
            IncandescentAmalgamBlock.explode(world, pos);
        }
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!(((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() || player.isCreative() || EnchantmentHelper.hasTag((ItemStack)player.getItemInHand(player.getUsedItemHand()), PastelEnchantmentTags.PREVENTS_INCANDESCENT_EXPLOSION))) {
            IncandescentAmalgamBlock.explode(world, pos);
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    protected static void explode(Level world, BlockPos pos) {
        BlockEntity blockEntity;
        if (!world.isClientSide && (blockEntity = world.getBlockEntity(pos)) instanceof PlacedItemBlockEntity) {
            PlacedItemBlockEntity placedItemBlockEntity = (PlacedItemBlockEntity)blockEntity;
            Player owner = placedItemBlockEntity.getOwnerIfOnline();
            ItemStack stack = placedItemBlockEntity.getStack();
            world.removeBlock(pos, false);
            IncandescentAmalgamBlock.explode(world, pos, (Entity)owner, stack);
        }
    }

    public static void explode(Level world, BlockPos pos, Entity owner, ItemStack stack) {
        float power = 8.0f;
        Item item = stack.getItem();
        if (item instanceof IncandescentAmalgamItem) {
            IncandescentAmalgamItem item2 = (IncandescentAmalgamItem)item;
            power = item2.getExplosionPower(stack, false);
        }
        world.explode(owner, PastelDamageTypes.incandescence(world, owner), new ExplosionDamageCalculator(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, power, true, Level.ExplosionInteraction.BLOCK);
    }

    protected void onExplosionHit(BlockState state, Level world, BlockPos pos, Explosion explosion, BiConsumer<ItemStack, BlockPos> stackMerger) {
        IncandescentAmalgamBlock.explode(world, pos);
    }
}

