/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public abstract class SpreadableFloraBlock
extends TallGrassBlock {
    private final int tries;

    public SpreadableFloraBlock(int tries, BlockBehaviour.Properties settings) {
        super(settings);
        this.tries = tries;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        int tries = Mth.nextInt((RandomSource)random, (int)0, (int)this.tries);
        block0: for (int i = 0; i < tries; ++i) {
            BlockPos column = pos.offset(Mth.nextInt((RandomSource)random, (int)-7, (int)7), 1, Mth.nextInt((RandomSource)random, (int)-7, (int)7));
            for (int offset = 0; offset < 4; ++offset) {
                BlockPos plantPos = column.below(offset);
                if (!this.mayPlaceOn(world.getBlockState(plantPos), (BlockGetter)world, plantPos) || !world.isEmptyBlock(plantPos.above())) continue;
                world.setBlockAndUpdate(plantPos.above(), this.defaultBlockState());
                continue block0;
            }
        }
    }
}

