/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks;

import com.google.common.base.Predicates;
import com.mojang.serialization.MapCodec;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrackedEndPortalFrameBlock
extends Block {
    public static final MapCodec<CrackedEndPortalFrameBlock> CODEC = CrackedEndPortalFrameBlock.simpleCodec(CrackedEndPortalFrameBlock::new);
    public static final BooleanProperty FACING_VERTICAL = BooleanProperty.create((String)"facing_vertical");
    public static final EnumProperty<EndPortalFrameEye> EYE_TYPE = EnumProperty.create((String)"eye_type", EndPortalFrameEye.class);
    protected static final VoxelShape FRAME_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    protected static final VoxelShape EYE_SHAPE = Block.box((double)4.0, (double)13.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static final VoxelShape FRAME_WITH_EYE_SHAPE = Shapes.or((VoxelShape)FRAME_SHAPE, (VoxelShape)EYE_SHAPE);
    private static BlockPattern COMPLETED_FRAME;
    private static BlockPattern END_PORTAL;

    public MapCodec<? extends CrackedEndPortalFrameBlock> codec() {
        return CODEC;
    }

    public CrackedEndPortalFrameBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING_VERTICAL, (Comparable)Boolean.valueOf(false))).setValue(EYE_TYPE, (Comparable)((Object)EndPortalFrameEye.NONE)));
    }

    public static void checkAndFillEndPortal(Level world, BlockPos blockPos) {
        BlockPattern.BlockPatternMatch result = CrackedEndPortalFrameBlock.getCompletedFramePattern().find((LevelReader)world, blockPos);
        if (result != null) {
            BlockPos portalTopLeft = result.getFrontTopLeft().offset(-3, 0, -3);
            if (world.getBlockState(portalTopLeft.offset(7, 0, 0)).getBlock().equals(PastelBlocks.CRACKED_END_PORTAL_FRAME.get())) {
                portalTopLeft = portalTopLeft.offset(4, 0, 0);
            } else if (world.getBlockState(portalTopLeft.offset(0, 0, 7)).getBlock().equals(PastelBlocks.CRACKED_END_PORTAL_FRAME.get())) {
                portalTopLeft = portalTopLeft.offset(0, 0, 4);
            }
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    world.setBlock(portalTopLeft.offset(i, 0, j), Blocks.END_PORTAL.defaultBlockState(), 2);
                }
            }
            world.globalLevelEvent(1038, portalTopLeft.offset(1, 0, 1), 0);
        }
    }

    public static void destroyPortals(Level world, BlockPos blockPos) {
        BlockPattern.BlockPatternMatch result = CrackedEndPortalFrameBlock.getActiveEndPortalPattern().find((LevelReader)world, blockPos);
        if (result != null) {
            BlockPos portalTopLeft = result.getFrontTopLeft().offset(-3, 0, -3);
            Block b1 = world.getBlockState(portalTopLeft.offset(7, 0, 0)).getBlock();
            Block b2 = world.getBlockState(portalTopLeft.offset(0, 0, 7)).getBlock();
            if (b1.equals(PastelBlocks.CRACKED_END_PORTAL_FRAME.get()) || b1.equals(Blocks.END_PORTAL_FRAME)) {
                portalTopLeft = portalTopLeft.offset(4, 0, 0);
            } else if (b2.equals(PastelBlocks.CRACKED_END_PORTAL_FRAME.get()) || b2.equals(Blocks.END_PORTAL_FRAME)) {
                portalTopLeft = portalTopLeft.offset(0, 0, 4);
            }
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    world.setBlock(portalTopLeft.offset(i, 0, j), Blocks.AIR.defaultBlockState(), 2);
                }
            }
            world.globalLevelEvent(1038, portalTopLeft.offset(1, 0, 1), 0);
        }
    }

    public static BlockPattern getCompletedFramePattern() {
        if (COMPLETED_FRAME == null) {
            COMPLETED_FRAME = BlockPatternBuilder.start().aisle(new String[]{"?vvv?", ">???<", ">???<", ">???<", "?^^^?"}).where('?', BlockInWorld.hasState((Predicate)BlockStatePredicate.ANY)).where('^', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.END_PORTAL_FRAME).where((Property)EndPortalFrameBlock.HAS_EYE, (Predicate)Predicates.equalTo((Object)true)).where((Property)EndPortalFrameBlock.FACING, (Predicate)Predicates.equalTo((Object)Direction.SOUTH)).or((Predicate)BlockStatePredicate.forBlock((Block)((Block)PastelBlocks.CRACKED_END_PORTAL_FRAME.get())).where(EYE_TYPE, (Predicate)Predicates.equalTo((Object)((Object)EndPortalFrameEye.WITH_EYE_OF_ENDER))).where((Property)FACING_VERTICAL, (Predicate)Predicates.equalTo((Object)false))))).where('>', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.END_PORTAL_FRAME).where((Property)EndPortalFrameBlock.HAS_EYE, (Predicate)Predicates.equalTo((Object)true)).where((Property)EndPortalFrameBlock.FACING, (Predicate)Predicates.equalTo((Object)Direction.WEST)).or((Predicate)BlockStatePredicate.forBlock((Block)((Block)PastelBlocks.CRACKED_END_PORTAL_FRAME.get())).where(EYE_TYPE, (Predicate)Predicates.equalTo((Object)((Object)EndPortalFrameEye.WITH_EYE_OF_ENDER))).where((Property)FACING_VERTICAL, (Predicate)Predicates.equalTo((Object)true))))).where('v', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.END_PORTAL_FRAME).where((Property)EndPortalFrameBlock.HAS_EYE, (Predicate)Predicates.equalTo((Object)true)).where((Property)EndPortalFrameBlock.FACING, (Predicate)Predicates.equalTo((Object)Direction.NORTH)).or((Predicate)BlockStatePredicate.forBlock((Block)((Block)PastelBlocks.CRACKED_END_PORTAL_FRAME.get())).where(EYE_TYPE, (Predicate)Predicates.equalTo((Object)((Object)EndPortalFrameEye.WITH_EYE_OF_ENDER))).where((Property)FACING_VERTICAL, (Predicate)Predicates.equalTo((Object)false))))).where('<', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.END_PORTAL_FRAME).where((Property)EndPortalFrameBlock.HAS_EYE, (Predicate)Predicates.equalTo((Object)true)).where((Property)EndPortalFrameBlock.FACING, (Predicate)Predicates.equalTo((Object)Direction.EAST)).or((Predicate)BlockStatePredicate.forBlock((Block)((Block)PastelBlocks.CRACKED_END_PORTAL_FRAME.get())).where(EYE_TYPE, (Predicate)Predicates.equalTo((Object)((Object)EndPortalFrameEye.WITH_EYE_OF_ENDER))).where((Property)FACING_VERTICAL, (Predicate)Predicates.equalTo((Object)true))))).build();
        }
        return COMPLETED_FRAME;
    }

    public static BlockPattern getActiveEndPortalPattern() {
        if (END_PORTAL == null) {
            END_PORTAL = BlockPatternBuilder.start().aisle(new String[]{"?vvv?", ">ppp<", ">ppp<", ">ppp<", "?^^^?"}).where('?', BlockInWorld.hasState((Predicate)BlockStatePredicate.ANY)).where('^', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.END_PORTAL_FRAME).or((Predicate)BlockStatePredicate.forBlock((Block)((Block)PastelBlocks.CRACKED_END_PORTAL_FRAME.get()))))).where('>', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.END_PORTAL_FRAME).or((Predicate)BlockStatePredicate.forBlock((Block)((Block)PastelBlocks.CRACKED_END_PORTAL_FRAME.get()))))).where('v', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.END_PORTAL_FRAME).or((Predicate)BlockStatePredicate.forBlock((Block)((Block)PastelBlocks.CRACKED_END_PORTAL_FRAME.get()))))).where('<', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.END_PORTAL_FRAME).or((Predicate)BlockStatePredicate.forBlock((Block)((Block)PastelBlocks.CRACKED_END_PORTAL_FRAME.get()))))).where('p', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.END_PORTAL))).build();
        }
        return END_PORTAL;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return ((EndPortalFrameEye)((Object)state.getValue(EYE_TYPE))).hasEye() ? FRAME_WITH_EYE_SHAPE : FRAME_SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction facing = ctx.getHorizontalDirection();
        boolean facingVertical = facing.equals((Object)Direction.EAST) || facing.equals((Object)Direction.WEST);
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING_VERTICAL, (Comparable)Boolean.valueOf(facingVertical))).setValue(EYE_TYPE, (Comparable)((Object)EndPortalFrameEye.NONE));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING_VERTICAL, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)FACING_VERTICAL) == false));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING_VERTICAL, EYE_TYPE});
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return ((EndPortalFrameEye)((Object)state.getValue(EYE_TYPE))).getRedstonePower();
    }

    @Deprecated
    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (((EndPortalFrameEye)((Object)state.getValue(EYE_TYPE))).hasExplosions()) {
            world.scheduleTick(pos, (Block)this, 40);
        }
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (((EndPortalFrameEye)((Object)state.getValue(EYE_TYPE))).hasExplosions()) {
            double d = (double)pos.getX() + random.nextDouble();
            double e = (double)pos.getY() + 1.05;
            double f = (double)pos.getZ() + random.nextDouble();
            world.addParticle((ParticleOptions)ParticleTypes.SMOKE, d, e, f, 0.0, 0.0, 0.0);
        }
    }

    @Deprecated
    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (((EndPortalFrameEye)((Object)state.getValue(EYE_TYPE))).hasExplosions()) {
            float randomFloat = random.nextFloat();
            if ((double)randomFloat < 0.05) {
                world.explode(null, null, new ExplosionDamageCalculator(this){

                    public boolean shouldDamageEntity(Explosion explosion, Entity entity) {
                        return false;
                    }
                }, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 4.0f, false, Level.ExplosionInteraction.BLOCK);
                CrackedEndPortalFrameBlock.destroyPortals((Level)world, pos);
                world.destroyBlock(pos, true);
            } else if ((double)randomFloat < 0.2) {
                world.explode(null, null, new ExplosionDamageCalculator(this){

                    public boolean shouldDamageEntity(Explosion explosion, Entity entity) {
                        return false;
                    }
                }, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 3.0f, false, Level.ExplosionInteraction.BLOCK);
            } else {
                double d = (double)pos.getX() + random.nextDouble();
                double e = (double)pos.getY() + 0.8;
                double f = (double)pos.getZ() + random.nextDouble();
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, d, e, f, 0.0, 0.0, 0.0);
            }
        }
        world.scheduleTick(pos, (Block)this, 10);
    }

    public static enum EndPortalFrameEye implements StringRepresentable
    {
        VANILLA_WITH_PERTURBED_EYE("vanilla_cracker", true, true, 8),
        NONE("none", false, false, 0),
        WITH_EYE_OF_ENDER("ender", true, false, 15),
        WITH_PERTURBED_EYE("cracker", true, true, 8);

        private final String name;
        private final boolean hasEye;
        private final boolean hasExplosions;
        private final int redstonePower;

        private EndPortalFrameEye(String name, boolean hasEye, boolean hasExplosions, int redstonePower) {
            this.name = name;
            this.hasEye = hasEye;
            this.redstonePower = redstonePower;
            this.hasExplosions = hasExplosions;
        }

        public String toString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public boolean hasEye() {
            return this.hasEye;
        }

        public boolean hasExplosions() {
            return this.hasExplosions;
        }

        public int getRedstonePower() {
            return this.redstonePower;
        }
    }
}

