/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks;

import earth.terrarium.pastel.capabilities.item.FriendlyStackHandler;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface Containerlike
extends WorldlyContainer {
    default public int[] getSlotsForFace(Direction side) {
        return new int[]{0};
    }

    default public boolean canPlaceItemThroughFace(int index, ItemStack itemStack, @Nullable Direction direction) {
        return direction != Direction.DOWN;
    }

    default public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return direction == Direction.DOWN;
    }

    default public int getContainerSize() {
        return this.getInventory().getSlots();
    }

    default public boolean isEmpty() {
        return this.getInventory().isEmpty();
    }

    default public ItemStack getItem(int slot) {
        return this.getInventory().getStackInSlot(slot);
    }

    default public ItemStack removeItem(int slot, int amount) {
        return this.getInventory().extractItem(slot, amount, false);
    }

    default public ItemStack removeItemNoUpdate(int slot) {
        NonNullList<ItemStack> internal = this.getInventory().getInternalList();
        return (ItemStack)internal.set(slot, (Object)ItemStack.EMPTY);
    }

    default public void setItem(int slot, ItemStack stack) {
        this.getInventory().setStackInSlot(slot, stack);
    }

    default public void containerChanged() {
    }

    default public void setChanged() {
        this.containerChanged();
    }

    default public boolean stillValid(Player player) {
        return true;
    }

    default public void clearContent() {
        throw new UnsupportedOperationException("No.");
    }

    public FriendlyStackHandler getInventory();
}

