/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.blocks;

import earth.terrarium.pastel.capabilities.item.FriendlyStackHandler;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BaseInventoryBlockEntity
extends BlockEntity
implements WorldlyContainer,
MenuProvider,
Nameable {
    @Nullable
    private Component name;

    public BaseInventoryBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public Component getName() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    public Component getDisplayName() {
        return this.getName();
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    protected abstract Component getDefaultName();

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("CustomName", 8)) {
            this.name = BaseInventoryBlockEntity.parseCustomNameSafe((String)tag.getString("CustomName"), (HolderLookup.Provider)registries);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.name != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)registries));
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return this.createMenu(containerId, playerInventory);
    }

    protected abstract AbstractContainerMenu createMenu(int var1, Inventory var2);

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.name = (Component)componentInput.get(DataComponents.CUSTOM_NAME);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.CUSTOM_NAME, (Object)this.name);
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("CustomName");
        tag.remove("Items");
    }

    public int getContainerSize() {
        return this.getHandler().getSlots();
    }

    protected abstract FriendlyStackHandler getHandler();

    protected void notifyInventoryUpdate() {
    }

    public boolean isEmpty() {
        return this.getHandler().isEmpty();
    }

    public ItemStack getItem(int slot) {
        return this.getHandler().getStackInSlot(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        this.setChanged();
        this.notifyInventoryUpdate();
        return this.getHandler().extractItem(slot, amount, false);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        this.setChanged();
        this.notifyInventoryUpdate();
        return this.getHandler().removeStackInSlot(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.setChanged();
        this.notifyInventoryUpdate();
        this.getHandler().setStackInSlot(slot, stack);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        this.setChanged();
        this.notifyInventoryUpdate();
        this.getHandler().clear();
    }
}

