/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.attachments.data;

import com.cmdpro.databank.misc.ColorGradient;
import com.cmdpro.databank.misc.TrailRender;
import com.cmdpro.databank.rendering.RenderHandler;
import com.cmdpro.databank.rendering.RenderTypeHandler;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.entity.PlayerEntityAccessor;
import earth.terrarium.pastel.api.item.HasColorGradient;
import earth.terrarium.pastel.api.item.SleepAlteringItem;
import earth.terrarium.pastel.attachments.data.AttachmentUtil;
import earth.terrarium.pastel.networking.s2c_payloads.SyncMentalPresencePayload;
import earth.terrarium.pastel.registries.PastelEntityAttributes;
import java.awt.Color;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class MiscPlayerData {
    public static final Codec<MiscPlayerData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("ticksBeforeSleep").forGetter(m -> m.ticksBeforeSleep), (App)Codec.INT.fieldOf("sleepingWindow").forGetter(m -> m.sleepingWindow), (App)Codec.INT.fieldOf("sleepInvincibility").forGetter(m -> m.sleepInvincibility), (App)BuiltInRegistries.ITEM.byNameCodec().optionalFieldOf("sleepConsumable").forGetter(m -> m.sleepConsumable)).apply((Applicative)i, MiscPlayerData::ofCodec));
    public static final AttachmentType<MiscPlayerData> ATTACHMENT = AttachmentType.builder(holder -> new MiscPlayerData((Player)holder)).serialize(CODEC).build();
    private Player player;
    private int ticksBeforeSleep = -1;
    private int sleepingWindow = -1;
    private int sleepInvincibility;
    private double lastSyncedSleepPotency = -2.0;
    private Optional<SleepAlteringItem> sleepConsumable = Optional.empty();
    private boolean isLunging;
    private boolean wasLunging;
    private boolean bHopWindow;
    private boolean perfectCounter;
    private Item lungeItem;
    private int parryTicks;
    private TrailRender lungeTrail;

    public MiscPlayerData(@NotNull Player player) {
        this.player = player;
    }

    private MiscPlayerData() {
    }

    public static MiscPlayerData ofCodec(int ticksBeforeSleep, int sleepingWindow, int sleepInvincibility, Optional<Item> sleepConsumable) {
        MiscPlayerData data = new MiscPlayerData();
        data.ticksBeforeSleep = ticksBeforeSleep;
        data.sleepingWindow = sleepingWindow;
        data.sleepInvincibility = sleepInvincibility;
        data.sleepConsumable = sleepConsumable;
        return data;
    }

    public ColorGradient getLungeGradient() {
        return new ColorGradient(new Color(181, 255, 254), new Color(149, 182, 255)).fadeAlpha(1.0f, 0.0f);
    }

    public TrailRender getLungeTrail() {
        if (this.lungeTrail == null) {
            this.lungeTrail = new TrailRender(this.player.getBoundingBox().getCenter(), 20, 20, 0.25f, PastelCommon.locate("textures/misc/trail/trail.png"), RenderTypeHandler::transparent).setShrink(true);
        }
        return this.lungeTrail;
    }

    public void tick() {
        double fortitude;
        this.tickSleep();
        this.tickSwordMechanics();
        if (!this.player.level().isClientSide() && this.lastSyncedSleepPotency != (fortitude = this.player.getAttributeValue(PastelEntityAttributes.MENTAL_PRESENCE))) {
            this.lastSyncedSleepPotency = fortitude;
            SyncMentalPresencePayload.sendMentalPresenceSync((ServerPlayer)this.player, fortitude);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderAdditional(RenderLevelStageEvent event) {
        PoseStack poseStack = event.getPoseStack();
        float partialTick = event.getPartialTick().getGameTimeDeltaPartialTick(true);
        ColorGradient lungeGradient = null;
        Item item = this.lungeItem;
        if (item instanceof HasColorGradient) {
            HasColorGradient hasColorGradient = (HasColorGradient)item;
            lungeGradient = hasColorGradient.getColorGradient(HasColorGradient.LUNGE);
        }
        if (lungeGradient != null) {
            TrailRender lungeTrail = this.getLungeTrail();
            poseStack.pushPose();
            poseStack.translate(-event.getCamera().getPosition().x, -event.getCamera().getPosition().y, -event.getCamera().getPosition().z);
            double d0 = Mth.lerp((double)partialTick, (double)this.player.xOld, (double)this.player.getX());
            double d1 = Mth.lerp((double)partialTick, (double)this.player.yOld, (double)this.player.getY());
            double d2 = Mth.lerp((double)partialTick, (double)this.player.zOld, (double)this.player.getZ());
            if (this.isLunging) {
                lungeTrail.position = new Vec3(d0, d1 + this.player.getBoundingBox().getYsize() / 2.0, d2);
            }
            lungeTrail.render(poseStack, (MultiBufferSource)RenderHandler.createBufferSource(), 0xF000F0, lungeGradient);
            poseStack.popPose();
        }
    }

    private boolean isInModifiedMotionState() {
        return this.player.onGround() || this.player.isSwimming() || this.player.isFallFlying() || this.player.getAbilities().flying;
    }

    public void initiateLungeState(Item item) {
        this.isLunging = true;
        this.bHopWindow = true;
        this.lungeItem = item;
    }

    public void endLunge() {
        this.isLunging = false;
        this.bHopWindow = false;
    }

    public boolean isLunging() {
        return this.isLunging;
    }

    public void setParryTicks(int ticks) {
        this.parryTicks = ticks;
    }

    public void markForPerfectCounter() {
        this.perfectCounter = true;
    }

    public boolean consumePerfectCounter() {
        if (this.perfectCounter) {
            this.perfectCounter = false;
            return true;
        }
        return false;
    }

    public boolean isParrying() {
        return this.parryTicks > 0;
    }

    private void tickSwordMechanics() {
        TrailRender lungeTrail;
        if (this.parryTicks > 1) {
            --this.parryTicks;
        } else if (this.parryTicks == 1) {
            this.parryTicks = 0;
            this.consumePerfectCounter();
        }
        if (!this.bHopWindow && this.isLunging) {
            if (this.isInModifiedMotionState()) {
                this.isLunging = false;
            } else {
                this.bHopWindow = true;
            }
        } else if (this.isLunging && this.isInModifiedMotionState()) {
            this.bHopWindow = false;
        }
        if (!this.wasLunging && this.isLunging && this.player.level().isClientSide && (lungeTrail = this.getLungeTrail()) != null) {
            lungeTrail.reset();
            lungeTrail.position = this.player.getBoundingBox().getCenter();
        }
        this.wasLunging = this.isLunging;
        if (this.player.level().isClientSide) {
            this.getLungeTrail().tick();
        }
    }

    public float getFrictionModifiers() {
        return this.isLunging ? 0.04f : 0.0f;
    }

    private void tickSleep() {
        if (this.ticksBeforeSleep > 0) {
            --this.ticksBeforeSleep;
            if (this.ticksBeforeSleep == 0) {
                this.player.startSleeping(this.player.blockPosition());
                ((PlayerEntityAccessor)this.player).setSleepTimer(0);
                Level world = this.player.level();
                if (!world.isClientSide()) {
                    ((ServerLevel)world).updateSleepingPlayerList();
                    this.sync();
                }
            }
        }
        if (this.sleepInvincibility > 0) {
            --this.sleepInvincibility;
        }
        if (this.ticksBeforeSleep != 0) {
            return;
        }
        if (this.sleepingWindow > 0) {
            --this.sleepingWindow;
            if (this.sleepingWindow == 0) {
                this.failSleep();
            }
        }
    }

    private void failSleep() {
        if (!this.player.level().isClientSide()) {
            this.player.stopSleeping();
            this.resetSleepingState(true);
        }
    }

    public boolean isSleeping() {
        return this.ticksBeforeSleep == 0 && this.sleepingWindow > 0;
    }

    public boolean shouldLieDown() {
        return this.ticksBeforeSleep > 0;
    }

    public void notifyHit() {
        if (this.sleepInvincibility <= 0) {
            this.resetSleepingState(true);
        }
    }

    public void resetSleepingState(boolean canApplyPenalties) {
        if (this.ticksBeforeSleep == -1) {
            return;
        }
        this.ticksBeforeSleep = -1;
        this.sleepingWindow = -1;
        this.sleepInvincibility = -1;
        if (canApplyPenalties) {
            this.sleepConsumable.ifPresent(p -> p.applyPenalties(this.player));
        }
        this.sleepConsumable = Optional.empty();
        this.sync();
    }

    public void setSleepTimers(int wait, int window, int invulnTicks) {
        this.ticksBeforeSleep = wait;
        this.sleepingWindow = window;
        this.sleepInvincibility = invulnTicks;
        this.sync();
    }

    public void setLastSleepItem(@NotNull SleepAlteringItem item) {
        this.sleepConsumable = Optional.of(item);
    }

    public void sync() {
        AttachmentUtil.syncToTracking(new Payload(this.player.getUUID(), this.ticksBeforeSleep, this.sleepingWindow, this.sleepInvincibility, this.sleepConsumable, new LungeData(this.isLunging, Optional.ofNullable(this.lungeItem))), this.player.level(), this.player.blockPosition());
    }

    public static MiscPlayerData get(@NotNull Player player) {
        MiscPlayerData data = (MiscPlayerData)player.getData(ATTACHMENT);
        if (data.player == null) {
            data.player = player;
        }
        return data;
    }

    public void setLastSyncedSleepPotency(double lastSyncedSleepPotency) {
        this.lastSyncedSleepPotency = lastSyncedSleepPotency;
    }

    public double getLastSyncedSleepPotency() {
        return this.lastSyncedSleepPotency;
    }

    public record Payload(UUID id, int ticksBeforeSleep, int sleepingWindow, int sleepInvincibility, Optional<Item> sleepConsumable, LungeData lungeData) implements CustomPacketPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, Payload> CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, Payload::id, (StreamCodec)ByteBufCodecs.INT, Payload::ticksBeforeSleep, (StreamCodec)ByteBufCodecs.INT, Payload::sleepingWindow, (StreamCodec)ByteBufCodecs.INT, Payload::sleepInvincibility, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM)), Payload::sleepConsumable, LungeData.CODEC, Payload::lungeData, Payload::new);
        public static final CustomPacketPayload.Type<Payload> TYPE = AttachmentUtil.create("player_misc");

        public static void execute(Payload payload, IPayloadContext context) {
            Player player = context.player().level().getPlayerByUUID(payload.id);
            if (player == null) {
                return;
            }
            MiscPlayerData data = (MiscPlayerData)player.getData(ATTACHMENT);
            data.ticksBeforeSleep = payload.ticksBeforeSleep();
            data.sleepingWindow = payload.sleepingWindow();
            data.sleepInvincibility = payload.sleepInvincibility();
            data.sleepConsumable = payload.sleepConsumable;
            data.isLunging = payload.lungeData.isLunging;
            data.lungeItem = payload.lungeData.lungeItem.orElse(null);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record LungeData(boolean isLunging, Optional<Item> lungeItem) {
        public static final StreamCodec<RegistryFriendlyByteBuf, LungeData> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, LungeData::isLunging, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM)), LungeData::lungeItem, LungeData::new);
    }
}

