/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.attachments.data;

import com.mojang.serialization.Codec;
import earth.terrarium.pastel.attachments.data.AttachmentUtil;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class LastKillData {
    public static final AttachmentType<Long> ATTACHMENT = AttachmentType.builder(() -> 0L).serialize((Codec)Codec.LONG).build();

    public static void rememberKillTick(LivingEntity livingEntity, long tick) {
        if (tick == (Long)livingEntity.getData(ATTACHMENT)) {
            return;
        }
        livingEntity.setData(ATTACHMENT, (Object)tick);
        AttachmentUtil.syncToTracking(new Payload(livingEntity.getId(), tick), livingEntity.level(), livingEntity.blockPosition());
    }

    public static long getLastKillTick(LivingEntity livingEntity) {
        return (Long)livingEntity.getData(ATTACHMENT);
    }

    public record Payload(int entityId, long killTime) implements CustomPacketPayload
    {
        public static final StreamCodec<FriendlyByteBuf, Payload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, Payload::entityId, (StreamCodec)ByteBufCodecs.VAR_LONG, Payload::killTime, Payload::new);
        public static final CustomPacketPayload.Type<Payload> TYPE = AttachmentUtil.create("last_kill");

        public static void execute(Payload payload, IPayloadContext context) {
            Level level = context.player().level();
            Optional.ofNullable(level.getEntity(payload.entityId)).ifPresent(e -> e.setData(ATTACHMENT, (Object)payload.killTime));
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

