/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.attachments;

import com.mojang.authlib.GameProfile;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.attachments.data.AttachmentUtil;
import earth.terrarium.pastel.registries.PastelMobEffects;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class HardcoreDeathTracker
extends SavedData {
    private final List<UUID> playersThatDiedInHardcore = new ArrayList<UUID>();
    private static final SavedData.Factory<HardcoreDeathTracker> FACTORY = new SavedData.Factory(HardcoreDeathTracker::new, HardcoreDeathTracker::load);
    private static HardcoreDeathTracker CLIENT_TRACKER;

    public static boolean isInHardcore(Player player) {
        return player.hasEffect(PastelMobEffects.DIVINITY);
    }

    private static void sync(ServerPlayer player) {
        AttachmentUtil.syncToPlayer(new SyncPayload(HardcoreDeathTracker.getInstance().save(new CompoundTag(), (HolderLookup.Provider)player.registryAccess())), (Player)player);
    }

    public static void addHardcoreDeath(ServerLevel world, ServerPlayer player) {
        HardcoreDeathTracker.addHardcoreDeath(world, player.getGameProfile().getId());
        HardcoreDeathTracker.sync(player);
    }

    public static void removeHardcoreDeath(GameProfile profile) {
        MinecraftServer server = PastelCommon.getSidedServer();
        if (server == null) {
            return;
        }
        HardcoreDeathTracker.removeHardcoreDeath(profile.getId());
        HardcoreDeathTracker.sync(server.getPlayerList().getPlayer(profile.getId()));
    }

    public static boolean hasHardcoreDeath(GameProfile profile) {
        return HardcoreDeathTracker.hasHardcoreDeath(profile.getId());
    }

    protected static void addHardcoreDeath(ServerLevel world, UUID uuid) {
        HardcoreDeathTracker data = HardcoreDeathTracker.getInstance();
        if (!data.playersThatDiedInHardcore.contains(uuid)) {
            data.playersThatDiedInHardcore.add(uuid);
        }
        world.getServer().getPlayerList().getPlayer(uuid).setGameMode(GameType.SPECTATOR);
        data.setDirty();
    }

    protected static boolean hasHardcoreDeath(UUID uuid) {
        return HardcoreDeathTracker.getInstance().playersThatDiedInHardcore.contains(uuid);
    }

    protected static void removeHardcoreDeath(UUID uuid) {
        HardcoreDeathTracker data = HardcoreDeathTracker.getInstance();
        data.playersThatDiedInHardcore.remove(uuid);
        data.setDirty();
    }

    @NotNull
    public static HardcoreDeathTracker getInstance() {
        if (FMLEnvironment.dist.isClient()) {
            if (CLIENT_TRACKER == null) {
                CLIENT_TRACKER = new HardcoreDeathTracker();
            }
            return CLIENT_TRACKER;
        }
        return (HardcoreDeathTracker)PastelCommon.getSidedServer().overworld().getDataStorage().computeIfAbsent(FACTORY, "pastel:hardcore_tracker");
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        ListTag uuidList = new ListTag();
        for (UUID playerThatDiedInHardcore : this.playersThatDiedInHardcore) {
            uuidList.add((Object)NbtUtils.createUUID((UUID)playerThatDiedInHardcore));
        }
        tag.put("HardcoreDeaths", (Tag)uuidList);
        if (!FMLEnvironment.dist.isClient()) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncPayload(tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return tag;
    }

    public static HardcoreDeathTracker load(CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider wrapperLookup) {
        HardcoreDeathTracker data = new HardcoreDeathTracker();
        ListTag uuidList = tag.getList("HardcoreDeaths", 11);
        for (Tag listEntry : uuidList) {
            data.playersThatDiedInHardcore.add(NbtUtils.loadUUID((Tag)listEntry));
        }
        if (!FMLEnvironment.dist.isClient()) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncPayload(tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return data;
    }

    public record SyncPayload(CompoundTag tag) implements CustomPacketPayload
    {
        public static final StreamCodec<FriendlyByteBuf, SyncPayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, SyncPayload::tag, SyncPayload::new);
        public static final CustomPacketPayload.Type<SyncPayload> TYPE = AttachmentUtil.create("hardcore_death_tracker");

        public static void execute(SyncPayload payload, IPayloadContext context) {
            assert (PastelCommon.getRegistryAccess() != null);
            CLIENT_TRACKER = HardcoreDeathTracker.load(payload.tag, (HolderLookup.Provider)PastelCommon.getRegistryAccess());
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

