/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.pastel;

import earth.terrarium.pastel.api.pastel.PastelUpgradeSignature;
import java.util.List;

public interface PastelUpgradeable {
    default public void apply(PastelUpgradeSignature upgrade, List<PastelUpgradeSignature> previousUpgrades) {
        if (upgrade.light) {
            this.markLit();
        }
        if (upgrade.triggerTransfer) {
            this.markTriggerTransfer();
        }
        if (upgrade.lamp) {
            this.markLamp();
        }
        if (upgrade.sensor) {
            this.markSensor();
        }
        if (upgrade.category.isRedstone()) {
            return;
        }
        if (previousUpgrades.stream().anyMatch(u -> u.category.compoundsWith(upgrade.category))) {
            this.applyCompounding(upgrade);
        } else {
            this.applySimple(upgrade);
        }
        this.applySlotUpgrade(upgrade);
        if (upgrade.priority) {
            this.upgradePriority();
        }
    }

    public void applyCompounding(PastelUpgradeSignature var1);

    public void applySimple(PastelUpgradeSignature var1);

    public void applySlotUpgrade(PastelUpgradeSignature var1);

    public void upgradePriority();

    public void markLit();

    public void markLamp();

    public void markTriggerTransfer();

    public void markTriggered();

    public void markSensor();

    public boolean isTriggerTransfer();

    public boolean isSensor();

    public void notifySensor();
}

