/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.interaction.projectile_behavior;

import earth.terrarium.pastel.api.interaction.projectile_behavior.ItemProjectileBehavior;
import earth.terrarium.pastel.entity.entity.ItemProjectileEntity;
import earth.terrarium.pastel.registries.PastelSounds;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public interface DamagingProjectileBehavior
extends ItemProjectileBehavior {
    @Override
    default public ItemStack onEntityHit(ItemProjectileEntity projectile, ItemStack stack, Entity owner, EntityHitResult hitResult) {
        Entity target = hitResult.getEntity();
        if (owner instanceof LivingEntity) {
            LivingEntity livingOwner = (LivingEntity)owner;
            livingOwner.setLastHurtMob(target);
        }
        if (this.dealDamage(projectile, owner, target)) {
            int targetFireTicks = target.getRemainingFireTicks();
            if (projectile.isOnFire()) {
                target.setRemainingFireTicks(targetFireTicks);
            }
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                Level level = owner.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)level;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverWorld, (Entity)target, (DamageSource)livingTarget.getLastDamageSource(), (ItemStack)stack);
                }
                if (target != owner && target instanceof Player && owner instanceof ServerPlayer) {
                    ServerPlayer serverPlayerOwner = (ServerPlayer)owner;
                    if (!projectile.isSilent()) {
                        serverPlayerOwner.connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                    }
                }
                projectile.playSound(PastelSounds.BLOCK_CITRINE_CLUSTER_HIT, 1.0f, 1.2f / (projectile.level().getRandom().nextFloat() * 0.2f + 0.9f));
            }
        }
        if (this.destroyItemOnHit()) {
            stack.shrink(1);
        }
        return stack;
    }

    public boolean destroyItemOnHit();

    public boolean dealDamage(ThrowableItemProjectile var1, Entity var2, Entity var3);

    @Override
    default public ItemStack onBlockHit(ItemProjectileEntity projectile, ItemStack stack, Entity owner, BlockHitResult hitResult) {
        if (this.destroyItemOnHit()) {
            stack.shrink(1);
        }
        return stack;
    }
}

