/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.interaction;

import earth.terrarium.pastel.entity.entity.ItemProjectileEntity;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface OmniAcceleratorProjectile {
    public static final List<Tuple<ItemPredicate, OmniAcceleratorProjectile>> PROJECTILES = new ArrayList<Tuple<ItemPredicate, OmniAcceleratorProjectile>>();
    public static final OmniAcceleratorProjectile DEFAULT = (stack, shooter, world, shotFrom) -> {
        ItemProjectileEntity itemProjectileEntity = new ItemProjectileEntity(world, shooter);
        itemProjectileEntity.setItem(stack);
        itemProjectileEntity.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, 2.5f, 0.5f);
        world.addFreshEntity((Entity)itemProjectileEntity);
        return itemProjectileEntity;
    };

    public static void register(OmniAcceleratorProjectile behavior, ItemPredicate predicate) {
        PROJECTILES.add((Tuple<ItemPredicate, OmniAcceleratorProjectile>)new Tuple((Object)predicate, (Object)behavior));
    }

    public static void register(OmniAcceleratorProjectile behavior, ItemLike ... items) {
        PROJECTILES.add((Tuple<ItemPredicate, OmniAcceleratorProjectile>)new Tuple((Object)ItemPredicate.Builder.item().of(items).build(), (Object)behavior));
    }

    public static void register(OmniAcceleratorProjectile behavior, TagKey<Item> tag) {
        PROJECTILES.add((Tuple<ItemPredicate, OmniAcceleratorProjectile>)new Tuple((Object)ItemPredicate.Builder.item().of(tag).build(), (Object)behavior));
    }

    public static OmniAcceleratorProjectile get(ItemStack stack) {
        for (Tuple<ItemPredicate, OmniAcceleratorProjectile> entry : PROJECTILES) {
            if (!((ItemPredicate)entry.getA()).test(stack)) continue;
            return (OmniAcceleratorProjectile)entry.getB();
        }
        return DEFAULT;
    }

    @Nullable
    public Entity createProjectile(ItemStack var1, LivingEntity var2, Level var3, ItemStack var4);

    default public SoundEvent getSoundEffect() {
        return PastelSounds.OMNI_ACCELERATOR_SHOOT;
    }

    public static void setVelocity(Entity projectile, double x, double y, double z, float speed, float divergence) {
        Vec3 vec3d = new Vec3(x, y, z).normalize().add(projectile.level().getRandom().triangle(0.0, 0.0172275 * (double)divergence), projectile.level().getRandom().triangle(0.0, 0.0172275 * (double)divergence), projectile.level().getRandom().triangle(0.0, 0.0172275 * (double)divergence)).scale((double)speed);
        projectile.setDeltaMovement(vec3d);
        double d = vec3d.horizontalDistance();
        projectile.setYRot((float)(Mth.atan2((double)vec3d.x, (double)vec3d.z) * 57.2957763671875));
        projectile.setXRot((float)(Mth.atan2((double)vec3d.y, (double)d) * 57.2957763671875));
        projectile.yRotO = projectile.getYRot();
        projectile.xRotO = projectile.getXRot();
    }

    public static void setVelocity(Entity projectile, Entity shooter, float pitch, float yaw, float roll, float speed, float divergence) {
        float f = -Mth.sin((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
        float g = -Mth.sin((float)((pitch + roll) * ((float)Math.PI / 180)));
        float h = Mth.cos((float)(yaw * ((float)Math.PI / 180))) * Mth.cos((float)(pitch * ((float)Math.PI / 180)));
        OmniAcceleratorProjectile.setVelocity(projectile, f, g, h, speed, divergence);
        Vec3 vec3d = shooter.getDeltaMovement();
        projectile.setDeltaMovement(projectile.getDeltaMovement().add(vec3d.x, shooter.onGround() ? 0.0 : vec3d.y, vec3d.z));
    }
}

