/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.entity;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import org.jetbrains.annotations.Nullable;

public interface PackEntity<T extends Mob> {
    public boolean hasOthersInGroup();

    @Nullable
    public T getLeader();

    public boolean isCloseEnoughToLeader();

    public void leaveGroup();

    public void moveTowardLeader();

    public int getMaxGroupSize();

    public int getGroupSize();

    public void joinGroupOf(T var1);

    default public boolean hasLeader() {
        T leader = this.getLeader();
        return leader != null && leader.isAlive();
    }

    default public boolean isDifferentPack(PackEntity<T> other) {
        T thisLeader = this.getLeader();
        if (thisLeader == null) {
            return false;
        }
        T otherLeader = other.getLeader();
        if (otherLeader == null) {
            return false;
        }
        return !Objects.equals(this.getLeader(), other.getLeader());
    }

    default public boolean canHaveMoreInGroup() {
        return this.hasOthersInGroup() && this.getGroupSize() < this.getMaxGroupSize();
    }

    public static class FollowClanLeaderGoal<E extends Mob>
    extends Goal {
        private static final int MIN_SEARCH_DELAY = 200;
        private final E entity;
        private int moveDelay;
        private int checkSurroundingDelay;

        public FollowClanLeaderGoal(E entity) {
            this.entity = entity;
            this.checkSurroundingDelay = this.getSurroundingSearchDelay(entity);
        }

        protected int getSurroundingSearchDelay(E fish) {
            return FollowClanLeaderGoal.reducedTickDelay((int)(200 + fish.getRandom().nextInt(200) % 20));
        }

        public boolean canUse() {
            if (((PackEntity)this.entity).hasOthersInGroup()) {
                return false;
            }
            if (((PackEntity)this.entity).hasLeader()) {
                return true;
            }
            if (this.checkSurroundingDelay > 0) {
                --this.checkSurroundingDelay;
                return false;
            }
            this.checkSurroundingDelay = this.getSurroundingSearchDelay(this.entity);
            this.createNewPack();
            return ((PackEntity)this.entity).hasLeader();
        }

        private void createNewPack() {
            List possiblePackmates = this.entity.level().getEntitiesOfClass(this.entity.getClass(), this.entity.getBoundingBox().inflate(8.0, 8.0, 8.0), livingEntity -> {
                PackEntity packEntity;
                return livingEntity instanceof PackEntity && ((packEntity = (PackEntity)livingEntity).canHaveMoreInGroup() || !packEntity.hasLeader());
            });
            Optional<Mob> newLeader = possiblePackmates.stream().filter(rec$ -> ((PackEntity)rec$).canHaveMoreInGroup()).findAny();
            if (newLeader.isEmpty()) {
                newLeader = possiblePackmates.stream().filter(e -> !((PackEntity)e).hasLeader()).findAny();
            }
            if (newLeader.isPresent()) {
                Mob leader = newLeader.get();
                possiblePackmates.stream().filter(e -> e != leader).filter(e -> !((PackEntity)e).hasLeader()).limit(((PackEntity)leader).getMaxGroupSize() - ((PackEntity)leader).getGroupSize()).forEach(e -> ((PackEntity)e).joinGroupOf(leader));
            }
        }

        public boolean canContinueToUse() {
            return ((PackEntity)this.entity).hasLeader() && ((PackEntity)this.entity).isCloseEnoughToLeader();
        }

        public void start() {
            this.moveDelay = 0;
        }

        public void stop() {
            ((PackEntity)this.entity).leaveGroup();
        }

        public void tick() {
            if (--this.moveDelay <= 0) {
                this.moveDelay = this.adjustedTickDelay(10);
                ((PackEntity)this.entity).moveTowardLeader();
            }
        }
    }
}

