/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.energy.storage;

import earth.terrarium.pastel.api.energy.InkStorage;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.registries.PastelRegistries;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TotalCappedInkStorage
implements InkStorage {
    protected final long maxEnergyTotal;
    protected final Map<InkColor, Long> storedEnergy = new Object2LongArrayMap();
    protected long currentTotal;

    public TotalCappedInkStorage(long maxEnergyTotal, Map<InkColor, Long> energy) {
        this.maxEnergyTotal = maxEnergyTotal;
        this.currentTotal = 0L;
        this.storedEnergy.putAll(energy);
        for (Map.Entry<InkColor, Long> color : energy.entrySet()) {
            this.currentTotal += color.getValue().longValue();
        }
    }

    @Override
    public boolean accepts(InkColor color) {
        return true;
    }

    @Override
    public long addEnergy(InkColor color, long amount) {
        long overflow = Math.max(0L, amount + this.currentTotal - this.maxEnergyTotal);
        long amountToAdd = amount - overflow;
        this.currentTotal += amountToAdd;
        this.storedEnergy.put(color, this.storedEnergy.getOrDefault(color, 0L) + amountToAdd);
        return overflow;
    }

    @Override
    public boolean requestEnergy(InkColor color, long amount) {
        long storedAmount = this.storedEnergy.getOrDefault(color, 0L);
        if (storedAmount < amount) {
            return false;
        }
        this.currentTotal -= amount;
        this.storedEnergy.put(color, storedAmount - amount);
        return true;
    }

    @Override
    public long drainEnergy(InkColor color, long amount) {
        long storedAmount = this.storedEnergy.getOrDefault(color, 0L);
        long drainedAmount = Math.min(storedAmount, amount);
        this.storedEnergy.put(color, storedAmount - drainedAmount);
        this.currentTotal -= drainedAmount;
        return drainedAmount;
    }

    @Override
    public long getEnergy(InkColor color) {
        return this.storedEnergy.getOrDefault(color, 0L);
    }

    @Override
    @Deprecated
    public Map<InkColor, Long> getEnergy() {
        return this.storedEnergy;
    }

    @Override
    @Deprecated
    public void setEnergy(Map<InkColor, Long> colors, long total) {
        this.storedEnergy.putAll(colors);
        this.currentTotal = total;
    }

    @Override
    public long getMaxTotal() {
        return this.maxEnergyTotal;
    }

    @Override
    public long getMaxPerColor() {
        return this.maxEnergyTotal;
    }

    @Override
    public long getCurrentTotal() {
        return this.currentTotal;
    }

    @Override
    public boolean isEmpty() {
        return this.currentTotal == 0L;
    }

    @Override
    public boolean isFull() {
        return this.currentTotal >= this.maxEnergyTotal;
    }

    @Override
    public long getRoom(InkColor color) {
        return this.maxEnergyTotal - this.currentTotal;
    }

    @Override
    public void fillCompletely() {
        this.storedEnergy.clear();
        int inkColorCount = PastelRegistries.INK_COLOR.size();
        long energyPerColor = this.maxEnergyTotal / (long)inkColorCount;
        for (InkColor color : InkColors.all()) {
            this.storedEnergy.put(color, energyPerColor);
        }
        this.currentTotal = energyPerColor * (long)inkColorCount;
    }

    @Override
    public void clearContent() {
        this.storedEnergy.clear();
        this.currentTotal = 0L;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addTooltip(List<Component> tooltip) {
        tooltip.add((Component)Component.translatable((String)"item.pastel.total_capped_simple_pigment_energy_storage.tooltip", (Object[])new Object[]{Support.getShortenedNumberString(this.maxEnergyTotal)}));
        this.addInkContentTooltip(tooltip);
    }

    protected void addInkContentTooltip(List<Component> tooltip) {
        for (InkColor color : PastelRegistries.INK_COLOR) {
            long amount = this.storedEnergy.getOrDefault(color, 0L);
            if (amount <= 0L) continue;
            InkStorage.addInkStoreBulletTooltip(tooltip, color, amount);
        }
    }
}

