/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.energy;

import earth.terrarium.pastel.api.energy.InkStorage;
import earth.terrarium.pastel.components.InkStorageComponent;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import net.minecraft.world.item.ItemStack;

public interface InkStorageItem<PStorage extends InkStorage> {
    public Drainability getDrainability();

    public PStorage getEnergyStorage(ItemStack var1);

    default public void setEnergyStorage(ItemStack itemStack, InkStorage storage) {
        itemStack.set(PastelDataComponentTypes.INK_STORAGE, (Object)new InkStorageComponent(storage));
    }

    public ItemStack getDefaultInstance();

    default public ItemStack getFullStack() {
        ItemStack stack = this.getDefaultInstance();
        PStorage storage = this.getEnergyStorage(stack);
        storage.fillCompletely();
        this.setEnergyStorage(stack, (InkStorage)storage);
        return stack;
    }

    default public void clearEnergyStorage(ItemStack stack) {
        PStorage storage = this.getEnergyStorage(stack);
        storage.clearContent();
        this.setEnergyStorage(stack, (InkStorage)storage);
    }

    public static enum Drainability {
        ALWAYS,
        MACHINE_ONLY,
        PLAYER_ONLY,
        NEVER;


        public boolean canDrain(boolean isPlayer) {
            switch (this.ordinal()) {
                case 3: {
                    return false;
                }
                case 2: {
                    return isPlayer;
                }
                case 1: {
                    return !isPlayer;
                }
            }
            return true;
        }
    }
}

