/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.energy;

import com.cmdpro.databank.DatabankUtils;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.energy.InkCost;
import earth.terrarium.pastel.api.energy.InkStorage;
import earth.terrarium.pastel.api.energy.InkStorageItem;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.progression.PastelCriteria;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public interface InkPowered {
    public static final ResourceLocation REQUIRED_ADVANCEMENT = PastelCommon.locate("milestones/unlock_ink_use");

    @OnlyIn(value=Dist.CLIENT)
    public static boolean canUseClient() {
        Minecraft client = Minecraft.getInstance();
        return InkPowered.canUse((Player)client.player);
    }

    public static boolean canUse(Player playerEntity) {
        return DatabankUtils.hasAdvancement((Player)playerEntity, (ResourceLocation)REQUIRED_ADVANCEMENT);
    }

    public List<InkColor> getUsedColors();

    @OnlyIn(value=Dist.CLIENT)
    default public void addInkPoweredTooltip(List<Component> tooltip) {
        if (InkPowered.canUseClient()) {
            if (this.getUsedColors().size() > 1) {
                tooltip.add((Component)Component.translatable((String)"pastel.tooltip.ink_powered.prefix").withStyle(ChatFormatting.GRAY));
                for (InkColor color : this.getUsedColors()) {
                    tooltip.add((Component)color.getColoredInkName().withStyle(ChatFormatting.GRAY));
                }
            } else {
                tooltip.add((Component)Component.translatable((String)"pastel.tooltip.ink_powered.consume", (Object[])new Object[]{this.getUsedColors().get(0).getColoredInkName()}).withStyle(ChatFormatting.GRAY));
            }
        }
    }

    private static Stream<ItemStack> getCurioInkSlots(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).stream().flatMap(inventory -> inventory.findCurios(itemStack -> itemStack.getItem() instanceof InkStorageItem).stream()).map(SlotResult::stack);
    }

    private static long tryDrainEnergy(@NotNull ItemStack stack, InkColor color, long amount, @Nullable Player player) {
        Item item = stack.getItem();
        if (item instanceof InkStorageItem) {
            InkStorageItem inkStorageItem = (InkStorageItem)item;
            if (!inkStorageItem.getDrainability().canDrain(player != null)) {
                return 0L;
            }
            Object inkStorage = inkStorageItem.getEnergyStorage(stack);
            long drained = inkStorage.drainEnergy(color, amount);
            if (drained > 0L) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayerEntity = (ServerPlayer)player;
                    PastelCriteria.INK_CONTAINER_INTERACTION.trigger(serverPlayerEntity, stack, (InkStorage)inkStorage, color, -amount);
                }
                inkStorageItem.setEnergyStorage(stack, (InkStorage)inkStorage);
            }
            return drained;
        }
        return 0L;
    }

    private static long tryGetEnergy(@NotNull ItemStack stack, InkColor color) {
        Item item = stack.getItem();
        if (item instanceof InkStorageItem) {
            InkStorageItem inkStorageItem = (InkStorageItem)item;
            Object inkStorage = inkStorageItem.getEnergyStorage(stack);
            return inkStorage.getEnergy(color);
        }
        return 0L;
    }

    public static boolean tryDrainEnergy(@NotNull Container inventory, InkColor color, long amount) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack currentStack = inventory.getItem(i);
            if (currentStack.isEmpty() || (amount -= InkPowered.tryDrainEnergy(currentStack, color, amount, null)) > 0L) continue;
            return true;
        }
        return false;
    }

    public static boolean tryDrainEnergy(@NotNull Player player, @NotNull InkCost inkCost) {
        return InkPowered.tryDrainEnergy(player, inkCost.color(), inkCost.cost());
    }

    public static boolean tryDrainEnergy(@NotNull Player player, @NotNull InkCost inkCost, float costModifier) {
        return InkPowered.tryDrainEnergy(player, inkCost.color(), (long)Support.chanceRound((float)inkCost.cost() * costModifier, player.getRandom()));
    }

    public static boolean tryDrainEnergy(@NotNull Player player, @NotNull InkColor color, long amount) {
        if (player.isCreative()) {
            return true;
        }
        if (!InkPowered.canUse(player)) {
            return false;
        }
        for (ItemStack itemStack : player.getHandSlots()) {
            if ((amount -= InkPowered.tryDrainEnergy(itemStack, color, amount, player)) > 0L) continue;
            return true;
        }
        List<ItemStack> trinketInkStorages = InkPowered.getCurioInkSlots(player).toList();
        for (ItemStack trinketEnergyStorageStack : trinketInkStorages) {
            if ((amount -= InkPowered.tryDrainEnergy(trinketEnergyStorageStack, color, amount, player)) > 0L) continue;
            return true;
        }
        for (ItemStack itemStack : player.getInventory().items) {
            if ((amount -= InkPowered.tryDrainEnergy(itemStack, color, amount, player)) > 0L) continue;
            return true;
        }
        return false;
    }

    public static long getAvailableInk(@NotNull Player player, InkColor color) {
        if (player.isCreative()) {
            return Long.MAX_VALUE;
        }
        if (!InkPowered.canUse(player)) {
            return 0L;
        }
        long available = 0L;
        for (ItemStack itemStack : player.getHandSlots()) {
            available += InkPowered.tryGetEnergy(itemStack, color);
        }
        available += InkPowered.getCurioInkSlots(player).mapToLong(stack -> InkPowered.tryGetEnergy(stack, color)).sum();
        for (ItemStack itemStack : player.getInventory().items) {
            available += InkPowered.tryGetEnergy(itemStack, color);
        }
        return available;
    }

    public static boolean hasAvailableInk(Player player, InkCost inkCost) {
        return InkPowered.hasAvailableInk(player, inkCost.color(), inkCost.cost());
    }

    public static boolean hasAvailableInk(Player player, InkColor color, long amount) {
        if (!InkPowered.canUse(player)) {
            return false;
        }
        if (player.isCreative()) {
            return true;
        }
        for (ItemStack itemStack : player.getHandSlots()) {
            if ((amount -= InkPowered.tryGetEnergy(itemStack, color)) > 0L) continue;
            return true;
        }
        List<ItemStack> trinketInkStorages = InkPowered.getCurioInkSlots(player).toList();
        for (ItemStack trinketEnergyStorageStack : trinketInkStorages) {
            if ((amount -= InkPowered.tryGetEnergy(trinketEnergyStorageStack, color)) > 0L) continue;
            return true;
        }
        for (ItemStack itemStack : player.getInventory().items) {
            if ((amount -= InkPowered.tryGetEnergy(itemStack, color)) > 0L) continue;
            return true;
        }
        return false;
    }
}

