/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.block;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.recipe.GatedRecipe;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.FMLLoader;

public interface GatedGuidebookPage {
    public static final Map<ResourceLocation, ResourceLocation> SANITY_WHITELIST = Map.of(PastelCommon.locate("resources/jade_vines"), PastelCommon.locate("midgame/build_spirit_instiller_structure"), PastelCommon.locate("cuisine/tarts"), PastelCommon.locate("craft_salted_jaramel_trifle_or_tart"), PastelCommon.locate("cuisine/trifles"), PastelCommon.locate("craft_salted_jaramel_trifle_or_tart"), PastelCommon.locate("resources/bloodstone"), PastelCommon.locate("unlocks/blocks/crystallarieum"), PastelCommon.locate("resources/malachite"), PastelCommon.locate("unlocks/blocks/crystallarieum"), PastelCommon.locate("creating_life/egg_laying_wooly_pig"), PastelCommon.locate("midgame/remember_egg_laying_wooly_pig"));

    public static void runSanityCheck(ResourceLocation entryId, int pageNr, String pageAdvancement, GatedRecipe<?> ... recipes) {
        if (!FMLLoader.isProduction() && pageAdvancement != null && !pageAdvancement.isEmpty()) {
            for (GatedRecipe<?> recipe : recipes) {
                if (recipe == null) {
                    PastelCommon.logWarning("Guidebook page " + String.valueOf(entryId) + " page " + pageNr + " is missing its recipe");
                    continue;
                }
                Optional<ResourceLocation> recipeAdvId = recipe.advancementID();
                ResourceLocation combinedAdvId = recipeAdvId.orElse(recipe.typeAdvancementID());
                if (combinedAdvId == null) {
                    PastelCommon.logWarning("Guidebook page " + String.valueOf(entryId) + "[" + pageNr + "] references advancement " + pageAdvancement + " for a recipe that does not have an unlock: " + String.valueOf(recipeAdvId));
                    continue;
                }
                if (SANITY_WHITELIST.containsKey(entryId) && SANITY_WHITELIST.get(entryId).equals((Object)ResourceLocation.parse((String)pageAdvancement)) || combinedAdvId.toString().equals(pageAdvancement)) continue;
                PastelCommon.logWarning("Guidebook page " + String.valueOf(entryId) + "[" + pageNr + "] references advancement " + pageAdvancement + " that differs from the one set in the recipe: " + String.valueOf(recipeAdvId));
            }
        }
    }
}

