/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.api.block;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import earth.terrarium.pastel.api.item.ItemReference;
import earth.terrarium.pastel.inventories.slots.ShadowSlot;
import earth.terrarium.pastel.networking.c2s_payloads.SetShadowSlotPayload;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FilterConfigurable {
    public static final String FILTER_KEY = "Filter";

    public NonNullList<ItemReference> getItemFilters();

    public void setFilterItem(int var1, ItemStack var2);

    default public int getFilterRows() {
        return 1;
    }

    default public int getSlotsPerRow() {
        return 5;
    }

    default public int getDrawnSlots() {
        return this.getItemFilters().size();
    }

    public static void writeFilterNbt(CompoundTag tag, List<ItemReference> filterItems, HolderLookup.Provider lookup) {
        CompoundTag innerTag = new CompoundTag();
        ListTag list = new ListTag();
        for (int i = 0; i < filterItems.size(); ++i) {
            ItemReference ref = filterItems.get(i);
            if (ref.isEmpty()) continue;
            CompoundTag refTag = new CompoundTag();
            refTag.putInt("Slot", i);
            refTag.put("Ref", (Tag)ItemReference.CODEC.encodeStart((DynamicOps)lookup.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)ref).getOrThrow());
            list.add((Object)refTag);
        }
        innerTag.put("Filters", (Tag)list);
        tag.put(FILTER_KEY, (Tag)innerTag);
    }

    public static void readFilterNbt(CompoundTag tag, List<ItemReference> filterItems, HolderLookup.Provider lookup) {
        filterItems.clear();
        if (!tag.contains(FILTER_KEY)) {
            return;
        }
        CompoundTag innerTag = tag.getCompound(FILTER_KEY);
        ListTag list = innerTag.getList("Filters", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag refTag = list.getCompound(i);
            int slot = refTag.getInt("Slot");
            if (slot > filterItems.size()) continue;
            filterItems.set(slot, (ItemReference)((Pair)ItemReference.CODEC.decode((DynamicOps)lookup.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)refTag.getCompound("Ref")).getOrThrow()).getFirst());
        }
    }

    public static Container getFilterInventoryFromDataClicker(ExtendedData data, ShadowSlotClicker clicker) {
        int size = data.filterItems().size();
        FilterInventory inventory = new FilterInventory(clicker, size);
        for (int i = 0; i < size; ++i) {
            inventory.setItem(i, data.filterItems().get(i).asStack());
        }
        return inventory;
    }

    public static Container getFilterInventoryFromExtendedData(int syncId, @NotNull Inventory playerInventory, ExtendedData data, @NotNull AbstractContainerMenu handler) {
        ShadowSlotClicker.FromHandler clicker = new ShadowSlotClicker.FromHandler(handler, playerInventory.player, syncId);
        return FilterConfigurable.getFilterInventoryFromDataClicker(data, clicker);
    }

    public static Container getFilterInventoryFromItemsClicker(List<ItemReference> items, ShadowSlotClicker clicker) {
        FilterInventory inventory = new FilterInventory(clicker, items.size());
        for (int i = 0; i < items.size(); ++i) {
            inventory.setItem(i, items.get(i).asStack());
        }
        return inventory;
    }

    public static Container getFilterInventoryFromItemsHandler(int syncId, @NotNull Inventory playerInventory, List<ItemReference> items, @NotNull AbstractContainerMenu thisHandler) {
        ShadowSlotClicker.FromHandler clicker = new ShadowSlotClicker.FromHandler(thisHandler, playerInventory.player, syncId);
        return FilterConfigurable.getFilterInventoryFromItemsClicker(items, clicker);
    }

    public static void writeScreenOpeningData(RegistryFriendlyByteBuf buf, FilterConfigurable configurable) {
        FilterConfigurable.writeScreenOpeningData(buf, configurable.getItemFilters(), configurable.getFilterRows(), configurable.getSlotsPerRow(), configurable.getDrawnSlots());
    }

    public static void writeScreenOpeningData(RegistryFriendlyByteBuf buf, List<ItemReference> filterItems, int rows, int slotsPerRow, int drawnSlots) {
        buf.writeInt(filterItems.size());
        CompoundTag nbt = new CompoundTag();
        FilterConfigurable.writeFilterNbt(nbt, filterItems, (HolderLookup.Provider)buf.registryAccess());
        buf.writeNbt((Tag)nbt);
        buf.writeInt(rows);
        buf.writeInt(slotsPerRow);
        buf.writeInt(drawnSlots);
    }

    default public boolean hasEmptyFilter() {
        NonNullList<ItemReference> filters = this.getItemFilters();
        for (ItemReference filter : filters) {
            if (filter.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public record ExtendedData(List<ItemReference> filterItems, int rows, int slotsPerRow, int drawnSlots) {
        public static final StreamCodec<RegistryFriendlyByteBuf, ExtendedData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemReference.STREAM_CODEC.apply(ByteBufCodecs.list()), ExtendedData::filterItems, (StreamCodec)ByteBufCodecs.VAR_INT, ExtendedData::rows, (StreamCodec)ByteBufCodecs.VAR_INT, ExtendedData::slotsPerRow, (StreamCodec)ByteBufCodecs.VAR_INT, ExtendedData::drawnSlots, ExtendedData::new);

        public ExtendedData(FilterConfigurable configurable) {
            this((List<ItemReference>)configurable.getItemFilters(), configurable.getFilterRows(), configurable.getSlotsPerRow(), configurable.getDrawnSlots());
        }
    }

    public static class FilterInventory
    extends SimpleContainer {
        @NotNull
        private final ShadowSlotClicker clicker;

        public FilterInventory(@NotNull ShadowSlotClicker slotClicker, int size) {
            super(size);
            this.clicker = slotClicker;
        }

        @NotNull
        public ShadowSlotClicker getClicker() {
            return this.clicker;
        }
    }

    public static interface ShadowSlotClicker {
        default public void clickShadowSlot(int syncId, Slot slot, ItemStack shadowStack) {
            this.clickShadowSlot(syncId, slot.index, shadowStack);
        }

        public void clickShadowSlot(int var1, int var2, ItemStack var3);

        public static class FromHandler
        implements ShadowSlotClicker {
            @NotNull
            public final AbstractContainerMenu handler;
            @NotNull
            public final Player player;
            public final int syncId;

            public FromHandler(@NotNull AbstractContainerMenu screenHandler, @NotNull Player player, int syncId) {
                this.handler = screenHandler;
                this.player = player;
                this.syncId = syncId;
            }

            @Override
            public void clickShadowSlot(int syncId, @Nullable Slot slot, ItemStack shadowStack) {
                if (this.syncId != syncId || !(slot instanceof ShadowSlot)) {
                    return;
                }
                ShadowSlot shadowSlot = (ShadowSlot)slot;
                if (!shadowSlot.onClicked(shadowStack, ClickAction.PRIMARY, this.player)) {
                    return;
                }
                if (this.player.level().isClientSide()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new SetShadowSlotPayload(syncId, slot.index, shadowStack), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }

            @Override
            public void clickShadowSlot(int syncId, int id, ItemStack shadowStack) {
                this.clickShadowSlot(syncId, this.handler.getSlot(id), shadowStack);
            }
        }
    }

    public record ExtendedDataWithPos(BlockPos pos, ExtendedData data) {
        public static final StreamCodec<RegistryFriendlyByteBuf, ExtendedDataWithPos> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, c -> c.pos, ExtendedData.STREAM_CODEC, c -> c.data, ExtendedDataWithPos::new);

        public ExtendedDataWithPos(BlockPos pos, FilterConfigurable configurable) {
            this(pos, new ExtendedData((List<ItemReference>)configurable.getItemFilters(), configurable.getFilterRows(), configurable.getSlotsPerRow(), configurable.getDrawnSlots()));
        }
    }
}

