/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.ancientreforging.data;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.affix.AffixType;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.LootRule;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.color.GradientColor;
import dev.shadowsoffire.placebo.reload.DynamicRegistry;
import dev.shadowsoffire.placebo.util.data.DynamicRegistryProvider;
import ianm1647.ancientreforging.AncientReforging;
import ianm1647.ancientreforging.Reforge;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.Unbreakable;

public class ARRarityProvider
extends DynamicRegistryProvider<LootRarity> {
    public ARRarityProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, (DynamicRegistry)RarityRegistry.INSTANCE);
    }

    public String getName() {
        return "Ancient Rarities";
    }

    public void generate() {
        this.addAncient("ancient", (TextColor)GradientColor.RAINBOW, Reforge.Items.ANCIENT_MATERIAL, b -> b.sortIndex(800).weights(TieredWeights.builder().with(WorldTier.HAVEN, 0, 0.0f).with(WorldTier.FRONTIER, 0, 0.0f).with(WorldTier.ASCENT, 0, 0.0f).with(WorldTier.SUMMIT, 0, 0.0f).with(WorldTier.PINNACLE, 10, 2.0f)).rule((LootRule)new LootRule.AffixLootRule(AffixType.STAT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.STAT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.STAT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.STAT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.STAT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.BASIC_EFFECT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.BASIC_EFFECT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.BASIC_EFFECT)).rule((LootRule)new LootRule.AffixLootRule(AffixType.ABILITY)).rule((LootRule)new LootRule.AffixLootRule(AffixType.ABILITY)).rule((LootRule)new LootRule.SelectLootRule(0.85f, (LootRule)new LootRule.SocketLootRule(3, 4), (LootRule)new LootRule.SocketLootRule(5, 5))).rule((LootRule)new LootRule.SelectLootRule(0.95f, (LootRule)new LootRule.DurabilityLootRule(0.6f, 0.9f), (LootRule)new LootRule.ComponentLootRule(DataComponentPatch.builder().set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)).remove(Apoth.Components.DURABILITY_BONUS).build()))).renderData(c -> c.beamHeight(5.0f).beamRadius(0.05f).glowRadius(0.1f).shadow(d -> d.texture(Apotheosis.loc((String)"textures/rarity/shadow_t4.png")).frames(7).size(0.6f).frameTime(1.5f)).particle(true)));
    }

    static <T> LootRule componentRule(DataComponentType<T> type, T value) {
        return new LootRule.ComponentLootRule(DataComponentPatch.builder().set(type, value).build());
    }

    void addRarity(String id, TextColor color, Holder<Item> material, UnaryOperator<LootRarity.Builder> config) {
        this.add(Apotheosis.loc((String)id), (CodecProvider)((LootRarity.Builder)config.apply(ARRarityProvider.builder(color, material))).build());
    }

    void addAncient(String id, TextColor color, Holder<Item> material, UnaryOperator<LootRarity.Builder> config) {
        this.add(AncientReforging.loc(id), (CodecProvider)((LootRarity.Builder)config.apply(ARRarityProvider.builder(color, material))).build());
    }

    public static LootRarity.Builder builder(TextColor color, Holder<Item> material) {
        return new LootRarity.Builder(color, material);
    }
}

