/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.ancientreforging.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.shadowsoffire.apotheosis.Apotheosis;
import ianm1647.ancientreforging.block.AncientReforgingTableTile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class AncientReforgingTableTileRenderer
implements BlockEntityRenderer<AncientReforgingTableTile> {
    public static final ModelResourceLocation HAMMER = ModelResourceLocation.standalone((ResourceLocation)Apotheosis.loc((String)"item/hammer"));

    public void render(AncientReforgingTableTile tile, float partials, PoseStack matrix, MultiBufferSource pBufferSource, int light, int overlay) {
        ItemRenderer irenderer = Minecraft.getInstance().getItemRenderer();
        BakedModel base = irenderer.getItemModelShaper().getModelManager().getModel(HAMMER);
        matrix.pushPose();
        double px = 0.0625;
        matrix.scale(1.25f, 1.25f, 1.25f);
        matrix.translate(8.5 * px / 1.25, 16.0 * px / 1.25 - 0.015, 7.0 * px / 1.25);
        matrix.mulPose(Axis.YP.rotationDegrees(45.0f));
        matrix.mulPose(Axis.XP.rotationDegrees(90.0f));
        if (tile.step1) {
            float factor = (float)(tile.time % 60) + partials;
            float sin = Mth.sin((float)(factor * (float)Math.PI / 120.0f));
            float sinSq = sin * sin;
            matrix.translate(0.125 * (double)sinSq, 0.0, -0.15 * (double)sinSq);
            matrix.mulPose(Axis.YN.rotationDegrees(45.0f * sinSq));
        } else {
            float factor = (float)(tile.time % 5) + partials;
            float sin = Mth.sin((float)(1.5707964f + factor * (float)Math.PI / 10.0f));
            float sinSq = sin * sin;
            matrix.translate(0.125 * (double)sinSq, 0.0, -0.15 * (double)sinSq);
            matrix.mulPose(Axis.YN.rotationDegrees(45.0f * sinSq));
        }
        irenderer.renderModelLists(base, ItemStack.EMPTY, light, overlay, matrix, ItemRenderer.getFoilBufferDirect((MultiBufferSource)pBufferSource, (RenderType)ItemBlockRenderTypes.getRenderType((BlockState)tile.getBlockState(), (boolean)true), (boolean)true, (boolean)false));
        matrix.popPose();
    }
}

