/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.extradisks.data;

import com.refinedmods.refinedstorage.common.content.Blocks;
import com.refinedmods.refinedstorage.common.misc.ProcessorItem;
import com.refinedmods.refinedstorage.common.storage.FluidStorageVariant;
import com.refinedmods.refinedstorage.common.storage.ItemStorageVariant;
import com.refinedmods.refinedstorage.mekanism.content.Items;
import com.refinedmods.refinedstorage.mekanism.storage.ChemicalStorageVariant;
import de.melanx.extradisks.Registration;
import de.melanx.extradisks.content.chemical.ExtraChemicalStorageDiskItem;
import de.melanx.extradisks.content.chemical.ExtraChemicalStorageVariant;
import de.melanx.extradisks.content.fluid.ExtraFluidStorageDiskItem;
import de.melanx.extradisks.content.fluid.ExtraFluidStorageVariant;
import de.melanx.extradisks.content.item.ExtraItemStorageDiskItem;
import de.melanx.extradisks.content.item.ExtraItemStorageVariant;
import de.melanx.extradisks.data.ModTags;
import de.melanx.extradisks.data.recipes.builder.StorageContainerUpgradeRecipeBuilder;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import mekanism.common.registries.MekanismItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;

public class Recipes
extends RecipeProvider {
    public Recipes(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(@Nonnull RecipeOutput recipeOutput, @Nonnull HolderLookup.Provider holderLookup) {
        RecipeOutput mekanismRecipeOutput = recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("mekanism"), new ModLoadedCondition("refinedstorage_mekanism_integration")});
        for (ExtraItemStorageVariant extraItemStorageVariant : ExtraItemStorageVariant.values()) {
            this.registerDiskRecipes((Item)Registration.ITEM_STORAGE_DISK.get((Object)extraItemStorageVariant).get(), ModTags.Items.PARTS_ITEM.get((Object)extraItemStorageVariant), recipeOutput);
            this.registerStorageBlockRecipe(ModTags.Items.PARTS_ITEM.get((Object)extraItemStorageVariant), (ItemLike)Registration.ITEM_STORAGE_BLOCK.get((Object)extraItemStorageVariant).get(), recipeOutput);
        }
        for (Enum enum_ : ExtraFluidStorageVariant.values()) {
            this.registerDiskRecipes((Item)Registration.FLUID_STORAGE_DISK.get(enum_).get(), ModTags.Items.PARTS_FLUID.get(enum_), recipeOutput);
            this.registerStorageBlockRecipe(ModTags.Items.PARTS_FLUID.get(enum_), (ItemLike)Registration.FLUID_STORAGE_BLOCK.get(enum_).get(), recipeOutput);
        }
        for (Enum enum_ : ExtraChemicalStorageVariant.values()) {
            this.registerMekanismDiskRecipes((Item)Registration.CHEMICAL_STORAGE_DISK.get(enum_).get(), ModTags.Items.PARTS_CHEMICAL.get(enum_), mekanismRecipeOutput);
            this.registerMekanismStorageBlockRecipe(ModTags.Items.PARTS_CHEMICAL.get(enum_), (ItemLike)Registration.CHEMICAL_STORAGE_BLOCK.get(enum_).get(), mekanismRecipeOutput);
        }
        this.registerPartRecipe((Item)Registration.ITEM_STORAGE_PART.get((Object)ExtraItemStorageVariant.TIER_5).get(), com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getItemStoragePart(ItemStorageVariant.SIXTY_FOUR_K), recipeOutput);
        this.registerPartRecipe((Item)Registration.ITEM_STORAGE_PART.get((Object)ExtraItemStorageVariant.TIER_6).get(), ModTags.Items.PARTS_ITEM.get((Object)ExtraItemStorageVariant.TIER_5), recipeOutput);
        this.registerPartRecipe((Item)Registration.ITEM_STORAGE_PART.get((Object)ExtraItemStorageVariant.TIER_7).get(), ModTags.Items.PARTS_ITEM.get((Object)ExtraItemStorageVariant.TIER_6), recipeOutput);
        this.registerPartRecipe((Item)Registration.ITEM_STORAGE_PART.get((Object)ExtraItemStorageVariant.TIER_8).get(), ModTags.Items.PARTS_ITEM.get((Object)ExtraItemStorageVariant.TIER_7), recipeOutput);
        this.registerPartRecipe((Item)Registration.ITEM_STORAGE_PART.get((Object)ExtraItemStorageVariant.TIER_9).get(), ModTags.Items.PARTS_ITEM.get((Object)ExtraItemStorageVariant.TIER_8), recipeOutput);
        this.registerAdvancedPartRecipe((Item)Registration.ITEM_STORAGE_PART.get((Object)ExtraItemStorageVariant.TIER_10).get(), ModTags.Items.PARTS_ITEM.get((Object)ExtraItemStorageVariant.TIER_9), recipeOutput);
        this.registerAdvancedPartRecipe((Item)Registration.ITEM_STORAGE_PART.get((Object)ExtraItemStorageVariant.TIER_11).get(), ModTags.Items.PARTS_ITEM.get((Object)ExtraItemStorageVariant.TIER_10), recipeOutput);
        this.registerAdvancedPartRecipe((Item)Registration.ITEM_STORAGE_PART.get((Object)ExtraItemStorageVariant.TIER_12).get(), ModTags.Items.PARTS_ITEM.get((Object)ExtraItemStorageVariant.TIER_11), recipeOutput);
        this.registerPartRecipe((Item)Registration.FLUID_STORAGE_PART.get((Object)ExtraFluidStorageVariant.TIER_5_FLUID).get(), com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getFluidStoragePart(FluidStorageVariant.FOUR_THOUSAND_NINETY_SIX_B), recipeOutput);
        this.registerPartRecipe((Item)Registration.FLUID_STORAGE_PART.get((Object)ExtraFluidStorageVariant.TIER_6_FLUID).get(), ModTags.Items.PARTS_FLUID.get((Object)ExtraFluidStorageVariant.TIER_5_FLUID), recipeOutput);
        this.registerPartRecipe((Item)Registration.FLUID_STORAGE_PART.get((Object)ExtraFluidStorageVariant.TIER_7_FLUID).get(), ModTags.Items.PARTS_FLUID.get((Object)ExtraFluidStorageVariant.TIER_6_FLUID), recipeOutput);
        this.registerAdvancedPartRecipe((Item)Registration.FLUID_STORAGE_PART.get((Object)ExtraFluidStorageVariant.TIER_8_FLUID).get(), ModTags.Items.PARTS_FLUID.get((Object)ExtraFluidStorageVariant.TIER_7_FLUID), recipeOutput);
        this.registerAdvancedPartRecipe((Item)Registration.FLUID_STORAGE_PART.get((Object)ExtraFluidStorageVariant.TIER_9_FLUID).get(), ModTags.Items.PARTS_FLUID.get((Object)ExtraFluidStorageVariant.TIER_8_FLUID), recipeOutput);
        this.registerMekanismPartRecipe((Item)Registration.CHEMICAL_STORAGE_PART.get((Object)ExtraChemicalStorageVariant.TIER_5_CHEMICAL).get(), Items.getChemicalStoragePart((ChemicalStorageVariant)ChemicalStorageVariant.EIGHT_THOUSAND_NINETY_TWO_B), mekanismRecipeOutput);
        this.registerMekanismPartRecipe((Item)Registration.CHEMICAL_STORAGE_PART.get((Object)ExtraChemicalStorageVariant.TIER_6_CHEMICAL).get(), ModTags.Items.PARTS_CHEMICAL.get((Object)ExtraChemicalStorageVariant.TIER_5_CHEMICAL), mekanismRecipeOutput);
        this.registerMekanismPartRecipe((Item)Registration.CHEMICAL_STORAGE_PART.get((Object)ExtraChemicalStorageVariant.TIER_7_CHEMICAL).get(), ModTags.Items.PARTS_CHEMICAL.get((Object)ExtraChemicalStorageVariant.TIER_6_CHEMICAL), mekanismRecipeOutput);
        this.registerMekanismAdvancedPartRecipe((Item)Registration.CHEMICAL_STORAGE_PART.get((Object)ExtraChemicalStorageVariant.TIER_8_CHEMICAL).get(), ModTags.Items.PARTS_CHEMICAL.get((Object)ExtraChemicalStorageVariant.TIER_7_CHEMICAL), mekanismRecipeOutput);
        this.registerMekanismAdvancedPartRecipe((Item)Registration.CHEMICAL_STORAGE_PART.get((Object)ExtraChemicalStorageVariant.TIER_9_CHEMICAL).get(), ModTags.Items.PARTS_CHEMICAL.get((Object)ExtraChemicalStorageVariant.TIER_8_CHEMICAL), mekanismRecipeOutput);
        this.registerProcessorRecipe((ItemLike)Registration.WITHERING_PROCESSOR.get(), (ItemLike)Registration.RAW_WITHERING_PROCESSOR.get(), Ingredient.of((TagKey)Tags.Items.NETHER_STARS), recipeOutput);
        this.registerUpgrades(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)Registration.ADVANCED_STORAGE_HOUSING.get())).pattern("GEG").pattern("E E").pattern("IAI").define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('E'), (ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getQuartzEnrichedIron()).define(Character.valueOf('I'), (ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getProcessor(ProcessorItem.Type.IMPROVED)).define(Character.valueOf('A'), (ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getProcessor(ProcessorItem.Type.ADVANCED)).unlockedBy("has_processor", Recipes.has((ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getProcessor(ProcessorItem.Type.ADVANCED))).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)Registration.ADVANCED_MACHINE_CASING.get())).pattern("DCD").pattern("GBG").pattern("DOD").define(Character.valueOf('D'), (ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getProcessor(ProcessorItem.Type.ADVANCED)).define(Character.valueOf('C'), (ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getConstructionCore()).define(Character.valueOf('G'), (ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getProcessor(ProcessorItem.Type.IMPROVED)).define(Character.valueOf('B'), (ItemLike)Blocks.INSTANCE.getMachineCasing()).define(Character.valueOf('O'), (ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getDestructionCore()).unlockedBy("has_processor", Recipes.has((ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getProcessor(ProcessorItem.Type.ADVANCED))).save(recipeOutput);
    }

    private void registerProcessorRecipe(ItemLike result, ItemLike raw, Ingredient ingredient, RecipeOutput recipeOutput) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{raw}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)0.5f, (int)200).unlockedBy("has_raw", Recipes.has((ItemLike)raw)).save(recipeOutput);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)raw).requires((ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getProcessorBinding()).requires(ingredient).requires((ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getSilicon()).requires(Tags.Items.DUSTS_REDSTONE).unlockedBy("has_binding", Recipes.has((ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getProcessorBinding())).save(recipeOutput);
    }

    private void registerPartRecipe(Item result, Item prevPart, RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern("DED").pattern("PRP").pattern("DPD").define(Character.valueOf('D'), (ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getProcessor(ProcessorItem.Type.ADVANCED)).define(Character.valueOf('E'), (ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getQuartzEnrichedIron()).define(Character.valueOf('P'), (ItemLike)prevPart).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).unlockedBy("has_prev_part", Recipes.has((ItemLike)prevPart)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"extradisks", (String)("part/" + BuiltInRegistries.ITEM.getKey((Object)result).getPath())));
    }

    private void registerPartRecipe(Item result, TagKey<Item> prevPart, RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern("DED").pattern("PRP").pattern("DPD").define(Character.valueOf('D'), (ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getProcessor(ProcessorItem.Type.ADVANCED)).define(Character.valueOf('E'), (ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getQuartzEnrichedIron()).define(Character.valueOf('P'), prevPart).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).unlockedBy("has_prev_part", Recipes.has(prevPart)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"extradisks", (String)("part/" + BuiltInRegistries.ITEM.getKey((Object)result).getPath())));
    }

    private void registerAdvancedPartRecipe(Item result, TagKey<Item> prevPart, RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern("DED").pattern("PRP").pattern("DPD").define(Character.valueOf('D'), (ItemLike)Registration.WITHERING_PROCESSOR.get()).define(Character.valueOf('E'), (ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getQuartzEnrichedIron()).define(Character.valueOf('P'), prevPart).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).unlockedBy("has_prev_part", Recipes.has(prevPart)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"extradisks", (String)("part/" + BuiltInRegistries.ITEM.getKey((Object)result).getPath())));
    }

    private void registerDiskRecipes(Item result, TagKey<Item> part, RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern("GEG").pattern("EPE").pattern("IAI").define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('E'), (ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getQuartzEnrichedIron()).define(Character.valueOf('P'), part).define(Character.valueOf('I'), (ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getProcessor(ProcessorItem.Type.IMPROVED)).define(Character.valueOf('A'), (ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getProcessor(ProcessorItem.Type.ADVANCED)).unlockedBy("has_part", Recipes.has(part)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"extradisks", (String)("disk/shaped/" + BuiltInRegistries.ITEM.getKey((Object)result).getPath())));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).requires((ItemLike)Registration.ADVANCED_STORAGE_HOUSING.get()).requires(part).unlockedBy("has_part", Recipes.has(part)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"extradisks", (String)("disk/shapeless/" + BuiltInRegistries.ITEM.getKey((Object)result).getPath())));
    }

    private void registerStorageBlockRecipe(TagKey<Item> part, ItemLike block, RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)block).pattern("QPQ").pattern("QCQ").pattern("QRQ").define(Character.valueOf('Q'), (ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getQuartzEnrichedIron()).define(Character.valueOf('P'), part).define(Character.valueOf('C'), (ItemLike)Registration.ADVANCED_MACHINE_CASING.get()).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).unlockedBy("has_part", Recipes.has(part)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"extradisks", (String)("blocks/" + BuiltInRegistries.ITEM.getKey((Object)block.asItem()).getPath())));
    }

    private void registerMekanismPartRecipe(Item result, Item prevPart, RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern("DOD").pattern("PAP").pattern("DPD").define(Character.valueOf('D'), (ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getProcessor(ProcessorItem.Type.ADVANCED)).define(Character.valueOf('O'), ModTags.Items.OSMIUM_INGOTS).define(Character.valueOf('P'), (ItemLike)prevPart).define(Character.valueOf('A'), (ItemLike)MekanismItems.ATOMIC_ALLOY).unlockedBy("has_prev_part", Recipes.has((ItemLike)prevPart)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"extradisks", (String)("part/" + BuiltInRegistries.ITEM.getKey((Object)result).getPath())));
    }

    private void registerMekanismPartRecipe(Item result, TagKey<Item> prevPart, RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern("DOD").pattern("PAP").pattern("DPD").define(Character.valueOf('D'), (ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getProcessor(ProcessorItem.Type.ADVANCED)).define(Character.valueOf('O'), ModTags.Items.OSMIUM_INGOTS).define(Character.valueOf('P'), prevPart).define(Character.valueOf('A'), (ItemLike)MekanismItems.ATOMIC_ALLOY).unlockedBy("has_prev_part", Recipes.has(prevPart)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"extradisks", (String)("part/" + BuiltInRegistries.ITEM.getKey((Object)result).getPath())));
    }

    private void registerMekanismAdvancedPartRecipe(Item result, TagKey<Item> prevPart, RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern("DOD").pattern("PAP").pattern("DPD").define(Character.valueOf('D'), (ItemLike)Registration.WITHERING_PROCESSOR.get()).define(Character.valueOf('O'), ModTags.Items.OSMIUM_INGOTS).define(Character.valueOf('P'), prevPart).define(Character.valueOf('A'), (ItemLike)MekanismItems.ATOMIC_ALLOY).unlockedBy("has_prev_part", Recipes.has(prevPart)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"extradisks", (String)("part/" + BuiltInRegistries.ITEM.getKey((Object)result).getPath())));
    }

    private void registerMekanismDiskRecipes(Item result, TagKey<Item> part, RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).pattern("GRG").pattern("RPR").pattern("OOO").define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('R'), (ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getQuartzEnrichedIron()).define(Character.valueOf('P'), part).define(Character.valueOf('O'), ModTags.Items.OSMIUM_INGOTS).unlockedBy("has_part", Recipes.has(part)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"extradisks", (String)("disk/shaped/" + BuiltInRegistries.ITEM.getKey((Object)result).getPath())));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)result).requires((ItemLike)Registration.ADVANCED_STORAGE_HOUSING.get()).requires(part).unlockedBy("has_part", Recipes.has(part)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"extradisks", (String)("disk/shapeless/" + BuiltInRegistries.ITEM.getKey((Object)result).getPath())));
    }

    private void registerMekanismStorageBlockRecipe(TagKey<Item> part, ItemLike block, RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)block).pattern("OPO").pattern("OCO").pattern("ORO").define(Character.valueOf('O'), ModTags.Items.OSMIUM_INGOTS).define(Character.valueOf('P'), part).define(Character.valueOf('C'), (ItemLike)Registration.ADVANCED_MACHINE_CASING.get()).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).unlockedBy("has_part", Recipes.has(part)).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"extradisks", (String)("blocks/" + BuiltInRegistries.ITEM.getKey((Object)block.asItem()).getPath())));
    }

    private void registerUpgrades(RecipeOutput recipeOutput) {
        this.registerItemStorageUpgrades(recipeOutput);
        this.registerFluidStorageUpgrades(recipeOutput);
        this.registerChemicalStorageUpgrades(recipeOutput);
    }

    /*
     * WARNING - void declaration
     */
    private void registerItemStorageUpgrades(RecipeOutput recipeOutput) {
        void var6_17;
        void var6_15;
        int n;
        HashSet<Object> disks = new HashSet<Object>();
        ItemStorageVariant[] itemStorageVariantArray = ItemStorageVariant.values();
        int n2 = itemStorageVariantArray.length;
        for (n = 0; n < n2; ++n) {
            ItemStorageVariant itemStorageVariant = itemStorageVariantArray[n];
            if (itemStorageVariant == ItemStorageVariant.CREATIVE) continue;
            disks.add(new Ingredient.ItemValue(com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getItemStorageDisk(itemStorageVariant).getDefaultInstance()));
        }
        for (ExtraItemStorageVariant extraItemStorageVariant : ExtraItemStorageVariant.values()) {
            DeferredItem<ExtraItemStorageDiskItem> deferredItem = Registration.ITEM_STORAGE_DISK.get((Object)extraItemStorageVariant);
            StorageContainerUpgradeRecipeBuilder.shapeless(deferredItem).disk(Ingredient.fromValues(disks.stream())).part(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)Registration.ITEM_STORAGE_PART.get((Object)extraItemStorageVariant)})).save(recipeOutput);
            disks.add(new Ingredient.TagValue(ModTags.Items.DISKS_ITEM.get((Object)extraItemStorageVariant)));
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        ItemStorageVariant[] itemStorageVariantArray2 = ItemStorageVariant.values();
        n = itemStorageVariantArray2.length;
        boolean bl = false;
        while (var6_15 < n) {
            ItemStorageVariant itemStorageVariant = itemStorageVariantArray2[var6_15];
            if (itemStorageVariant != ItemStorageVariant.CREATIVE) {
                hashSet.add(Blocks.INSTANCE.getItemStorageBlock(itemStorageVariant));
            }
            ++var6_15;
        }
        ExtraItemStorageVariant[] extraItemStorageVariantArray = ExtraItemStorageVariant.values();
        n = extraItemStorageVariantArray.length;
        boolean bl2 = false;
        while (var6_17 < n) {
            ExtraItemStorageVariant extraItemStorageVariant = extraItemStorageVariantArray[var6_17];
            DeferredBlock<Block> storageBlock = Registration.ITEM_STORAGE_BLOCK.get((Object)extraItemStorageVariant);
            StorageContainerUpgradeRecipeBuilder.shapeless(storageBlock).disk(Ingredient.of((ItemLike[])hashSet.toArray(new ItemLike[0]))).part(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)Registration.ITEM_STORAGE_PART.get((Object)extraItemStorageVariant)})).save(recipeOutput);
            hashSet.add(storageBlock);
            ++var6_17;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void registerFluidStorageUpgrades(RecipeOutput recipeOutput) {
        void var6_17;
        void var6_15;
        int n;
        HashSet<Object> disks = new HashSet<Object>();
        FluidStorageVariant[] fluidStorageVariantArray = FluidStorageVariant.values();
        int n2 = fluidStorageVariantArray.length;
        for (n = 0; n < n2; ++n) {
            FluidStorageVariant fluidStorageVariant = fluidStorageVariantArray[n];
            if (fluidStorageVariant == FluidStorageVariant.CREATIVE) continue;
            disks.add(com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getFluidStorageDisk(fluidStorageVariant));
        }
        for (ExtraFluidStorageVariant extraFluidStorageVariant : ExtraFluidStorageVariant.values()) {
            DeferredItem<ExtraFluidStorageDiskItem> deferredItem = Registration.FLUID_STORAGE_DISK.get((Object)extraFluidStorageVariant);
            StorageContainerUpgradeRecipeBuilder.shapeless(deferredItem).disk(Ingredient.of((ItemLike[])disks.toArray(new ItemLike[0]))).part(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)Registration.FLUID_STORAGE_PART.get((Object)extraFluidStorageVariant)})).save(recipeOutput);
            disks.add(deferredItem);
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        FluidStorageVariant[] fluidStorageVariantArray2 = FluidStorageVariant.values();
        n = fluidStorageVariantArray2.length;
        boolean bl = false;
        while (var6_15 < n) {
            FluidStorageVariant fluidStorageVariant = fluidStorageVariantArray2[var6_15];
            if (fluidStorageVariant != FluidStorageVariant.CREATIVE) {
                hashSet.add(Blocks.INSTANCE.getFluidStorageBlock(fluidStorageVariant));
            }
            ++var6_15;
        }
        ExtraFluidStorageVariant[] extraFluidStorageVariantArray = ExtraFluidStorageVariant.values();
        n = extraFluidStorageVariantArray.length;
        boolean bl2 = false;
        while (var6_17 < n) {
            ExtraFluidStorageVariant extraFluidStorageVariant = extraFluidStorageVariantArray[var6_17];
            DeferredBlock<Block> storageBlock = Registration.FLUID_STORAGE_BLOCK.get((Object)extraFluidStorageVariant);
            StorageContainerUpgradeRecipeBuilder.shapeless(storageBlock).disk(Ingredient.of((ItemLike[])hashSet.toArray(new ItemLike[0]))).part(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)Registration.FLUID_STORAGE_PART.get((Object)extraFluidStorageVariant)})).save(recipeOutput);
            hashSet.add(storageBlock);
            ++var6_17;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void registerChemicalStorageUpgrades(RecipeOutput recipeOutput) {
        void var6_17;
        void var6_15;
        int n;
        HashSet<Object> disks = new HashSet<Object>();
        ChemicalStorageVariant[] chemicalStorageVariantArray = ChemicalStorageVariant.values();
        int n2 = chemicalStorageVariantArray.length;
        for (n = 0; n < n2; ++n) {
            ChemicalStorageVariant chemicalStorageVariant = chemicalStorageVariantArray[n];
            if (chemicalStorageVariant == ChemicalStorageVariant.CREATIVE) continue;
            disks.add(Items.getChemicalStorageDisk((ChemicalStorageVariant)chemicalStorageVariant));
        }
        for (ExtraChemicalStorageVariant extraChemicalStorageVariant : ExtraChemicalStorageVariant.values()) {
            DeferredItem<ExtraChemicalStorageDiskItem> deferredItem = Registration.CHEMICAL_STORAGE_DISK.get((Object)extraChemicalStorageVariant);
            StorageContainerUpgradeRecipeBuilder.shapeless(deferredItem).disk(Ingredient.of((ItemLike[])disks.toArray(new ItemLike[0]))).part(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)Registration.CHEMICAL_STORAGE_PART.get((Object)extraChemicalStorageVariant)})).save(recipeOutput);
            disks.add(deferredItem);
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        ChemicalStorageVariant[] chemicalStorageVariantArray2 = ChemicalStorageVariant.values();
        n = chemicalStorageVariantArray2.length;
        boolean bl = false;
        while (var6_15 < n) {
            ChemicalStorageVariant chemicalStorageVariant = chemicalStorageVariantArray2[var6_15];
            if (chemicalStorageVariant != ChemicalStorageVariant.CREATIVE) {
                hashSet.add(com.refinedmods.refinedstorage.mekanism.content.Blocks.getChemicalStorageBlock((ChemicalStorageVariant)chemicalStorageVariant));
            }
            ++var6_15;
        }
        ExtraChemicalStorageVariant[] extraChemicalStorageVariantArray = ExtraChemicalStorageVariant.values();
        n = extraChemicalStorageVariantArray.length;
        boolean bl2 = false;
        while (var6_17 < n) {
            ExtraChemicalStorageVariant extraChemicalStorageVariant = extraChemicalStorageVariantArray[var6_17];
            DeferredBlock<Block> storageBlock = Registration.CHEMICAL_STORAGE_BLOCK.get((Object)extraChemicalStorageVariant);
            StorageContainerUpgradeRecipeBuilder.shapeless(storageBlock).disk(Ingredient.of((ItemLike[])hashSet.toArray(new ItemLike[0]))).part(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)Registration.CHEMICAL_STORAGE_PART.get((Object)extraChemicalStorageVariant)})).save(recipeOutput);
            hashSet.add(storageBlock);
            ++var6_17;
        }
    }
}

