/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.extradisks.data;

import com.refinedmods.refinedstorage.common.content.Tags;
import de.melanx.extradisks.Registration;
import de.melanx.extradisks.content.chemical.ExtraChemicalStorageVariant;
import de.melanx.extradisks.content.fluid.ExtraFluidStorageVariant;
import de.melanx.extradisks.content.item.ExtraItemStorageVariant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModTags {

    public static class ItemTags
    extends ItemTagsProvider {
        public ItemTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTags, ExistingFileHelper helper) {
            super(output, lookupProvider, blockTags, "extradisks", helper);
        }

        protected void addTags(@Nonnull HolderLookup.Provider provider) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender itemPartsBuilder = this.tag(Items.ITEM_PARTS);
            IntrinsicHolderTagsProvider.IntrinsicTagAppender itemDisksBuilder = this.tag(Items.ITEM_DISKS);
            for (ExtraItemStorageVariant variant : ExtraItemStorageVariant.values()) {
                TagKey<Item> tag = Items.PARTS_ITEM.get((Object)variant);
                this.tag(tag).add((Object)((Item)Registration.ITEM_STORAGE_PART.get((Object)variant).get()));
                itemPartsBuilder.addTag(tag);
                tag = Items.DISKS_ITEM.get((Object)variant);
                this.tag(tag).add((Object)((Item)Registration.ITEM_STORAGE_DISK.get((Object)variant).get()));
                itemDisksBuilder.addTag(tag);
            }
            IntrinsicHolderTagsProvider.IntrinsicTagAppender fluidPartsBuilder = this.tag(Items.FLUID_PARTS);
            IntrinsicHolderTagsProvider.IntrinsicTagAppender fluidDisksBuilder = this.tag(Items.FLUID_DISKS);
            for (ExtraFluidStorageVariant variant : ExtraFluidStorageVariant.values()) {
                TagKey<Item> tag = Items.PARTS_FLUID.get((Object)variant);
                this.tag(tag).add((Object)((Item)Registration.FLUID_STORAGE_PART.get((Object)variant).get()));
                fluidPartsBuilder.addTag(tag);
                tag = Items.DISKS_FLUID.get((Object)variant);
                this.tag(tag).add((Object)((Item)Registration.FLUID_STORAGE_DISK.get((Object)variant).get()));
                fluidDisksBuilder.addTag(tag);
            }
            IntrinsicHolderTagsProvider.IntrinsicTagAppender chemicalPartsBuilder = this.tag(Items.CHEMICAL_PARTS);
            IntrinsicHolderTagsProvider.IntrinsicTagAppender chemicalDisksBuilder = this.tag(Items.CHEMICAL_DISKS);
            for (ExtraChemicalStorageVariant extraChemicalStorageVariant : ExtraChemicalStorageVariant.values()) {
                TagKey<Item> tag = Items.PARTS_CHEMICAL.get((Object)extraChemicalStorageVariant);
                this.tag(tag).addOptional(Registration.CHEMICAL_STORAGE_PART.get((Object)extraChemicalStorageVariant).getId());
                chemicalPartsBuilder.addOptionalTag(tag);
                tag = Items.DISKS_CHEMICAL.get((Object)extraChemicalStorageVariant);
                this.tag(tag).addOptional(Registration.CHEMICAL_STORAGE_DISK.get((Object)extraChemicalStorageVariant).getId());
                chemicalDisksBuilder.addOptionalTag(tag);
            }
            this.tag(Items.PARTS).addTags(new TagKey[]{Items.ITEM_PARTS, Items.FLUID_PARTS, Items.CHEMICAL_PARTS});
            this.tag(Items.DISKS).addTags(new TagKey[]{Items.ITEM_DISKS, Items.FLUID_DISKS, Items.CHEMICAL_DISKS});
            this.tag(Tags.STORAGE_DISKS).addTag(Items.ITEM_DISKS);
            this.tag(Tags.FLUID_STORAGE_DISKS).addTag(Items.FLUID_DISKS);
            this.tag(Items.CHEMICAL_STORAGE_DISKS).addOptionalTag(Items.CHEMICAL_DISKS);
            this.copy(Blocks.ITEM_STORAGE_BLOCKS, Items.ITEM_STORAGE_BLOCKS);
            for (Enum enum_ : ExtraItemStorageVariant.values()) {
                this.copy(Blocks.STORAGE_BLOCKS_ITEM.get(enum_), Items.STORAGE_BLOCKS_ITEM.get(enum_));
            }
            this.copy(Blocks.FLUID_STORAGE_BLOCKS, Items.FLUID_STORAGE_BLOCKS);
            for (Enum enum_ : ExtraFluidStorageVariant.values()) {
                this.copy(Blocks.STORAGE_BLOCKS_FLUID.get(enum_), Items.STORAGE_BLOCKS_FLUID.get(enum_));
            }
            this.copy(Blocks.CHEMICAL_STORAGE_BLOCKS, Items.CHEMICAL_STORAGE_BLOCKS);
            for (Enum enum_ : ExtraChemicalStorageVariant.values()) {
                this.copy(Blocks.STORAGE_BLOCKS_CHEMICAL.get(enum_), Items.STORAGE_BLOCKS_CHEMICAL.get(enum_));
            }
            this.copy(Blocks.STORAGE_BLOCKS, Items.STORAGE_BLOCKS);
        }
    }

    public static class BlockTags
    extends BlockTagsProvider {
        public BlockTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper helper) {
            super(output, lookupProvider, "extradisks", helper);
        }

        protected void addTags(@Nonnull HolderLookup.Provider provider) {
            IntrinsicHolderTagsProvider.IntrinsicTagAppender itemBlocksBuilder = this.tag(Blocks.ITEM_STORAGE_BLOCKS);
            for (ExtraItemStorageVariant variant : ExtraItemStorageVariant.values()) {
                TagKey<Block> tag = Blocks.STORAGE_BLOCKS_ITEM.get((Object)variant);
                this.tag(tag).add((Object)((Block)Registration.ITEM_STORAGE_BLOCK.get((Object)variant).get()));
                itemBlocksBuilder.addTag(tag);
            }
            IntrinsicHolderTagsProvider.IntrinsicTagAppender fluidBlocksBuilder = this.tag(Blocks.FLUID_STORAGE_BLOCKS);
            for (ExtraFluidStorageVariant variant : ExtraFluidStorageVariant.values()) {
                TagKey<Block> tag = Blocks.STORAGE_BLOCKS_FLUID.get((Object)variant);
                this.tag(tag).add((Object)((Block)Registration.FLUID_STORAGE_BLOCK.get((Object)variant).get()));
                fluidBlocksBuilder.addTag(tag);
            }
            IntrinsicHolderTagsProvider.IntrinsicTagAppender chemicalBlocksBuilder = this.tag(Blocks.CHEMICAL_STORAGE_BLOCKS);
            for (ExtraChemicalStorageVariant variant : ExtraChemicalStorageVariant.values()) {
                TagKey<Block> tag = Blocks.STORAGE_BLOCKS_CHEMICAL.get((Object)variant);
                this.tag(tag).addOptional(Registration.CHEMICAL_STORAGE_BLOCK.get((Object)variant).getId());
                chemicalBlocksBuilder.addOptionalTag(tag);
            }
            this.tag(Blocks.STORAGE_BLOCKS).addTags(new TagKey[]{Blocks.ITEM_STORAGE_BLOCKS, Blocks.FLUID_STORAGE_BLOCKS});
            this.tag(Blocks.STORAGE_BLOCKS).addOptionalTag(Blocks.CHEMICAL_STORAGE_BLOCKS);
        }
    }

    public static class Items {
        public static final TagKey<Item> STORAGE_BLOCKS = Items.tag("storage_blocks");
        public static final TagKey<Item> ITEM_STORAGE_BLOCKS = Items.tag("storage_blocks/items");
        public static final TagKey<Item> FLUID_STORAGE_BLOCKS = Items.tag("storage_blocks/fluids");
        public static final TagKey<Item> CHEMICAL_STORAGE_BLOCKS = Items.tag("storage_blocks/chemical");
        public static final Map<ExtraItemStorageVariant, TagKey<Item>> STORAGE_BLOCKS_ITEM = new HashMap<ExtraItemStorageVariant, TagKey<Item>>();
        public static final Map<ExtraFluidStorageVariant, TagKey<Item>> STORAGE_BLOCKS_FLUID = new HashMap<ExtraFluidStorageVariant, TagKey<Item>>();
        public static final Map<ExtraChemicalStorageVariant, TagKey<Item>> STORAGE_BLOCKS_CHEMICAL = new HashMap<ExtraChemicalStorageVariant, TagKey<Item>>();
        public static final TagKey<Item> PARTS = Items.tag("parts");
        public static final TagKey<Item> ITEM_PARTS = Items.tag("parts/items");
        public static final TagKey<Item> FLUID_PARTS = Items.tag("parts/fluids");
        public static final TagKey<Item> CHEMICAL_PARTS = Items.tag("parts/chemical");
        public static final Map<ExtraItemStorageVariant, TagKey<Item>> PARTS_ITEM = new HashMap<ExtraItemStorageVariant, TagKey<Item>>();
        public static final Map<ExtraFluidStorageVariant, TagKey<Item>> PARTS_FLUID = new HashMap<ExtraFluidStorageVariant, TagKey<Item>>();
        public static final Map<ExtraChemicalStorageVariant, TagKey<Item>> PARTS_CHEMICAL = new HashMap<ExtraChemicalStorageVariant, TagKey<Item>>();
        public static final TagKey<Item> DISKS = Items.tag("disks");
        public static final TagKey<Item> ITEM_DISKS = Items.tag("disks/items");
        public static final TagKey<Item> FLUID_DISKS = Items.tag("disks/fluids");
        public static final TagKey<Item> CHEMICAL_DISKS = Items.tag("disks/chemical");
        public static final Map<ExtraItemStorageVariant, TagKey<Item>> DISKS_ITEM = new HashMap<ExtraItemStorageVariant, TagKey<Item>>();
        public static final Map<ExtraFluidStorageVariant, TagKey<Item>> DISKS_FLUID = new HashMap<ExtraFluidStorageVariant, TagKey<Item>>();
        public static final Map<ExtraChemicalStorageVariant, TagKey<Item>> DISKS_CHEMICAL = new HashMap<ExtraChemicalStorageVariant, TagKey<Item>>();
        public static final TagKey<Item> OSMIUM_INGOTS = net.minecraft.tags.ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ingots/osmium"));
        public static final TagKey<Item> CHEMICAL_STORAGE_DISKS = net.minecraft.tags.ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"refinedstorage_mekanism_integration", (String)"chemical_storage_disks"));

        private static TagKey<Item> tag(String name) {
            return net.minecraft.tags.ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"refinedstorage", (String)name));
        }

        static {
            for (ExtraItemStorageVariant extraItemStorageVariant : ExtraItemStorageVariant.values()) {
                STORAGE_BLOCKS_ITEM.put(extraItemStorageVariant, Items.tag("storage_blocks/items/" + extraItemStorageVariant.getName()));
                PARTS_ITEM.put(extraItemStorageVariant, Items.tag("parts/items/" + extraItemStorageVariant.getName()));
                DISKS_ITEM.put(extraItemStorageVariant, Items.tag("disks/items/" + extraItemStorageVariant.getName()));
            }
            for (Enum enum_ : ExtraFluidStorageVariant.values()) {
                STORAGE_BLOCKS_FLUID.put((ExtraFluidStorageVariant)enum_, Items.tag("storage_blocks/fluids/" + ((ExtraFluidStorageVariant)enum_).getName()));
                PARTS_FLUID.put((ExtraFluidStorageVariant)enum_, Items.tag("parts/fluids/" + ((ExtraFluidStorageVariant)enum_).getName()));
                DISKS_FLUID.put((ExtraFluidStorageVariant)enum_, Items.tag("disks/fluids/" + ((ExtraFluidStorageVariant)enum_).getName()));
            }
            for (Enum enum_ : ExtraChemicalStorageVariant.values()) {
                STORAGE_BLOCKS_CHEMICAL.put((ExtraChemicalStorageVariant)enum_, Items.tag("storage_blocks/chemical/" + ((ExtraChemicalStorageVariant)enum_).getName()));
                PARTS_CHEMICAL.put((ExtraChemicalStorageVariant)enum_, Items.tag("parts/chemical/" + ((ExtraChemicalStorageVariant)enum_).getName()));
                DISKS_CHEMICAL.put((ExtraChemicalStorageVariant)enum_, Items.tag("disks/chemical/" + ((ExtraChemicalStorageVariant)enum_).getName()));
            }
        }
    }

    public static class Blocks {
        public static final TagKey<Block> STORAGE_BLOCKS = Blocks.tag("storage_blocks");
        public static final TagKey<Block> ITEM_STORAGE_BLOCKS = Blocks.tag("storage_blocks/items");
        public static final TagKey<Block> FLUID_STORAGE_BLOCKS = Blocks.tag("storage_blocks/fluids");
        public static final TagKey<Block> CHEMICAL_STORAGE_BLOCKS = Blocks.tag("storage_blocks/chemical");
        public static final Map<ExtraItemStorageVariant, TagKey<Block>> STORAGE_BLOCKS_ITEM = new HashMap<ExtraItemStorageVariant, TagKey<Block>>();
        public static final Map<ExtraFluidStorageVariant, TagKey<Block>> STORAGE_BLOCKS_FLUID = new HashMap<ExtraFluidStorageVariant, TagKey<Block>>();
        public static final Map<ExtraChemicalStorageVariant, TagKey<Block>> STORAGE_BLOCKS_CHEMICAL = new HashMap<ExtraChemicalStorageVariant, TagKey<Block>>();

        private static TagKey<Block> tag(String name) {
            return net.minecraft.tags.BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"refinedstorage", (String)name));
        }

        static {
            for (ExtraItemStorageVariant extraItemStorageVariant : ExtraItemStorageVariant.values()) {
                STORAGE_BLOCKS_ITEM.put(extraItemStorageVariant, Blocks.tag("storage_blocks/items/" + extraItemStorageVariant.getName()));
            }
            for (Enum enum_ : ExtraFluidStorageVariant.values()) {
                STORAGE_BLOCKS_FLUID.put((ExtraFluidStorageVariant)enum_, Blocks.tag("storage_blocks/fluids/" + ((ExtraFluidStorageVariant)enum_).getName()));
            }
            for (Enum enum_ : ExtraChemicalStorageVariant.values()) {
                STORAGE_BLOCKS_CHEMICAL.put((ExtraChemicalStorageVariant)enum_, Blocks.tag("storage_blocks/chemical/" + ((ExtraChemicalStorageVariant)enum_).getName()));
            }
        }
    }
}

