/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.extradisks.content.fluid;

import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.storage.AbstractStorageContainerItem;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.storage.StorageTypes;
import com.refinedmods.refinedstorage.common.storage.StorageVariant;
import com.refinedmods.refinedstorage.common.storage.UpgradeableStorageContainer;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import de.melanx.extradisks.Registration;
import de.melanx.extradisks.content.fluid.ExtraFluidStorageVariant;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ExtraFluidStorageDiskItem
extends AbstractStorageContainerItem
implements UpgradeableStorageContainer {
    private final ExtraFluidStorageVariant variant;
    private final Component helpText;

    public ExtraFluidStorageDiskItem(ExtraFluidStorageVariant variant) {
        super(new Item.Properties().stacksTo(1), RefinedStorageApi.INSTANCE.getStorageContainerItemHelper());
        this.variant = variant;
        this.helpText = variant.getCapacity() == null ? IdentifierUtil.createTranslation((String)"item", (String)"creative_fluid_storage_disk.help") : IdentifierUtil.createTranslation((String)"item", (String)"fluid_storage_disk.help", (Object[])new Object[]{IdentifierUtil.format((long)variant.getCapacity())});
    }

    @Nullable
    protected Long getCapacity() {
        return this.variant.getCapacity();
    }

    @Nonnull
    protected String formatAmount(long amount) {
        return RefinedStorageClientApi.INSTANCE.getResourceRendering(FluidResource.class).formatAmount(amount);
    }

    @Nonnull
    protected SerializableStorage createStorage(@Nonnull StorageRepository storageRepository) {
        return StorageTypes.FLUID.create(this.variant.getCapacity(), () -> ((StorageRepository)storageRepository).markAsChanged());
    }

    @Nonnull
    protected ItemStack createPrimaryDisassemblyByproduct(int count) {
        return new ItemStack((ItemLike)Registration.ADVANCED_STORAGE_HOUSING.asItem(), count);
    }

    @Nullable
    protected ItemStack createSecondaryDisassemblyByproduct(int count) {
        return new ItemStack((ItemLike)Registration.FLUID_STORAGE_PART.get((Object)this.variant).asItem(), count);
    }

    @Nonnull
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new HelpTooltipComponent(this.helpText));
    }

    @Nonnull
    public StorageVariant getVariant() {
        return this.variant;
    }

    public void transferTo(@Nonnull ItemStack from, @Nonnull ItemStack to) {
        this.helper.markAsToTransfer(from, to);
    }
}

