/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.jei;

import com.glodblock.github.modularbees.ModularBees;
import com.glodblock.github.modularbees.common.MBSingletons;
import com.glodblock.github.modularbees.common.recipe.ElectrodeRecipe;
import com.glodblock.github.modularbees.common.recipe.TreaterRecipe;
import com.glodblock.github.modularbees.jei.MBElectrodeCategory;
import com.glodblock.github.modularbees.jei.MBTreaterCategory;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return ModularBees.id("jei_plugin");
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registry) {
        IGuiHelper helpers = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new MBTreaterCategory(helpers)});
        registry.addRecipeCategories(new IRecipeCategory[]{new MBElectrodeCategory(helpers)});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registry) {
        assert (Minecraft.getInstance().level != null);
        RecipeManager manager = Minecraft.getInstance().level.getRecipeManager();
        registry.addRecipes(MBTreaterCategory.RECIPE_TYPE, this.getRecipes(TreaterRecipe.TYPE, manager));
        registry.addRecipes(MBElectrodeCategory.RECIPE_TYPE, this.getRecipes(ElectrodeRecipe.TYPE, manager));
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst((ItemLike)MBSingletons.MODULAR_TREATER, new RecipeType[]{MBTreaterCategory.RECIPE_TYPE});
        registry.addRecipeCatalyst((ItemLike)MBSingletons.MODULAR_BEEHIVE_OVERCLOCKER, new RecipeType[]{MBElectrodeCategory.RECIPE_TYPE});
    }

    private <I extends RecipeInput, T extends Recipe<I>> List<RecipeHolder<T>> getRecipes(net.minecraft.world.item.crafting.RecipeType<T> type, RecipeManager manager) {
        return manager.getAllRecipesFor(type);
    }
}

