/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.container.base;

import com.glodblock.github.glodium.network.packet.IMessage;
import com.glodblock.github.glodium.network.packet.sync.ActionMap;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import com.glodblock.github.modularbees.common.inventory.MBItemInventory;
import com.glodblock.github.modularbees.common.tileentities.base.TileMBBase;
import com.glodblock.github.modularbees.container.slot.DisplaySlot;
import com.glodblock.github.modularbees.container.slot.MBInventorySlot;
import com.glodblock.github.modularbees.network.MBNetworkHandler;
import com.glodblock.github.modularbees.network.SMBGenericPacket;
import com.glodblock.github.modularbees.util.ContainerResolver;
import com.glodblock.github.modularbees.util.DirtyFieldMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContainerMBBase<T extends TileMBBase>
extends AbstractContainerMenu
implements IActionHolder {
    private final T host;
    private final Inventory playerInventory;
    private final DirtyFieldMap syncMap = new DirtyFieldMap();
    private ContainerResolver resolver;
    private boolean valid = true;
    private final ActionMap actions = ActionMap.create();

    protected ContainerMBBase(@Nullable MenuType<?> type, int id, Inventory inv, T host) {
        super(type, id);
        this.host = host;
        this.playerInventory = inv;
    }

    public void setResolver(ContainerResolver resolver) {
        this.resolver = resolver;
    }

    protected ContainerResolver getResolver() {
        return this.resolver;
    }

    public T getHost() {
        return this.host;
    }

    public void invalidate() {
        this.valid = false;
    }

    protected DirtyFieldMap getSync() {
        return this.syncMap;
    }

    public void receiveUpdate(RegistryFriendlyByteBuf buf) {
        this.syncMap.fieldSync(buf);
    }

    protected final void bindPlayerInventorySlots(Inventory inventory) {
        for (int i = 0; i < inventory.items.size(); ++i) {
            int hotBarOffset;
            int x = i % 9;
            int y = i / 9;
            int n = hotBarOffset = i < Inventory.getSelectionSize() ? 0 : 4;
            if (y > 0) {
                y = 4 - y;
            }
            Slot slot = new Slot((Container)inventory, i, x * 18 + this.playerLeftOffset(), -y * 18 - hotBarOffset + this.getHeight() - this.playerBottomOffset());
            this.addSlot(slot);
        }
    }

    protected void addItemHandlerSlot(@Nullable IItemHandler handler, int posX, int posY, int columns) {
        if (handler == null) {
            return;
        }
        for (int index = 0; index < handler.getSlots(); ++index) {
            int x = index % columns;
            int y = index / columns;
            if (handler instanceof MBItemInventory) {
                MBItemInventory inv = (MBItemInventory)handler;
                this.addSlot((Slot)new MBInventorySlot(inv, index, posX + x * 18, posY + y * 18));
                continue;
            }
            this.addSlot((Slot)new SlotItemHandler(handler, index, posX + x * 18, posY + y * 18));
        }
    }

    protected Slot addSlot(@Nullable IItemHandler handler, int index, int posX, int posY) {
        if (handler == null) {
            return null;
        }
        if (handler instanceof MBItemInventory) {
            MBItemInventory inv = (MBItemInventory)handler;
            return this.addSlot((Slot)new MBInventorySlot(inv, index, posX, posY));
        }
        return this.addSlot((Slot)new SlotItemHandler(handler, index, posX, posY));
    }

    protected int playerBottomOffset() {
        return 24;
    }

    protected int playerLeftOffset() {
        return 8;
    }

    protected abstract int getHeight();

    protected abstract int getWidth();

    public void sendAllDataToRemote() {
        Player player;
        super.sendAllDataToRemote();
        if (!this.syncMap.isEmpty() && (player = this.getPlayer()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            MBNetworkHandler.INSTANCE.sendTo(this.syncMap.sendFullPacket(this.containerId), player2);
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int idx) {
        if (this.isClientSide()) {
            return ItemStack.EMPTY;
        }
        Slot clickSlot = (Slot)this.slots.get(idx);
        if (!clickSlot.mayPickup(player)) {
            return ItemStack.EMPTY;
        }
        ItemStack stackToMove = clickSlot.getItem();
        if (stackToMove.isEmpty()) {
            return ItemStack.EMPTY;
        }
        stackToMove = clickSlot.getItem();
        if (stackToMove.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack originalStackToMove = stackToMove.copy();
        if (!ItemStack.matches((ItemStack)originalStackToMove, (ItemStack)(stackToMove = this.quickMoveToOtherSlots(stackToMove, this.isPlayerSideSlot(clickSlot))))) {
            clickSlot.setByPlayer(stackToMove.isEmpty() ? ItemStack.EMPTY : stackToMove);
        }
        return ItemStack.EMPTY;
    }

    private ItemStack quickMoveToOtherSlots(ItemStack stackToMove, boolean fromPlayerSide) {
        List<Slot> destinationSlots = this.getQuickMoveDestinationSlots(stackToMove, fromPlayerSide);
        if (destinationSlots.isEmpty() && fromPlayerSide) {
            for (Slot cs : this.slots) {
                if (!(cs instanceof DisplaySlot) || this.isPlayerSideSlot(cs)) continue;
                ItemStack destination = cs.getItem();
                if (ItemStack.isSameItemSameComponents((ItemStack)destination, (ItemStack)stackToMove)) break;
                if (!destination.isEmpty()) continue;
                cs.set(stackToMove.copy());
                this.broadcastChanges();
                break;
            }
            return stackToMove;
        }
        for (Slot dest : destinationSlots) {
            if (!dest.hasItem() || !(stackToMove = dest.safeInsert(stackToMove)).isEmpty()) continue;
            return stackToMove;
        }
        for (Slot dest : destinationSlots) {
            if (dest.hasItem() || !(stackToMove = dest.safeInsert(stackToMove)).isEmpty()) continue;
            return stackToMove;
        }
        return stackToMove;
    }

    protected List<Slot> getQuickMoveDestinationSlots(ItemStack stackToMove, boolean fromPlayerSide) {
        ArrayList<Slot> destinationSlots = new ArrayList<Slot>();
        for (Slot candidateSlot : this.slots) {
            if (!this.isValidQuickMoveDestination(candidateSlot, stackToMove, fromPlayerSide)) continue;
            destinationSlots.add(candidateSlot);
        }
        destinationSlots.sort(Comparator.comparingInt(this::getSlotSortIndex));
        return destinationSlots;
    }

    protected int getSlotSortIndex(Slot slot) {
        return slot.getSlotIndex();
    }

    protected boolean isValidQuickMoveDestination(Slot candidateSlot, ItemStack stackToMove, boolean fromPlayerSide) {
        return this.isPlayerSideSlot(candidateSlot) != fromPlayerSide && !(candidateSlot instanceof DisplaySlot) && candidateSlot.mayPlace(stackToMove);
    }

    protected boolean isPlayerSideSlot(Slot slot) {
        return slot.container == this.playerInventory;
    }

    public boolean stillValid(@NotNull Player player) {
        return this.valid;
    }

    public void broadcastChanges() {
        if (!this.valid) {
            return;
        }
        if (this.isServerSide()) {
            Player player;
            if (this.host.getLevel().getBlockEntity(this.host.getBlockPos()) != this.host) {
                this.invalidate();
            }
            if (this.syncMap.needSync() && (player = this.getPlayer()) instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MBNetworkHandler.INSTANCE.sendTo(this.syncMap.sendDeltaPacket(this.containerId), player2);
            }
        }
        super.broadcastChanges();
    }

    public boolean isClientSide() {
        return this.getPlayer().getCommandSenderWorld().isClientSide();
    }

    public boolean isServerSide() {
        return !this.isClientSide();
    }

    public Player getPlayer() {
        return this.getPlayerInventory().player;
    }

    public Inventory getPlayerInventory() {
        return this.playerInventory;
    }

    public void sendAction(String id, Object ... paras) {
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            MBNetworkHandler.INSTANCE.sendTo((IMessage)new SMBGenericPacket(id, paras), player2);
        }
    }

    @NotNull
    public ActionMap getActionMap() {
        return this.actions;
    }
}

