/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.tileentities.misc;

import com.glodblock.github.glodium.util.GlodUtil;
import com.glodblock.github.modularbees.common.MBConfig;
import com.glodblock.github.modularbees.common.MBSingletons;
import com.glodblock.github.modularbees.common.inventory.MBItemInventory;
import com.glodblock.github.modularbees.common.tileentities.base.TileMBMachine;
import com.glodblock.github.modularbees.util.GameUtil;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.common.item.GeneBottle;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TileBeeExtractor
extends TileMBMachine {
    public TileBeeExtractor(BlockPos pos, BlockState state) {
        super(GlodUtil.getTileType(TileBeeExtractor.class, TileBeeExtractor::new, (Block)MBSingletons.BEE_EXTRACTOR), pos, state);
    }

    @Override
    protected MBItemInventory createInputs() {
        return new MBItemInventory(this, 2).setFilter(BeeCage::isFilled, 0).setFilter(MBItemInventory.ItemFilter.of(Items.GLASS_BOTTLE), 1).inputOnly();
    }

    @Override
    protected MBItemInventory createOutputs() {
        return new MBItemInventory(this, 2).outputOnly();
    }

    @Override
    protected Set<Item> validUpgrades() {
        return TIME_UPGRADES;
    }

    @Override
    protected int getMaxProcessTime() {
        return (Integer)MBConfig.BEE_EXTRACTOR_TIME.get();
    }

    @Override
    protected int getPowerUse() {
        return (Integer)MBConfig.BEE_EXTRACTOR_POWER_USAGE.get();
    }

    @Override
    protected int checkStatus() {
        ItemStack cage = this.inputs.getStackInSlot(0);
        if (cage.isEmpty()) {
            return 2;
        }
        ItemStack bottle = this.inputs.getStackInSlot(1);
        if (bottle.isEmpty()) {
            return 2;
        }
        Bee bee = BeeCage.getEntityFromStack((ItemStack)cage, (Level)this.level, (boolean)true);
        if (bee == null || bee.getAge() < 0) {
            return 2;
        }
        ItemStack gene = GeneBottle.getStack((Entity)bee);
        ItemStack empty = GameUtil.emptyCage(cage);
        if (this.outputs.forceInsertItem(0, gene, true).isEmpty() && this.outputs.forceInsertItem(1, empty, true).isEmpty()) {
            return 1;
        }
        return 2;
    }

    @Override
    protected void runRecipe() {
        ItemStack cage = this.inputs.getStackInSlot(0);
        ItemStack bottle = this.inputs.getStackInSlot(1);
        Bee bee = BeeCage.getEntityFromStack((ItemStack)cage, (Level)this.level, (boolean)true);
        if (bee == null || bee.getAge() < 0 || bottle.isEmpty()) {
            return;
        }
        this.inputs.forceExtractItem(0, 1, false);
        this.inputs.forceExtractItem(1, 1, false);
        ItemStack gene = GeneBottle.getStack((Entity)bee);
        ItemStack empty = GameUtil.emptyCage(cage);
        this.outputs.forceInsertItem(0, gene, false);
        this.outputs.forceInsertItem(1, empty, false);
    }
}

