/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.tileentities.centrifuge;

import com.glodblock.github.glodium.util.GlodUtil;
import com.glodblock.github.modularbees.common.MBSingletons;
import com.glodblock.github.modularbees.common.blocks.centrifuge.Centrifuge;
import com.glodblock.github.modularbees.common.caps.FluidHandlerHost;
import com.glodblock.github.modularbees.common.caps.ItemHandlerHost;
import com.glodblock.github.modularbees.common.inventory.MBFluidInventory;
import com.glodblock.github.modularbees.common.inventory.MBItemInventory;
import com.glodblock.github.modularbees.common.inventory.RandomAccessTank;
import com.glodblock.github.modularbees.common.inventory.SlotListener;
import com.glodblock.github.modularbees.common.inventory.TankListener;
import com.glodblock.github.modularbees.common.tileentities.base.TileMBModularComponent;
import com.glodblock.github.modularbees.common.tileentities.base.TileMBModularCore;
import com.glodblock.github.modularbees.common.tileentities.centrifuge.TileCentrifugeGearbox;
import com.glodblock.github.modularbees.common.tileentities.centrifuge.TileCentrifugeHeater;
import com.glodblock.github.modularbees.common.tileentities.centrifuge.TileCentrifugeImport;
import com.glodblock.github.modularbees.common.tileentities.centrifuge.TileCentrifugeOverclocker;
import com.glodblock.github.modularbees.util.CombCentrifugeLookup;
import com.glodblock.github.modularbees.util.GameUtil;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivelib.registry.LibItems;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileModularCentrifuge
extends TileMBModularCore
implements ItemHandlerHost,
FluidHandlerHost,
SlotListener,
TankListener {
    public static final int FLUID_TANKS = 3;
    public static final int WAITING_TICKS = ProductiveBeesConfig.GENERAL.centrifugeProcessingTime.getAsInt();
    @Nullable
    private ObjectSet<BlockPos> allPos;
    @Nullable
    private ObjectSet<ChunkPos> allChunk;
    public static final Set<Item> ACCEPT_UPGRADES = Set.of((Item)LibItems.UPGRADE_TIME.get(), (Item)LibItems.UPGRADE_TIME_2.get(), (Item)LibItems.UPGRADE_PRODUCTIVITY.get(), (Item)LibItems.UPGRADE_PRODUCTIVITY_2.get(), (Item)LibItems.UPGRADE_PRODUCTIVITY_3.get(), (Item)LibItems.UPGRADE_PRODUCTIVITY_4.get());
    protected final MBItemInventory upgrade = new MBItemInventory(this, 4, s -> ACCEPT_UPGRADES.contains(s.getItem())).setSlotLimit(1);
    protected final MBItemInventory inputs = new MBItemInventory(this, 3, this::validInput).inputOnly();
    protected final MBItemInventory outputs = new MBItemInventory(this, 9).outputOnly();
    private final IItemHandlerModifiable exposed = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.outputs, this.inputs});
    private final MultiTank tanks;
    private float process = 0.0f;
    private float tickSpeed = 1.0f;
    private final List<ItemStack> sending = new ArrayList<ItemStack>();
    private final List<FluidStack> filling = new ArrayList<FluidStack>();
    private boolean stuck = false;
    private int para = 1;
    private IItemHandlerModifiable combinedInputs;
    private TileCentrifugeHeater heater;

    public TileModularCentrifuge(BlockPos pos, BlockState state) {
        super(GlodUtil.getTileType(TileModularCentrifuge.class, TileModularCentrifuge::new, (Block)MBSingletons.MODULAR_CENTRIFUGE_CORE), pos, state);
        this.tanks = new MultiTank(new MBFluidInventory[]{new MBFluidInventory(this, 64000).outputOnly(), new MBFluidInventory(this, 64000).outputOnly(), new MBFluidInventory(this, 64000).outputOnly()});
    }

    private IItemHandlerModifiable getCombinedInputs() {
        if (this.combinedInputs == null) {
            ArrayList<MBItemInventory> inv = new ArrayList<MBItemInventory>();
            inv.add(this.inputs);
            for (TileCentrifugeImport input : this.getComponents(TileCentrifugeImport.class)) {
                inv.add(input.getItemInventory());
            }
            this.combinedInputs = new CombinedInvWrapper(inv.toArray(new IItemHandlerModifiable[0]));
            this.stuck = false;
        }
        return this.combinedInputs;
    }

    @Override
    protected void logicTick(@NotNull Level world, BlockState state, List<TileMBModularComponent> components) {
        if (!this.notLoaded() && !this.stuck) {
            if (!this.sending.isEmpty() || !this.filling.isEmpty()) {
                Object stack;
                int i;
                for (i = 0; i < this.sending.size(); ++i) {
                    stack = this.sending.get(i).copy();
                    for (int x = 0; x < this.outputs.getSlots() && !stack.isEmpty(); ++x) {
                        stack = this.outputs.forceInsertItem(x, (ItemStack)stack, false);
                    }
                    this.sending.set(i, (ItemStack)stack);
                }
                this.sending.removeIf(ItemStack::isEmpty);
                if (!this.sending.isEmpty()) {
                    this.stuck = true;
                    this.process = 0.0f;
                }
                for (i = 0; i < this.filling.size(); ++i) {
                    stack = this.filling.get(i).copy();
                    if (stack.isEmpty()) continue;
                    int filled = this.tanks.forceFill((FluidStack)stack, IFluidHandler.FluidAction.EXECUTE);
                    stack.shrink(filled);
                    this.filling.set(i, (FluidStack)stack);
                }
                this.filling.removeIf(FluidStack::isEmpty);
                if (!this.filling.isEmpty()) {
                    this.stuck = true;
                    this.process = 0.0f;
                }
                this.setChanged();
            }
            if (this.emptyInput()) {
                if (this.sending.isEmpty() && this.filling.isEmpty()) {
                    this.stuck = true;
                }
                this.process = 0.0f;
                return;
            }
            if (this.sending.isEmpty() && this.filling.isEmpty() && !this.stuck) {
                float overclock = 1.0f;
                if (this.heater != null) {
                    if (this.heater.check(this.para)) {
                        overclock *= 3.0f;
                    } else {
                        return;
                    }
                }
                for (TileMBModularComponent component : components) {
                    if (!(component instanceof TileCentrifugeOverclocker)) continue;
                    TileCentrifugeOverclocker overclocker = (TileCentrifugeOverclocker)component;
                    overclock += overclocker.getBoostAndConsume(1);
                }
                overclock = Math.max(1.0f, overclock);
                this.addTick(overclock);
                if (this.process >= (float)WAITING_TICKS) {
                    this.process = 0.0f;
                    int left = this.para;
                    float boost = 1.0f;
                    for (TileMBModularComponent component : components) {
                        if (!(component instanceof TileCentrifugeGearbox)) continue;
                        TileCentrifugeGearbox gearbox = (TileCentrifugeGearbox)component;
                        boost += gearbox.getBoostAndConsume();
                    }
                    boost = Math.max(1.0f, boost);
                    left = Math.round((float)left * boost);
                    for (int x = 0; x < this.getCombinedInputs().getSlots(); ++x) {
                        if (left < 0) continue;
                        ItemStack comb = this.getCombinedInputs().getStackInSlot(x);
                        int used = Math.min(left, comb.getCount());
                        if (!CombCentrifugeLookup.query(this.sending::add, this.filling::add, comb, world, used, this.heater != null)) continue;
                        left -= used;
                        comb.shrink(used);
                        this.getCombinedInputs().setStackInSlot(x, comb);
                        this.setChanged();
                    }
                    if (left == this.para) {
                        this.stuck = true;
                    }
                }
            }
        }
    }

    public List<ItemStack> getSending() {
        return this.sending;
    }

    public List<FluidStack> getFilling() {
        return this.filling;
    }

    public boolean validInput(ItemStack stack) {
        return CombCentrifugeLookup.validInput(stack, this.level);
    }

    public void addTick(float overclock) {
        this.process += this.tickSpeed * overclock;
    }

    public double getProcess() {
        return this.process;
    }

    public void setProcess(double value) {
        this.process = (float)value;
    }

    public void setTankFluid(int slot, FluidStack stack) {
        this.tanks.tanks[slot].setFluid(stack);
    }

    @Override
    public MBItemInventory getHandlerByName(String name) {
        return switch (name) {
            case "outputs" -> this.outputs;
            case "inputs" -> this.inputs;
            case "upgrade" -> this.upgrade;
            default -> null;
        };
    }

    @NotNull
    public Collection<BlockPos> getPoses() {
        if (this.allPos == null) {
            this.allPos = new ObjectOpenHashSet();
            Direction face = MBSingletons.MODULAR_CENTRIFUGE_CORE.getFacing(this.getBlockState());
            if (face == null) {
                return this.allPos;
            }
            BlockPos corePos = this.getBlockPos();
            for (int y = corePos.getY() - 1; y <= corePos.getY() + 1; ++y) {
                int lowerX;
                int upperX;
                int lowerZ;
                int upperZ;
                if (face.getAxis() == Direction.Axis.X) {
                    upperZ = corePos.getZ() + 1;
                    lowerZ = corePos.getZ() - 1;
                    upperX = corePos.getX() + (-face.getStepX() + 1);
                    lowerX = corePos.getX() - (face.getStepX() + 1);
                } else if (face.getAxis() == Direction.Axis.Z) {
                    upperZ = corePos.getZ() + (-face.getStepZ() + 1);
                    lowerZ = corePos.getZ() - (face.getStepZ() + 1);
                    upperX = corePos.getX() + 1;
                    lowerX = corePos.getX() - 1;
                } else {
                    return this.allPos;
                }
                if (y == corePos.getY() - 1) {
                    this.allPos.add((Object)new BlockPos(upperX, y, upperZ));
                    this.allPos.add((Object)new BlockPos(upperX, y, lowerZ));
                    this.allPos.add((Object)new BlockPos(lowerX, y, upperZ));
                    this.allPos.add((Object)new BlockPos(lowerX, y, lowerZ));
                    continue;
                }
                for (int x = lowerX; x <= upperX; ++x) {
                    for (int z = lowerZ; z <= upperZ; ++z) {
                        this.allPos.add((Object)new BlockPos(x, y, z));
                    }
                }
            }
        }
        return this.allPos;
    }

    @NotNull
    public Collection<ChunkPos> getChunks() {
        if (this.allChunk == null) {
            this.allChunk = new ObjectOpenHashSet();
            for (BlockPos pos : this.getPoses()) {
                this.allChunk.add((Object)new ChunkPos(pos));
            }
        }
        return this.allChunk;
    }

    @Override
    public void onStateChange() {
        this.allChunk = null;
        this.allPos = null;
        this.combinedInputs = null;
        super.onStateChange();
    }

    @Override
    public void formStructure() {
        super.formStructure();
        if (this.isFormed()) {
            this.combinedInputs = null;
            this.stuck = false;
        }
    }

    @Override
    public void saveTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        ListTag tagFluid;
        super.saveTag(data, provider);
        data.put("outputs", (Tag)this.outputs.serializeNBT(provider));
        data.put("inputs", (Tag)this.inputs.serializeNBT(provider));
        data.put("upgrade", (Tag)this.upgrade.serializeNBT(provider));
        data.put("tanks", (Tag)this.tanks.serializeNBT(provider));
        data.putFloat("process", this.process);
        ListTag tag = GameUtil.saveItemList(this.sending, provider);
        if (!tag.isEmpty()) {
            data.put("sending", (Tag)tag);
        }
        if (!(tagFluid = GameUtil.saveFluidList(this.filling, provider)).isEmpty()) {
            data.put("filling", (Tag)tagFluid);
        }
    }

    @Override
    public void loadTag(CompoundTag data, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        ListTag tag;
        super.loadTag(data, provider);
        this.outputs.deserializeNBT(provider, data.getCompound("outputs"));
        this.inputs.deserializeNBT(provider, data.getCompound("inputs"));
        this.upgrade.deserializeNBT(provider, data.getCompound("upgrade"));
        this.tanks.deserializeNBT(provider, data.getCompound("tanks"));
        this.process = data.getFloat("process");
        if (data.contains("sending")) {
            tag = data.getList("sending", 10);
            GameUtil.loadItemList(tag, provider, this.sending);
        }
        if (data.contains("filling")) {
            tag = data.getList("filling", 10);
            GameUtil.loadFluidList(tag, provider, this.filling);
        }
    }

    @Override
    public boolean isStructurePos(BlockPos pos) {
        Direction face = MBSingletons.MODULAR_CENTRIFUGE_CORE.getFacing(this.getBlockState());
        if (face == null) {
            return false;
        }
        return this.getPoses().contains(pos);
    }

    @Override
    public boolean isStructurePos(ChunkPos pos) {
        Direction face = MBSingletons.MODULAR_CENTRIFUGE_CORE.getFacing(this.getBlockState());
        if (face == null) {
            return false;
        }
        return this.getChunks().contains(pos);
    }

    @Override
    protected boolean buildStructure(Consumer<TileMBModularComponent> collector, Level world) {
        Direction face = MBSingletons.MODULAR_CENTRIFUGE_CORE.getFacing(this.getBlockState());
        this.heater = null;
        if (face == null) {
            return false;
        }
        Collection<BlockPos> poses = this.getPoses();
        if (poses.isEmpty()) {
            return false;
        }
        for (BlockPos pos : poses) {
            TileMBModularComponent centrifugePart;
            if (pos.equals((Object)this.getBlockPos())) continue;
            BlockEntity te = world.getBlockEntity(pos);
            if (te instanceof TileMBModularComponent && !(centrifugePart = (TileMBModularComponent)te).isActive()) {
                Block block = te.getBlockState().getBlock();
                if (!(block instanceof Centrifuge)) {
                    return false;
                }
                if (te instanceof TileCentrifugeHeater) {
                    TileCentrifugeHeater h = (TileCentrifugeHeater)te;
                    if (this.heater == null) {
                        this.heater = h;
                    } else {
                        return false;
                    }
                }
                collector.accept(centrifugePart);
                continue;
            }
            return false;
        }
        return true;
    }

    public void onLoad() {
        super.onLoad();
        this.updateUpgrade();
    }

    private boolean emptyInput() {
        for (int x = 0; x < this.getCombinedInputs().getSlots(); ++x) {
            ItemStack stack = this.getCombinedInputs().getStackInSlot(x);
            if (stack.isEmpty()) continue;
            if (this.heater != null) {
                return false;
            }
            if (stack.is(ModTags.Common.STORAGE_BLOCK_HONEYCOMBS)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onChange(IItemHandler inv, int slot) {
        if (inv == this.upgrade) {
            this.updateUpgrade();
        } else if (inv == this.outputs || inv == this.inputs) {
            this.stuck = false;
        }
    }

    @Override
    public void onChange(IFluidHandler tank) {
        this.stuck = false;
    }

    public void unblock() {
        this.stuck = false;
    }

    @Override
    public RandomAccessTank getFluidInventory() {
        return this.tanks;
    }

    @Override
    public IItemHandler getItemInventory() {
        return this.exposed;
    }

    @Override
    public void addInventoryDrops(Level level, @NotNull BlockPos pos, List<ItemStack> drops) {
        drops.addAll(this.outputs.toList());
        drops.addAll(this.inputs.toList());
        drops.addAll(this.upgrade.toList());
    }

    private void updateUpgrade() {
        double timeDiscount = (double)(this.upgrade.countStack((Item)LibItems.UPGRADE_TIME.get()) + 2 * this.upgrade.countStack((Item)LibItems.UPGRADE_TIME_2.get())) * (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get();
        this.tickSpeed = timeDiscount >= 1.0 ? (float)(WAITING_TICKS * 2) : (float)(1.0 / (1.0 - timeDiscount));
        this.para = 0;
        this.para += this.upgrade.countStack((Item)LibItems.UPGRADE_PRODUCTIVITY.get()) * 4;
        this.para += this.upgrade.countStack((Item)LibItems.UPGRADE_PRODUCTIVITY_2.get()) * 8;
        this.para += this.upgrade.countStack((Item)LibItems.UPGRADE_PRODUCTIVITY_3.get()) * 16;
        this.para += this.upgrade.countStack((Item)LibItems.UPGRADE_PRODUCTIVITY_4.get()) * 32;
        if (this.para <= 0) {
            this.para = 1;
        }
    }

    private record MultiTank(MBFluidInventory[] tanks) implements RandomAccessTank,
    INBTSerializable<CompoundTag>
    {
        public int getTanks() {
            return this.tanks.length;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return this.tanks[tank].getFluid();
        }

        public int getTankCapacity(int tank) {
            return this.tanks[tank].getCapacity();
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return this.tanks[tank].isFluidValid(stack);
        }

        public int fill(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
            return 0;
        }

        public int forceFill(FluidStack resource, IFluidHandler.FluidAction action) {
            int filled;
            if (resource.isEmpty()) {
                return 0;
            }
            int tot = resource.getAmount();
            for (MBFluidInventory tank : this.tanks) {
                if (resource.isEmpty()) {
                    return tot;
                }
                if (!tank.getFluid().is(resource.getFluid())) continue;
                filled = tank.forceFill(resource, action);
                resource.shrink(filled);
            }
            for (MBFluidInventory tank : this.tanks) {
                if (resource.isEmpty()) {
                    return tot;
                }
                if (!tank.getFluid().isEmpty()) continue;
                filled = tank.forceFill(resource, action);
                resource.shrink(filled);
            }
            return tot - resource.getAmount();
        }

        @NotNull
        public FluidStack drain(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
            FluidStack fluid = resource.copy();
            for (MBFluidInventory tank : this.tanks) {
                if (fluid.isEmpty()) {
                    return resource.copy();
                }
                FluidStack drained = tank.drain(fluid, action);
                fluid.shrink(drained.getAmount());
            }
            fluid.setAmount(resource.getAmount() - fluid.getAmount());
            return fluid;
        }

        @NotNull
        public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
            for (MBFluidInventory tank : this.tanks) {
                if (tank.getFluid().isEmpty()) continue;
                return this.drain(tank.getFluid().copyWithAmount(maxDrain), action);
            }
            return FluidStack.EMPTY;
        }

        public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            CompoundTag nbt = new CompoundTag();
            for (int x = 0; x < this.tanks.length; ++x) {
                if (this.tanks[x].getFluid().isEmpty()) continue;
                CompoundTag tankTag = this.tanks[x].writeToNBT(provider, new CompoundTag());
                nbt.put("#" + x, (Tag)tankTag);
            }
            return nbt;
        }

        public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
            for (int x = 0; x < this.tanks.length; ++x) {
                if (nbt.contains("#" + x, 10)) {
                    CompoundTag tankTag = nbt.getCompound("#" + x);
                    this.tanks[x].readFromNBT(provider, tankTag);
                    continue;
                }
                this.tanks[x].setFluid(FluidStack.EMPTY);
            }
        }

        @Override
        public IFluidTank getTank(int tank) {
            return this.tanks[tank];
        }
    }
}

